/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.util.Collection;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.expression.CollectionExpression;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberOfPredicate<E, C extends Collection<E>>
extends AbstractSimplePredicate {
    private final Expression<E> elementExpression;
    private final CollectionExpression<C> collectionExpression;

    public MemberOfPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<E> elementExpression, CollectionExpression<C> collectionExpression) {
        super(criteriaBuilder);
        this.elementExpression = elementExpression;
        this.collectionExpression = collectionExpression;
    }

    public MemberOfPredicate(CriteriaBuilderImpl criteriaBuilder, E element, CollectionExpression<C> collectionExpression) {
        this(criteriaBuilder, new LiteralExpression<E>(criteriaBuilder, element), collectionExpression);
    }

    public CollectionExpression<C> getCollectionExpression() {
        return this.collectionExpression;
    }

    public Expression<E> getElementExpression() {
        return this.elementExpression;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getCollectionExpression(), registry);
        ParameterContainer.Helper.possibleParameter(this.getElementExpression(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return (this.isNegated() ? "not " : "") + "member of " + this.collectionExpression.render(renderingContext);
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

