/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metrics.deployer;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationStatisticMetaMapper
extends MetaMapper<InvocationStatistics> {
    public static final CompositeMetaType TYPE;
    public static final CompositeMetaType METHOD_STATS_TYPE;
    private static String[] metaTypePropertyNames;
    private static MapCompositeMetaType VALUE_METHOD_STATS_MAP_TYPE;
    private static final String PROP_NAME_ROOT_LAST_RESET_TIME = "lastResetTime";
    private static final String PROP_NAME_ROOT_METHOD_STATS = "methodStats";
    private static final String PROP_NAME_METHODSTATS_COUNT = "count";
    private static final String PROP_NAME_METHODSTATS_MINTIME = "minTime";
    private static final String PROP_NAME_METHODSTATS_MAXTIME = "maxTime";
    private static final String PROP_NAME_METHODSTATS_TOTALTIME = "totalTime";

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return InvocationStatistics.class;
    }

    public MetaValue createMetaValue(MetaType metaType, InvocationStatistics object) {
        HashMap<String, MapCompositeValueSupport> methodMap = new HashMap<String, MapCompositeValueSupport>();
        Map stats = object.getStats();
        if (stats != null) {
            Set methods = stats.keySet();
            for (String method : methods) {
                InvocationStatistics.TimeStatistic stat = (InvocationStatistics.TimeStatistic)stats.get(method);
                MapCompositeValueSupport cvs = new MapCompositeValueSupport((MetaType)METHOD_STATS_TYPE);
                cvs.put(PROP_NAME_METHODSTATS_COUNT, (MetaValue)SimpleValueSupport.wrap((long)stat.count));
                cvs.put(PROP_NAME_METHODSTATS_MAXTIME, (MetaValue)SimpleValueSupport.wrap((long)stat.maxTime));
                cvs.put(PROP_NAME_METHODSTATS_MINTIME, (MetaValue)SimpleValueSupport.wrap((long)stat.minTime));
                cvs.put(PROP_NAME_METHODSTATS_TOTALTIME, (MetaValue)SimpleValueSupport.wrap((long)stat.totalTime));
                methodMap.put(method, cvs);
            }
        }
        MapCompositeValueSupport root = new MapCompositeValueSupport((MetaType)TYPE);
        root.put(PROP_NAME_ROOT_LAST_RESET_TIME, (MetaValue)SimpleValueSupport.wrap((long)object.lastResetTime));
        root.put(PROP_NAME_ROOT_METHOD_STATS, (MetaValue)new MapCompositeValueSupport(methodMap, (MetaType)VALUE_METHOD_STATS_MAP_TYPE));
        return root;
    }

    public InvocationStatistics unwrapMetaValue(MetaValue metaValue) {
        throw new UnsupportedOperationException(InvocationStatistics.class.getSimpleName() + " is a read-only property");
    }

    static {
        String[] methodItemNames = new String[]{PROP_NAME_METHODSTATS_COUNT, PROP_NAME_METHODSTATS_MINTIME, PROP_NAME_METHODSTATS_MAXTIME, PROP_NAME_METHODSTATS_TOTALTIME};
        String[] methodItemDescriptions = new String[]{"the number of invocations", "the minimum invocation time", "the maximum invocation time", "the total invocation time"};
        MetaType[] methodItemTypes = new MetaType[]{SimpleMetaType.LONG, SimpleMetaType.LONG, SimpleMetaType.LONG, SimpleMetaType.LONG};
        METHOD_STATS_TYPE = new ImmutableCompositeMetaType("MethodStatistics", "Method invocation statistics", methodItemNames, methodItemDescriptions, methodItemTypes);
        VALUE_METHOD_STATS_MAP_TYPE = new MapCompositeMetaType((MetaType)METHOD_STATS_TYPE);
        metaTypePropertyNames = new String[]{PROP_NAME_ROOT_LAST_RESET_TIME, PROP_NAME_ROOT_METHOD_STATS};
        String[] rootItemDescriptions = new String[]{"last time statistics were reset", "method statistics"};
        MetaType[] rootItemTypes = new MetaType[]{SimpleMetaType.LONG, VALUE_METHOD_STATS_MAP_TYPE};
        TYPE = new ImmutableCompositeMetaType("InvocationStatistics", "EJB3 invocation statistics", metaTypePropertyNames, rootItemDescriptions, rootItemTypes);
    }
}

