/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.util.Collection;
import java.util.Timer;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import org.jboss.config.ServerConfigUtil;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.resource.deployment.ActivationSpecFactory;
import org.jboss.resource.deployment.RARDeployer;
import org.jboss.resource.deployment.ResourceAdapterFactory;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.DescriptionGroupMetaData;
import org.jboss.resource.metadata.JBossRAMetaData;
import org.jboss.resource.metadata.MessageListenerMetaData;
import org.jboss.resource.metadata.RARDeploymentMetaData;
import org.jboss.system.ServiceDynamicMBeanSupport;

public class RARDeployment
extends ServiceDynamicMBeanSupport
implements BootstrapContext {
    protected DeploymentInfo di;
    protected RARDeployer deployer;
    protected RARDeploymentMetaData rdmd;
    protected ConnectorMetaData cmd;
    protected JBossRAMetaData ramd;
    protected ResourceAdapter resourceAdapter;

    public RARDeployment(DeploymentInfo di) {
        this.di = di;
        this.deployer = (RARDeployer)di.deployer;
        this.rdmd = (RARDeploymentMetaData)di.metaData;
        this.cmd = this.rdmd.getConnectorMetaData();
        this.ramd = this.rdmd.getRaXmlMetaData();
    }

    public Timer createTimer() throws UnavailableException {
        return new Timer(true);
    }

    public WorkManager getWorkManager() {
        return this.deployer.workManager;
    }

    public XATerminator getXATerminator() {
        return this.deployer.xaTerminator;
    }

    protected void startService() throws Exception {
        if (this.cmd.getLicense().getRequired()) {
            this.log.info((Object)("Required license terms exist, view META-INF/ra.xml in " + ServerConfigUtil.shortUrlFromServerHome((String)this.di.url.toString())));
            this.log.debug((Object)("License terms full URL: " + this.di.url));
        }
        this.resourceAdapter = ResourceAdapterFactory.createResourceAdapter(this.rdmd);
        this.resourceAdapter.start((BootstrapContext)this);
    }

    protected void stopService() throws Exception {
        this.resourceAdapter.stop();
    }

    protected String getInternalDescription() {
        String description = null;
        DescriptionGroupMetaData dgmd = this.cmd.getDescription();
        if (dgmd != null) {
            description = dgmd.getDescription();
        }
        if (description == null) {
            description = "RAR Deployment " + this.di.url;
        }
        return description;
    }

    protected MBeanAttributeInfo[] getInternalAttributeInfo() {
        Collection properties = this.cmd.getProperties();
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[11 + properties.size()];
        attrs[0] = new MBeanAttributeInfo("MetaData", ConnectorMetaData.class.getName(), "The meta data", true, false, false);
        attrs[1] = new MBeanAttributeInfo("AuthenticationMechanism", String.class.getName(), "The authentication mechanism", true, false, false);
        attrs[2] = new MBeanAttributeInfo("EISType", String.class.getName(), "The EIS type", true, false, false);
        attrs[3] = new MBeanAttributeInfo("License", String.class.getName(), "The license", true, false, false);
        attrs[4] = new MBeanAttributeInfo("RAClass", String.class.getName(), "The resource adapter class", true, false, false);
        attrs[5] = new MBeanAttributeInfo("RAVersion", String.class.getName(), "The resource adapter version", true, false, false);
        attrs[6] = new MBeanAttributeInfo("TransactionSupport", String.class.getName(), "The transaction support", true, false, false);
        attrs[7] = new MBeanAttributeInfo("VendorName", String.class.getName(), "The vendor name", true, false, false);
        attrs[8] = new MBeanAttributeInfo("Version", String.class.getName(), "The spec version", true, false, false);
        attrs[9] = new MBeanAttributeInfo("ReauthenticationSupport", Boolean.TYPE.getName(), "Whether reauthentication support is supported", true, false, false);
        attrs[10] = new MBeanAttributeInfo("ResourceAdapter", ResourceAdapter.class.getName(), "The resource adapter instance", true, false, false);
        int n = 11;
        for (ConfigPropertyMetaData cpmd : properties) {
            attrs[n++] = new MBeanAttributeInfo(cpmd.getName(), cpmd.getType(), cpmd.getDescription().getDescription(), true, false, false);
        }
        return attrs;
    }

    protected Object getInternalAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if ("MetaData".equals(attribute)) {
            return this.cmd;
        }
        if ("AuthenticationMechanism".equals(attribute)) {
            return this.cmd.getAuthenticationMechanism().getAuthenticationMechansimType();
        }
        if ("EISType".equals(attribute)) {
            return this.cmd.getEISType();
        }
        if ("License".equals(attribute)) {
            return this.cmd.getLicense().getDescription().getDescription();
        }
        if ("RAClass".equals(attribute)) {
            return this.cmd.getRAClass();
        }
        if ("RAVersion".equals(attribute)) {
            return this.cmd.getRAVersion();
        }
        if ("TransactionSupport".equals(attribute)) {
            return this.cmd.getTransactionSupport();
        }
        if ("VendorName".equals(attribute)) {
            return this.cmd.getVendorName();
        }
        if ("Version".equals(attribute)) {
            return this.cmd.getVersion();
        }
        if ("ReauthenticationSupport".equals(attribute)) {
            return new Boolean(this.cmd.getReauthenticationSupport());
        }
        if ("ResourceAdapter".equals(attribute)) {
            return this.resourceAdapter;
        }
        ConfigPropertyMetaData property = this.cmd.getProperty(attribute);
        if (property != null) {
            return property;
        }
        return super.getInternalAttribute(attribute);
    }

    protected MBeanOperationInfo[] getInternalOperationInfo() {
        MBeanOperationInfo[] ops = new MBeanOperationInfo[3];
        MBeanParameterInfo[] createActivationSpecParams = new MBeanParameterInfo[]{new MBeanParameterInfo("MessagingType", Class.class.getName(), "The type of the message listener"), new MBeanParameterInfo("ActivationConfig", Collection.class.getName(), "A collection of activation config properties")};
        ops[0] = new MBeanOperationInfo("createActivationSpec", "Create an activation spec", createActivationSpecParams, ActivationSpec.class.getName(), 1);
        MBeanParameterInfo[] activationParams = new MBeanParameterInfo[]{new MBeanParameterInfo("MessageEndpointFactory", MessageEndpointFactory.class.getName(), "The message endpoint factory"), new MBeanParameterInfo("ActivationSpec", ActivationSpec.class.getName(), "The activation spec")};
        ops[1] = new MBeanOperationInfo("endpointActivation", "Active the endpoint", activationParams, Void.class.getName(), 1);
        ops[2] = new MBeanOperationInfo("endpointDeactivation", "Deactive the endpoint", activationParams, Void.class.getName(), 1);
        return ops;
    }

    protected Object internalInvoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if ("createActivationSpec".equals(actionName)) {
            if (params.length != 2) {
                throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
            }
            Class messagingType = (Class)params[0];
            Collection activationConfig = (Collection)params[1];
            return this.createActivationSpec(messagingType, activationConfig);
        }
        if ("endpointActivation".equals(actionName)) {
            if (params.length != 2) {
                throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
            }
            MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
            ActivationSpec activationSpec = (ActivationSpec)params[1];
            this.endpointActivation(messageEndpointFactory, activationSpec);
            return null;
        }
        if ("endpointDeactivation".equals(actionName)) {
            if (params.length != 2) {
                throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
            }
            MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
            ActivationSpec activationSpec = (ActivationSpec)params[1];
            this.endpointDeactivation(messageEndpointFactory, activationSpec);
            return null;
        }
        return super.internalInvoke(actionName, params, signature);
    }

    protected ActivationSpec createActivationSpec(Class messagingType, Collection activationConfig) throws MBeanException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("CreateActivateSpec rar=" + this.getServiceName() + " messagingType=" + messagingType.getName() + " activationConfig=" + activationConfig));
        }
        try {
            MessageListenerMetaData mlmd = this.cmd.getMessageListener(messagingType.getName());
            if (mlmd == null) {
                throw new DeploymentException("MessagingType '" + messagingType.getName() + "' not found in resource deployment " + this.getServiceName());
            }
            return ActivationSpecFactory.createActivationSpec(this.getServiceName(), messagingType.getName(), activationConfig, mlmd);
        }
        catch (Exception e) {
            throw new MBeanException(e, "Error in create activation spec " + this.getServiceName());
        }
    }

    protected void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws MBeanException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("EndpointActivation rar=" + this.getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec));
        }
        try {
            activationSpec.setResourceAdapter(this.resourceAdapter);
            this.resourceAdapter.endpointActivation(messageEndpointFactory, activationSpec);
        }
        catch (Exception e) {
            throw new MBeanException(e, "Error in endpoint activation " + this.getServiceName());
        }
    }

    protected void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws MBeanException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("EndpointDeactivation rar=" + this.getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec));
        }
        try {
            this.resourceAdapter.endpointDeactivation(messageEndpointFactory, activationSpec);
        }
        catch (Exception e) {
            throw new MBeanException(e, "Error in endpoint deactivation " + this.getServiceName());
        }
    }
}

