/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.soap.SOAPMessageMarshaller;
import org.jboss.ws.core.soap.SOAPMessageUnMarshaller;

public class SOAPProtocolConnectionJMS
implements RemoteConnection {
    private boolean waitForResponse;

    public UnMarshaller getUnmarshaller() {
        return new SOAPMessageUnMarshaller();
    }

    public Marshaller getMarshaller() {
        return new SOAPMessageMarshaller();
    }

    public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway) throws IOException {
        return this.invoke(reqMessage, endpoint, oneway, true);
    }

    public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway, boolean maintainSession) throws IOException {
        String targetAddress;
        if (endpoint == null) {
            throw new IllegalArgumentException("Given endpoint cannot be null");
        }
        if (endpoint instanceof EndpointInfo) {
            EndpointInfo epInfo = (EndpointInfo)endpoint;
            targetAddress = epInfo.getTargetAddress();
        } else if (endpoint instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)endpoint;
            targetAddress = epr.getAddress().toString();
        } else {
            targetAddress = endpoint.toString();
        }
        try {
            URI jmsURI = new URI(targetAddress);
            String uriHost = jmsURI.getHost();
            String uriPath = jmsURI.getPath();
            String reqQueueName = this.getURLProperty(jmsURI, "destinationName");
            if (reqQueueName == null) {
                reqQueueName = uriHost;
                if (uriPath != null && uriPath.length() > 0) {
                    reqQueueName = reqQueueName + uriPath;
                }
            }
            InitialContext context = new InitialContext();
            QueueConnectionFactory connectionFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            Queue reqQueue = (Queue)context.lookup(reqQueueName);
            QueueConnection con = connectionFactory.createQueueConnection();
            QueueSession session = con.createQueueSession(false, 1);
            con.start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.getMarshaller().write(reqMessage, output);
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(output.toByteArray());
            ResponseListener responseListener = null;
            if (!oneway) {
                String resQueueName = this.getURLProperty(jmsURI, "replyToName");
                Queue resQueue = (Queue)context.lookup(resQueueName);
                QueueReceiver receiver = session.createReceiver(resQueue);
                responseListener = new ResponseListener();
                receiver.setMessageListener((MessageListener)responseListener);
                message.setJMSReplyTo((Destination)resQueue);
                this.waitForResponse = true;
            }
            QueueSender sender = session.createSender(reqQueue);
            sender.send((Message)message);
            sender.close();
            MessageAbstraction resMessage = null;
            if (responseListener != null) {
                for (int timeout = 30000; this.waitForResponse && timeout > 0; timeout -= 100) {
                    Thread.sleep(100L);
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(responseListener.resMessage.getBytes());
                resMessage = (MessageAbstraction)this.getUnmarshaller().read(bais, null);
            }
            con.stop();
            session.close();
            con.close();
            return resMessage;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException(ex.getMessage());
            ioex.initCause(ex);
            throw ioex;
        }
    }

    private String getURLProperty(URI uri, String key) {
        String retValue = null;
        String query = uri.getQuery();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "?:=");
            while (retValue == null && st.hasMoreTokens()) {
                String propName = st.nextToken();
                String propValue = st.nextToken();
                if (!propName.equals(key)) continue;
                retValue = propValue;
            }
        }
        return retValue;
    }

    public class ResponseListener
    implements MessageListener {
        public String resMessage;

        public void onMessage(Message msg) {
            TextMessage textMessage = (TextMessage)msg;
            try {
                this.resMessage = textMessage.getText();
                SOAPProtocolConnectionJMS.this.waitForResponse = false;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

