/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server.netty;

import java.util.HashMap;
import java.util.Map;
import org.jboss.ws.core.server.netty.NettyHttpServer;
import org.jboss.ws.core.server.netty.NettyHttpServerImpl;
import org.jboss.ws.core.server.netty.NettyRequestHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NettyHttpServerFactory {
    static final Map<Integer, NettyHttpServer> SERVERS = new HashMap<Integer, NettyHttpServer>();

    private NettyHttpServerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends NettyRequestHandlerFactory<?>> NettyHttpServer getNettyHttpServer(int port, T requestHandlerFactory) {
        if (port <= 0) {
            throw new IllegalArgumentException("Not positive port value");
        }
        if (requestHandlerFactory == null) {
            throw new NullPointerException("Factory cannot be null");
        }
        Map<Integer, NettyHttpServer> map = SERVERS;
        synchronized (map) {
            NettyHttpServer server = SERVERS.get(port);
            if (server == null) {
                server = new NettyHttpServerImpl(port, requestHandlerFactory);
                SERVERS.put(port, server);
            }
            return server;
        }
    }
}

