/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import com.sun.xml.fastinfoset.dom.DOMDocumentSerializer;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.w3c.dom.Node;

public class FastInfosetMarshaller
implements Marshaller {
    public void write(Object dataObject, OutputStream output) throws IOException {
        if (!(dataObject instanceof SOAPMessage)) {
            throw new IllegalArgumentException("Not a SOAPMessage: " + dataObject);
        }
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)dataObject;
        if (soapMessage.getAttachments().hasNext()) {
            throw new IllegalStateException("Attachments not supported with FastInfoset");
        }
        try {
            SOAPEnvelope soapEnv = soapMessage.getSOAPPart().getEnvelope();
            DOMDocumentSerializer serializer = new DOMDocumentSerializer();
            serializer.setOutputStream(output);
            serializer.serialize((Node)soapEnv);
        }
        catch (SOAPException ex) {
            IOException ioex = new IOException("Cannot serialize SOAP Envelope");
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

