/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.soap.MessageFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageUnMarshallerHTTP
implements UnMarshaller {
    private static Logger log = Logger.getLogger(SOAPMessageUnMarshallerHTTP.class);
    private static List<Integer> validResponseCodes = new ArrayList<Integer>();

    @Override
    public Object read(InputStream inputStream, Map<String, Object> metadata) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        try {
            Integer resCode = (Integer)metadata.get("ResponseCode");
            if (resCode == null) {
                log.warn((Object)"No HTTP resonse code, assuming: SC_OK");
                resCode = 200;
            }
            String resMessage = (String)metadata.get("ResponseCodeMessage");
            if (!validResponseCodes.contains(resCode)) {
                throw new WSException("Invalid HTTP server response [" + resCode + "] - " + resMessage);
            }
            SOAPMessage soapMsg = null;
            if (resCode != 204) {
                MimeHeaders mimeHeaders = this.getMimeHeaders(metadata);
                soapMsg = this.getMessageFactory().createMessage(mimeHeaders, inputStream, true);
            }
            return soapMsg;
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot unmarshall SOAPMessage", (Throwable)e);
            IOException e2 = new IOException(e.toString());
            e2.initCause(e);
            throw e2;
        }
    }

    protected MessageFactoryImpl getMessageFactory() {
        return new MessageFactoryImpl();
    }

    private MimeHeaders getMimeHeaders(Map<String, Object> metadata) {
        MimeHeaders headers = new MimeHeaders();
        for (String key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (key == null || !(value instanceof List)) continue;
            for (Object listValue : (List)value) {
                headers.addHeader(key, listValue.toString());
            }
        }
        return headers;
    }

    static {
        validResponseCodes.add(200);
        validResponseCodes.add(202);
        validResponseCodes.add(204);
        validResponseCodes.add(500);
    }
}

