/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletConfig;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.injection.InjectionHelper;
import org.jboss.wsf.common.injection.PreDestroyHolder;
import org.jboss.wsf.common.servlet.AbstractEndpointServlet;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointResolver;
import org.jboss.wsf.stack.jbws.ServletConfigHelper;
import org.jboss.wsf.stack.jbws.WebAppResolver;

public final class EndpointServlet
extends AbstractEndpointServlet {
    protected static final Logger log = Logger.getLogger(EndpointServlet.class);
    private List<PreDestroyHolder> preDestroyRegistry = new LinkedList<PreDestroyHolder>();
    private final Object lock = new Object();

    protected final EndpointResolver newEndpointResolver(String contextPath, String servletName) {
        return new WebAppResolver(contextPath, servletName);
    }

    protected final void postInit(ServletConfig servletConfig) {
        ServletConfigHelper.initEndpointConfig(servletConfig, this.endpoint);
    }

    protected final void postService() {
        this.registerForPreDestroy(this.endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Object object = this.lock;
        synchronized (object) {
            for (PreDestroyHolder holder : this.preDestroyRegistry) {
                try {
                    Object targetBean = holder.getObject();
                    InjectionHelper.callPreDestroyMethod((Object)targetBean);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            this.preDestroyRegistry.clear();
            this.preDestroyRegistry = null;
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForPreDestroy(Endpoint ep) {
        PreDestroyHolder holder = (PreDestroyHolder)ep.getAttachment(PreDestroyHolder.class);
        if (holder != null) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.preDestroyRegistry.contains(holder)) {
                    this.preDestroyRegistry.add(holder);
                }
            }
            ep.removeAttachment(PreDestroyHolder.class);
        }
    }
}

