/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.nav;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.on.embedded.ui.SummaryAction;
import org.jboss.on.embedded.ui.nav.BaseTreeNode;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;

public class SubCategoryTreeNode
extends BaseTreeNode {
    private ResourceSubCategory subCategory;
    private Resource parentResource;

    public SubCategoryTreeNode(String key, ResourceSubCategory subCategory, Resource parentResource) {
        super(key);
        if (subCategory == null) {
            throw new IllegalArgumentException("SubCategoryTreeNode requires a SubCategory. Null was passed into the constructor");
        }
        this.subCategory = subCategory;
        this.parentResource = parentResource;
    }

    protected void initChildrenMap() {
        Set taggedResourceTypes = this.getSubCategory().findTaggedResourceTypes();
        for (ResourceType taggedResourceType : taggedResourceTypes) {
            this.addChildResourceTypeNodeWithSubCategory(taggedResourceType, this.parentResource);
        }
        List subCategories = this.getSubCategory().getChildSubCategories();
        TreeSet sortedSubCategories = new TreeSet(subCategories);
        for (ResourceSubCategory subCategory : sortedSubCategories) {
            this.addChild(new SubCategoryTreeNode(SubCategoryTreeNode.getUniqueKey(), subCategory, this.parentResource));
        }
    }

    public Resource getClosestResource() {
        return this.parentResource;
    }

    public String getPath() {
        return this.getParent() == null ? this.getName() : this.getParent().getPath() + "/" + this.getName();
    }

    public String getName() {
        return this.getSubCategory().getName();
    }

    public String getDescription() {
        return this.getSubCategory().getDescription();
    }

    public ResourceSubCategory getSubCategory() {
        return this.subCategory;
    }

    public SummaryAction.SummaryActionOutcome getSummaryActionOutcome(SummaryAction action) {
        SummaryAction summaryAction = action;
        summaryAction.getClass();
        return new SummaryAction.SubCategoryOutcome(summaryAction, this);
    }

    public String toString() {
        return this.getPath();
    }
}

