/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SOAPConnectionFactory {
    private static Logger log = Logger.getLogger(SOAPConnectionFactory.class.getName());
    private static final String DEFAULT_SOAP_CONNECTION_FACTORY = "org.jboss.ws.core.soap.SOAPConnectionFactoryImpl";
    private static final String[] alternativeFactories = new String[]{"org.jboss.webservice.soap.SOAPConnectionFactoryImpl", "org.jboss.axis.soap.SOAPConnectionFactoryImpl"};

    public static SOAPConnectionFactory newInstance() throws SOAPException, UnsupportedOperationException {
        PropertyAccessAction action = new PropertyAccessAction(SOAPConnectionFactory.class.getName(), DEFAULT_SOAP_CONNECTION_FACTORY);
        String factoryName = (String)AccessController.doPrivileged(action);
        ClassLoader loader = SOAPConnectionFactory.getContextClassLoader();
        try {
            try {
                Class<?> factoryClass = SOAPConnectionFactory.loadClass(loader, factoryName);
                return (SOAPConnectionFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                if (!factoryName.equals(DEFAULT_SOAP_CONNECTION_FACTORY)) {
                    throw e;
                }
                for (int i = 0; i < alternativeFactories.length; ++i) {
                    factoryName = alternativeFactories[i];
                    try {
                        Class<?> factoryClass = loader.loadClass(factoryName);
                        return (SOAPConnectionFactory)factoryClass.newInstance();
                    }
                    catch (ClassNotFoundException e1) {
                        log.severe("Cannot load factory: " + factoryName);
                        continue;
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create SOAPConnectionFactory: " + factoryName, t);
        }
        throw new SOAPException("Cannot find SOAPConnectionFactory implementation");
    }

    public abstract SOAPConnection createConnection() throws SOAPException;

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException, ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.loadClass(name);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return cl.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

