/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.socket.OpenConnectionChecker;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class ClientSocketWrapper
extends SocketWrapper
implements OpenConnectionChecker {
    private static final Logger log = Logger.getLogger(ClientSocketWrapper.class);
    protected static final int CLOSING = 1;
    private DataInputStream in;
    private DataOutputStream out;

    public ClientSocketWrapper(Socket socket) throws IOException {
        super(socket);
        this.createStreams(socket, null);
    }

    public ClientSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception {
        super(socket, timeout);
        this.createStreams(socket, metadata);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void checkConnection() throws IOException {
        boolean ACK = true;
        this.out.writeByte(1);
        this.out.flush();
        this.in.readByte();
    }

    public void checkOpenConnection() throws IOException {
        if (this.in.available() > 0) {
            log.trace((Object)"remote endpoint has closed");
            throw new IOException("remote endpoint has closed");
        }
    }

    public String toString() {
        Socket socket = this.getSocket();
        return "ClientSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
    }

    protected void createStreams(Socket socket, Map metadata) throws IOException {
        this.out = this.createOutputStream(socket);
        this.in = this.createInputStream(socket);
    }

    protected DataInputStream createInputStream(Socket socket) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(socket.getInputStream(), 65536);
        return new DataInputStream(bin);
    }

    protected DataOutputStream createOutputStream(Socket socket) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream(), 65536);
        return new DataOutputStream(bout);
    }
}

