/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.DeliveryObserver;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.impl.tx.Transaction;

public class SimpleDelivery
implements Delivery {
    private static final Logger log = Logger.getLogger(SimpleDelivery.class);
    private boolean selectorAccepted;
    private DeliveryObserver observer;
    private MessageReference reference;
    private boolean recovered;
    private Transaction tx;
    private boolean trace = log.isTraceEnabled();

    public SimpleDelivery() {
        this(null, null);
    }

    public SimpleDelivery(DeliveryObserver observer, MessageReference reference) {
        this(observer, reference, true, false);
    }

    public SimpleDelivery(DeliveryObserver observer, MessageReference reference, boolean selectorAccepted, boolean recovered) {
        this.reference = reference;
        this.observer = observer;
        this.selectorAccepted = selectorAccepted;
        this.recovered = recovered;
        this.tx = null;
    }

    public MessageReference getReference() {
        return this.reference;
    }

    public boolean isSelectorAccepted() {
        return this.selectorAccepted;
    }

    public DeliveryObserver getObserver() {
        return this.observer;
    }

    public void acknowledge(Transaction tx) throws Throwable {
        if (this.trace) {
            log.trace((Object)(this + " acknowledging delivery " + (tx == null ? "non-transactionally" : "in " + tx)));
        }
        this.tx = tx;
        this.observer.acknowledge(this, tx);
    }

    public void cancel() throws Throwable {
        if (this.trace) {
            log.trace((Object)(this + " cancelling delivery"));
        }
        this.observer.cancel(this);
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public String toString() {
        return "Delivery" + (this.reference == null ? "" : "[" + this.reference + "]");
    }

    public boolean isXAPrepared() {
        if (this.tx != null && this.tx.getXid() != null) {
            return this.tx.getState() == 1;
        }
        return false;
    }
}

