/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.proxy.InterceptionHandlerFactory;
import org.jboss.interceptor.proxy.InterceptorMethodHandler;
import org.jboss.interceptor.proxy.InterceptorProxyCreator;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.registry.InterceptorRegistry;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorProxyCreatorImpl
implements InterceptorProxyCreator {
    private List<InterceptorRegistry<Class<?>, ?>> interceptorRegistries;
    private List<InterceptionHandlerFactory<?>> interceptionHandlerFactories;

    public InterceptorProxyCreatorImpl(List<InterceptorRegistry<Class<?>, ?>> interceptorRegistries, List<InterceptionHandlerFactory<?>> interceptionHandlerFactories) {
        this.interceptorRegistries = interceptorRegistries;
        this.interceptionHandlerFactories = interceptionHandlerFactories;
    }

    public InterceptorProxyCreatorImpl(InterceptorRegistry<Class<?>, ?> interceptorRegistries, InterceptionHandlerFactory<?> interceptionHandlerFactories) {
        this.interceptorRegistries = Collections.singletonList(interceptorRegistries);
        this.interceptionHandlerFactories = Collections.singletonList(interceptionHandlerFactories);
    }

    @Override
    public <T> T createProxyFromInstance(Object target, Class<T> proxyClass, Class<?>[] constructorTypes, Object[] constructorArguments) {
        ProxyFactory proxyFactory = new ProxyFactory();
        if (proxyClass != null) {
            proxyFactory.setSuperclass(proxyClass);
        }
        proxyFactory.setInterfaces(new Class[]{LifecycleMixin.class, TargetInstanceProxy.class});
        InterceptorMethodHandler interceptorMethodHandler = new InterceptorMethodHandler(target, proxyClass, this.getModelsFor(proxyClass), this.interceptionHandlerFactories);
        proxyFactory.setHandler((MethodHandler)interceptorMethodHandler);
        try {
            Class clazz = proxyFactory.createClass();
            ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();
            Constructor<?> c = reflectionFactory.newConstructorForSerialization(clazz, Object.class.getDeclaredConstructor(new Class[0]));
            Object proxyObject = c.newInstance(new Object[0]);
            ((ProxyObject)proxyObject).setHandler((MethodHandler)interceptorMethodHandler);
            return (T)proxyObject;
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    private <T> List<InterceptionModel<Class<?>, ?>> getModelsFor(Class<T> proxyClass) {
        ArrayList interceptionModels = new ArrayList();
        for (InterceptorRegistry<Class<?>, ?> interceptorRegistry : this.interceptorRegistries) {
            interceptionModels.add(interceptorRegistry.getInterceptionModel(proxyClass));
        }
        return interceptionModels;
    }

    public <T> T constructInstrumentedInstance(Object target, Class<T> proxyClass, Class<?>[] constructorTypes, Object[] constructorArguments) throws IllegalAccessException, InstantiationException {
        ProxyFactory proxyFactory = new ProxyFactory();
        if (proxyClass != null) {
            proxyFactory.setSuperclass(target.getClass());
        }
        proxyFactory.setHandler((MethodHandler)new InterceptorMethodHandler(target, proxyClass, this.getModelsFor(proxyClass), this.interceptionHandlerFactories));
        try {
            return (T)proxyFactory.create((Class[])constructorTypes, constructorArguments);
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    @Override
    public <T> T createProxyFromInstance(Object target, Class<T> proxyClass) throws IllegalAccessException, InstantiationException {
        return this.createProxyFromInstance(target, proxyClass, new Class[0], new Object[0]);
    }

    public MethodHandler createInstanceProxifyingMethodHandler(Object target, Class<?> proxyClass) {
        return new InterceptorMethodHandler(target, proxyClass, this.getModelsFor(proxyClass), this.interceptionHandlerFactories);
    }
}

