/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.function.DerbyConcatFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DerbyCaseFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDialect
extends DB2Dialect {
    private static final Logger log = LoggerFactory.getLogger((Class)DerbyDialect.class);
    private int driverVersionMajor;
    private int driverVersionMinor;

    public DerbyDialect() {
        this.registerFunction("concat", new DerbyConcatFunction());
        this.registerFunction("trim", new DerbyTrimFunctionEmulation());
        this.determineDriverVersion();
    }

    void determineDriverVersion() {
        try {
            Class sysinfoClass = ReflectHelper.classForName("org.apache.derby.tools.sysinfo", this.getClass());
            Method majorVersionGetter = sysinfoClass.getMethod("getMajorVersion", ReflectHelper.NO_PARAM_SIGNATURE);
            Method minorVersionGetter = sysinfoClass.getMethod("getMinorVersion", ReflectHelper.NO_PARAM_SIGNATURE);
            this.driverVersionMajor = (Integer)majorVersionGetter.invoke(null, ReflectHelper.NO_PARAMS);
            this.driverVersionMinor = (Integer)minorVersionGetter.invoke(null, ReflectHelper.NO_PARAMS);
        }
        catch (Exception e) {
            log.warn("Unable to load/access derby driver class sysinfo to check versions : " + e);
            this.driverVersionMajor = -1;
            this.driverVersionMinor = -1;
        }
    }

    boolean isTenPointFiveReleaseOrNewer() {
        return this.driverVersionMajor > 10 || this.driverVersionMajor == 10 && this.driverVersionMinor >= 5;
    }

    public String getIdentityColumnString() {
        return "not null generated always as identity";
    }

    public CaseFragment createCaseFragment() {
        return new DerbyCaseFragment();
    }

    public boolean dropConstraints() {
        return true;
    }

    public Class getNativeIdentifierGeneratorClass() {
        return TableHiLoGenerator.class;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsLimit() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    public boolean supportsLimitOffset() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    public String getLimitString(String query, int offset, int limit) {
        StringBuffer sb = new StringBuffer(query.length() + 50);
        String normalizedSelect = query.toLowerCase().trim();
        int forUpdateIndex = normalizedSelect.lastIndexOf("for update");
        if (this.hasForUpdateClause(forUpdateIndex)) {
            sb.append(query.substring(0, forUpdateIndex - 1));
        } else if (this.hasWithClause(normalizedSelect)) {
            sb.append(query.substring(0, this.getWithIndex(query) - 1));
        } else {
            sb.append(query);
        }
        if (offset == 0) {
            sb.append(" fetch first ");
        } else {
            sb.append(" offset ").append(offset).append(" rows fetch next ");
        }
        sb.append(limit).append(" rows only");
        if (this.hasForUpdateClause(forUpdateIndex)) {
            sb.append(' ');
            sb.append(query.substring(forUpdateIndex));
        } else if (this.hasWithClause(normalizedSelect)) {
            sb.append(' ').append(query.substring(this.getWithIndex(query)));
        }
        return sb.toString();
    }

    private boolean hasForUpdateClause(int forUpdateIndex) {
        return forUpdateIndex >= 0;
    }

    private boolean hasWithClause(String normalizedSelect) {
        return normalizedSelect.startsWith("with ", normalizedSelect.length() - 7);
    }

    private int getWithIndex(String querySelect) {
        int i = querySelect.lastIndexOf("with ");
        if (i < 0) {
            i = querySelect.lastIndexOf("WITH ");
        }
        return i;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public static class DerbyTrimFunctionEmulation
    implements SQLFunction {
        private static final SQLFunction LEADING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( ?1 )");
        private static final SQLFunction TRAILING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "rtrim( ?1 )");
        private static final SQLFunction BOTH_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?1 ) )");
        private static final SQLFunction BOTH_SPACE_TRIM_FROM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?2 ) )");

        public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
            return Hibernate.STRING;
        }

        public boolean hasArguments() {
            return true;
        }

        public boolean hasParenthesesIfNoArguments() {
            return false;
        }

        public String render(List args, SessionFactoryImplementor factory) throws QueryException {
            String trimSource;
            String trimCharacter;
            if (args.size() == 1) {
                return BOTH_SPACE_TRIM.render(args, factory);
            }
            if ("from".equalsIgnoreCase((String)args.get(0))) {
                return BOTH_SPACE_TRIM_FROM.render(args, factory);
            }
            boolean leading = true;
            boolean trailing = true;
            int potentialTrimCharacterArgIndex = 1;
            String firstArg = (String)args.get(0);
            if ("leading".equalsIgnoreCase(firstArg)) {
                trailing = false;
            } else if ("trailing".equalsIgnoreCase(firstArg)) {
                leading = false;
            } else if (!"both".equalsIgnoreCase(firstArg)) {
                potentialTrimCharacterArgIndex = 0;
            }
            String potentialTrimCharacter = (String)args.get(potentialTrimCharacterArgIndex);
            if ("from".equalsIgnoreCase(potentialTrimCharacter)) {
                trimCharacter = "' '";
                trimSource = (String)args.get(potentialTrimCharacterArgIndex + 1);
            } else if (potentialTrimCharacterArgIndex + 1 >= args.size()) {
                trimCharacter = "' '";
                trimSource = potentialTrimCharacter;
            } else {
                trimCharacter = potentialTrimCharacter;
                trimSource = "from".equalsIgnoreCase((String)args.get(potentialTrimCharacterArgIndex + 1)) ? (String)args.get(potentialTrimCharacterArgIndex + 2) : (String)args.get(potentialTrimCharacterArgIndex + 1);
            }
            ArrayList<String> argsToUse = new ArrayList<String>();
            argsToUse.add(trimSource);
            argsToUse.add(trimCharacter);
            if (trimCharacter.equals("' '")) {
                if (leading && trailing) {
                    return BOTH_SPACE_TRIM.render(argsToUse, factory);
                }
                if (leading) {
                    return LEADING_SPACE_TRIM.render(argsToUse, factory);
                }
                return TRAILING_SPACE_TRIM.render(argsToUse, factory);
            }
            throw new HibernateException("cannot specify trim character when using Derby as Derby does not support the ANSI trim function, not does it support a replace function to properly emmulate it");
        }
    }
}

