/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Generator {
    private final MessageDigest messageDigest;

    public MD5Generator() {
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not find MD5 Algorithm");
        }
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public void add(InputStream is) throws IOException {
        int len;
        byte[] bytes = new byte[1024];
        while ((len = is.read(bytes, 0, bytes.length)) != -1) {
            this.messageDigest.update(bytes, 0, len);
        }
    }

    public void add(byte[] bytes) {
        if (bytes != null) {
            this.messageDigest.update(bytes);
        }
    }

    public byte[] getDigest() {
        return this.messageDigest.digest();
    }

    public String getDigestString() {
        return MD5Generator.calculateDigestStringFromBytes(this.getDigest());
    }

    public static byte[] getDigest(InputStream is) throws IOException {
        MD5Generator md5 = new MD5Generator();
        md5.add(is);
        return md5.getDigest();
    }

    public static String getDigestString(InputStream is) throws IOException {
        MD5Generator md5 = new MD5Generator();
        md5.add(is);
        return md5.getDigestString();
    }

    public static byte[] getDigest(String source_str) {
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(source_str.getBytes());
            return MD5Generator.getDigest(bs);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException reading a byte array input stream, this should never happen", e);
        }
    }

    public static String getDigestString(String source_str) {
        return MD5Generator.calculateDigestStringFromBytes(MD5Generator.getDigest(source_str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDigest(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] byArray = MD5Generator.getDigest(new BufferedInputStream(is, 32768));
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String getDigestString(File file) throws IOException {
        return MD5Generator.calculateDigestStringFromBytes(MD5Generator.getDigest(file));
    }

    private static String calculateDigestStringFromBytes(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int hi = bytes[i] >> 4 & 0xF;
            int lo = bytes[i] & 0xF;
            sb.append(Character.forDigit(hi, 16));
            sb.append(Character.forDigit(lo, 16));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String file = args[0];
        String digest = MD5Generator.getDigestString(new File(file));
        System.out.println("MD5=" + digest);
    }
}

