/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.discovery.InventoryReport;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerMBeanImplMBean;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.ClassLoaderManager;
import org.rhq.core.pluginapi.operation.OperationResult;

public class PluginContainerMBeanImpl
implements PluginContainerMBeanImplMBean {
    private static final Log log = LogFactory.getLog(PluginContainerMBeanImpl.class);
    private final PluginContainer pluginContainer;

    public PluginContainerMBeanImpl(PluginContainer pc) {
        this.pluginContainer = pc;
    }

    public void register() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.registerMBean(this, new ObjectName("rhq.pc:type=PluginContainer"));
        }
        catch (Exception e) {
            log.error((Object)"Unable to register PluginContainerMBean", (Throwable)e);
        }
    }

    public void unregister() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName("rhq.pc:type=PluginContainer"));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to unregister PluginContainerMBean", (Throwable)e);
        }
    }

    public String executeDiscovery(Boolean detailedDiscovery) {
        StringBuilder results = new StringBuilder();
        InventoryReport report = this.pluginContainer.getInventoryManager().executeServerScanImmediately();
        results.append(this.generateInventoryReportString(report));
        if (detailedDiscovery != null && detailedDiscovery.booleanValue()) {
            report = this.pluginContainer.getInventoryManager().executeServiceScanImmediately();
            results.append('\n');
            results.append(this.generateInventoryReportString(report));
        }
        return results.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult retrievePluginDependencyGraph() {
        List deploymentOrder;
        HashMap<String, ArrayList<String>> dependencies = new HashMap<String, ArrayList<String>>();
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClassLoaderManager clm = this.pluginContainer.getPluginManager().getClassLoaderManager();
            PluginDependencyGraph graph = clm.getPluginDependencyGraph();
            deploymentOrder = graph.getDeploymentOrder();
            for (String pluginName : deploymentOrder) {
                ArrayList<String> deps = graph.getPluginDependencies(pluginName);
                if (deps == null || deps.size() == 0) {
                    deps = new ArrayList<String>(Arrays.asList("<none>"));
                }
                dependencies.put(pluginName, deps);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        OperationResult info = new OperationResult();
        PropertyList list = new PropertyList("plugins");
        info.getComplexResults().put((Property)list);
        for (String plugin : deploymentOrder) {
            PropertyMap map = new PropertyMap("plugin");
            map.put((Property)new PropertySimple("name", (Object)plugin));
            map.put((Property)new PropertySimple("dependencies", dependencies.get(plugin)));
            list.add((Property)map);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult retrievePluginClassLoaderInformation() {
        Map<String, ClassLoader> classloaders;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClassLoaderManager clm = this.pluginContainer.getPluginManager().getClassLoaderManager();
            classloaders = clm.getPluginClassLoaders();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        OperationResult info = new OperationResult();
        PropertySimple numClassLoaders = new PropertySimple("numberOfClassLoaders", (Object)String.valueOf(classloaders.size()));
        PropertyList list = new PropertyList("classloaders");
        info.getComplexResults().put((Property)numClassLoaders);
        info.getComplexResults().put((Property)list);
        for (Map.Entry<String, ClassLoader> entry : classloaders.entrySet()) {
            String pluginName = entry.getKey();
            ClassLoader classloader = entry.getValue();
            PropertyMap map = new PropertyMap("classloader");
            map.put((Property)new PropertySimple("pluginName", (Object)pluginName));
            map.put((Property)new PropertySimple("classloaderInfo", (Object)classloader));
            list.add((Property)map);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult retrieveDiscoveryClassLoaderInformation() {
        Map<String, ClassLoader> classloaders;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClassLoaderManager clm = this.pluginContainer.getPluginManager().getClassLoaderManager();
            classloaders = clm.getDiscoveryClassLoaders();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        OperationResult info = new OperationResult();
        PropertySimple numClassLoaders = new PropertySimple("numberOfClassLoaders", (Object)String.valueOf(classloaders.size()));
        PropertyList list = new PropertyList("classloaders");
        info.getComplexResults().put((Property)numClassLoaders);
        info.getComplexResults().put((Property)list);
        for (Map.Entry<String, ClassLoader> entry : classloaders.entrySet()) {
            String id = entry.getKey();
            ClassLoader classloader = entry.getValue();
            PropertyMap map = new PropertyMap("classloader");
            map.put((Property)new PropertySimple("id", (Object)id));
            map.put((Property)new PropertySimple("classloaderInfo", (Object)classloader));
            list.add((Property)map);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult retrieveAllResourceClassLoaderInformation() {
        Map<String, ClassLoader> classloaders;
        HashMap<String, String[]> uuidToNameIds = new HashMap<String, String[]>();
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClassLoaderManager clm = this.pluginContainer.getPluginManager().getClassLoaderManager();
            InventoryManager im = this.pluginContainer.getInventoryManager();
            classloaders = clm.getResourceClassLoaders();
            for (String uuid : classloaders.keySet()) {
                ResourceContainer container = im.getResourceContainer(uuid);
                String[] nameId = new String[2];
                if (container != null) {
                    nameId[0] = container.getResource().getName();
                    nameId[1] = Integer.toString(container.getResource().getId());
                } else {
                    nameId[0] = "<unknown>";
                    nameId[1] = uuid;
                }
                uuidToNameIds.put(uuid, nameId);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        OperationResult info = new OperationResult();
        PropertySimple numClassLoaders = new PropertySimple("numberOfResources", (Object)String.valueOf(classloaders.size()));
        PropertyList list = new PropertyList("classloaders");
        info.getComplexResults().put((Property)numClassLoaders);
        info.getComplexResults().put((Property)list);
        for (Map.Entry<String, ClassLoader> entry : classloaders.entrySet()) {
            String uuid = entry.getKey();
            ClassLoader classloader = entry.getValue();
            String[] nameId = (String[])uuidToNameIds.get(uuid);
            PropertyMap map = new PropertyMap("classloader");
            map.put((Property)new PropertySimple("resourceName", (Object)nameId[0]));
            map.put((Property)new PropertySimple("resourceId", (Object)nameId[1]));
            map.put((Property)new PropertySimple("classloaderInfo", (Object)classloader));
            list.add((Property)map);
        }
        classloaders.clear();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult retrieveUniqueResourceClassLoaderInformation() {
        HashMap<ClassLoader, AtomicInteger> classloaderCounts = new HashMap<ClassLoader, AtomicInteger>();
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClassLoaderManager clm = this.pluginContainer.getPluginManager().getClassLoaderManager();
            Map<String, ClassLoader> classloaders = clm.getResourceClassLoaders();
            for (Map.Entry<String, ClassLoader> entry : classloaders.entrySet()) {
                AtomicInteger count = (AtomicInteger)classloaderCounts.get(entry.getValue());
                if (count == null) {
                    count = new AtomicInteger(1);
                    classloaderCounts.put(entry.getValue(), count);
                    continue;
                }
                count.incrementAndGet();
            }
            classloaders.clear();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        OperationResult info = new OperationResult();
        PropertySimple numClassLoaders = new PropertySimple("numberOfClassLoaders", (Object)String.valueOf(classloaderCounts.size()));
        PropertyList list = new PropertyList("classloaders");
        info.getComplexResults().put((Property)numClassLoaders);
        info.getComplexResults().put((Property)list);
        for (Map.Entry entry : classloaderCounts.entrySet()) {
            ClassLoader classloader = (ClassLoader)entry.getKey();
            AtomicInteger count = (AtomicInteger)entry.getValue();
            PropertyMap map = new PropertyMap("classloader");
            map.put((Property)new PropertySimple("classloaderInfo", (Object)classloader));
            map.put((Property)new PropertySimple("resourceCount", (Object)count.get()));
            list.add((Property)map);
        }
        return info;
    }

    public int getNumberOfPluginClassLoaders() {
        return this.pluginContainer.getPluginManager().getClassLoaderManager().getNumberOfPluginClassLoaders();
    }

    public int getNumberOfDiscoveryClassLoaders() {
        return this.pluginContainer.getPluginManager().getClassLoaderManager().getNumberOfDiscoveryClassLoaders();
    }

    public int getNumberOfResourceClassLoaders() {
        return this.pluginContainer.getPluginManager().getClassLoaderManager().getNumberOfResourceClassLoaders();
    }

    private String generateInventoryReportString(InventoryReport report) {
        StringBuilder reportStr = new StringBuilder();
        if (report != null) {
            reportStr.append(report.isRuntimeReport() ? "*Service Scan" : "*Server Scan");
            reportStr.append(" Inventory Report*\n");
            reportStr.append("Start Time: ").append(new Date(report.getStartTime())).append('\n');
            reportStr.append("Finish Time: ").append(new Date(report.getEndTime())).append('\n');
            reportStr.append("Resource Count: ").append(report.getResourceCount()).append('\n');
            reportStr.append("Error Count: ").append(report.getErrors().size());
        } else {
            reportStr.append("No inventory report available!");
        }
        return reportStr.toString();
    }
}

