/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.plugin.BlacklistedException;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryComponentProxyFactory {
    private final Log log = LogFactory.getLog(DiscoveryComponentProxyFactory.class);
    private static final String DAEMON_THREAD_POOL_NAME = "ResourceDiscoveryComponent.invoker.daemon";
    private ExecutorService daemonThreadPool = null;
    private final Set<ResourceType> blacklist = new HashSet<ResourceType>();

    public <T> T getDiscoveryComponentProxy(ResourceType type, ResourceDiscoveryComponent component, long timeout, Class<T> componentInterface) throws PluginContainerException, BlacklistedException {
        if (this.isResourceTypeBlacklisted(type)) {
            throw new BlacklistedException("Discovery component for resource type [" + type + "] has been blacklisted");
        }
        try {
            ClassLoader pluginClassLoader = component.getClass().getClassLoader();
            ResourceDiscoveryComponentInvocationHandler handler = new ResourceDiscoveryComponentInvocationHandler(type, component, timeout, pluginClassLoader);
            Object proxy = Proxy.newProxyInstance(pluginClassLoader, new Class[]{componentInterface}, (InvocationHandler)handler);
            return (T)proxy;
        }
        catch (Throwable t) {
            throw new PluginContainerException("Cannot get discovery component proxy for [" + component + "]", t);
        }
    }

    public ResourceDiscoveryComponent getDiscoveryComponentProxy(ResourceType type, ResourceDiscoveryComponent component, long timeout) throws PluginContainerException, BlacklistedException {
        return this.getDiscoveryComponentProxy(type, component, timeout, ResourceDiscoveryComponent.class);
    }

    public void initialize() {
        LoggingThreadFactory daemonFactory = new LoggingThreadFactory(DAEMON_THREAD_POOL_NAME, true);
        this.daemonThreadPool = Executors.newCachedThreadPool(daemonFactory);
    }

    public void shutdown() {
        if (this.daemonThreadPool != null) {
            this.daemonThreadPool.shutdownNow();
        }
        this.daemonThreadPool = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ResourceType> getResourceTypeBlacklist() {
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            return new HashSet<ResourceType>(this.blacklist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResourceTypeBlacklist() {
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            this.blacklist.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResourceTypeBlacklisted(ResourceType type) {
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            return this.blacklist.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceTypeToBlacklist(ResourceType type) {
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            this.blacklist.add(type);
        }
        this.log.warn((Object)("The discovery component for resource type [" + type + "] has been blacklisted"));
    }

    private ExecutorService getThreadPool() {
        return this.daemonThreadPool;
    }

    private class ComponentInvocationThread
    implements Callable {
        private final ResourceDiscoveryComponent component;
        private final Method method;
        private final Object[] args;
        private ClassLoader pluginClassLoader;

        ComponentInvocationThread(ResourceDiscoveryComponent component, Method method, Object[] args, ClassLoader pluginClassLoader) {
            this.component = component;
            this.method = method;
            this.args = args;
            this.pluginClassLoader = pluginClassLoader;
        }

        public Object call() throws Exception {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object results;
                Thread.currentThread().setContextClassLoader(this.pluginClassLoader);
                Object object = results = this.method.invoke((Object)this.component, this.args);
                return object;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                throw new Exception("Discovery component invocation failed.", cause);
            }
            catch (Throwable t) {
                throw new Exception("Failed to invoke discovery component", t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    private class ResourceDiscoveryComponentInvocationHandler
    implements InvocationHandler {
        private final ResourceDiscoveryComponent component;
        private final long timeout;
        private final ResourceType resourceType;
        private final ClassLoader pluginClassLoader;

        public ResourceDiscoveryComponentInvocationHandler(ResourceType type, ResourceDiscoveryComponent component, long timeout, ClassLoader pluginClassLoader) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout value is not positive.");
            }
            if (component == null) {
                throw new IllegalArgumentException("component is null");
            }
            this.resourceType = type;
            this.component = component;
            this.timeout = timeout;
            this.pluginClassLoader = pluginClassLoader;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (DiscoveryComponentProxyFactory.this.isResourceTypeBlacklisted(this.resourceType)) {
                throw new RuntimeException("Discovery component for resource type [" + this.resourceType + "] has been blacklisted and can no longer be invoked.");
            }
            if (method.getDeclaringClass().equals(ResourceDiscoveryComponent.class)) {
                return this.invokeInNewThread(method, args);
            }
            return this.invokeInCurrentThread(method, args);
        }

        private Object invokeInNewThread(Method method, Object[] args) throws Throwable {
            ExecutorService threadPool = DiscoveryComponentProxyFactory.this.getThreadPool();
            ComponentInvocationThread invocationThread = new ComponentInvocationThread(this.component, method, args, this.pluginClassLoader);
            Future future = threadPool.submit(invocationThread);
            try {
                return future.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                DiscoveryComponentProxyFactory.this.log.error((Object)("Thread [" + Thread.currentThread().getName() + "] was interrupted."));
                future.cancel(true);
                throw new RuntimeException(this.invokedMethodString(method, args, "was interrupted."), e);
            }
            catch (ExecutionException e) {
                if (DiscoveryComponentProxyFactory.this.log.isDebugEnabled()) {
                    DiscoveryComponentProxyFactory.this.log.debug((Object)this.invokedMethodString(method, args, "failed."), (Throwable)e);
                }
                throw e.getCause();
            }
            catch (TimeoutException e) {
                DiscoveryComponentProxyFactory.this.addResourceTypeToBlacklist(this.resourceType);
                String msg = this.invokedMethodString(method, args, "timed out. Invocation thread will be interrupted");
                DiscoveryComponentProxyFactory.this.log.debug((Object)msg);
                future.cancel(true);
                throw new org.rhq.core.pc.inventory.TimeoutException(msg);
            }
        }

        private Object invokeInCurrentThread(Method method, Object[] args) throws Throwable {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.pluginClassLoader);
                Object object = method.invoke((Object)this.component, args);
                return object;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause() != null ? ite.getCause() : ite;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }

        private String invokedMethodString(Method method, Object[] methodArgs, String extraMsg) {
            String name = this.component.getClass().getName() + '.' + method.getName() + "()";
            String args = methodArgs != null ? Arrays.asList(methodArgs).toString() : "";
            return "Call to [" + name + "] with args [" + args + "] " + extraMsg;
        }
    }
}

