/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnorderedSequenceBinding
extends ModelGroupBinding {
    private Map<QName, ParticleBinding> elementParticles = Collections.emptyMap();
    private List<ParticleBinding> groupParticles = Collections.emptyList();
    private List<ParticleBinding> wildcardParticles = Collections.emptyList();
    private ElementBinding arrayItem;
    private List<ParticleBinding> allParticles = null;

    public UnorderedSequenceBinding(SchemaBinding schema) {
        super(schema);
    }

    @Override
    public ElementBinding getArrayItem() {
        return this.arrayItem;
    }

    @Override
    public void addParticle(ParticleBinding particle) {
        TermBinding term = particle.getTerm();
        if (term.isElement()) {
            if (this.elementParticles.isEmpty()) {
                this.elementParticles = new HashMap<QName, ParticleBinding>();
            }
            this.elementParticles.put(((ElementBinding)term).getQName(), particle);
        } else if (term.isModelGroup()) {
            if (this.groupParticles.isEmpty()) {
                this.groupParticles = new ArrayList<ParticleBinding>();
            }
            this.groupParticles.add(particle);
        } else if (term.isWildcard()) {
            if (this.wildcardParticles.isEmpty()) {
                this.wildcardParticles = new ArrayList<ParticleBinding>();
            }
            this.wildcardParticles.add(particle);
        } else {
            throw new JBossXBRuntimeException("Unexpected term type: " + term);
        }
        super.addParticle(particle);
        this.allParticles = null;
    }

    @Override
    public Collection<ParticleBinding> getParticles() {
        if (this.allParticles == null) {
            this.allParticles = new ArrayList<ParticleBinding>(this.elementParticles.size() + this.groupParticles.size() + this.wildcardParticles.size());
            this.allParticles.addAll(this.elementParticles.values());
            this.allParticles.addAll(this.groupParticles);
            this.allParticles.addAll(this.wildcardParticles);
            this.allParticles = Collections.unmodifiableList(this.allParticles);
        }
        return this.allParticles;
    }

    @Override
    protected boolean mayStartWith(QName name, Set<ModelGroupBinding> set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModelGroupBinding.Cursor newCursor(ParticleBinding particle) {
        return new ModelGroupBinding.Cursor(particle){
            private ElementBinding element;
            private ParticleBinding curParticle;
            private int occurence;
            private boolean wildcardContent;

            @Override
            public void endElement(QName name) {
                ElementBinding element = this.getElement();
                if (element == null || !element.getQName().equals(UnorderedSequenceBinding.this.qName)) {
                    throw new JBossXBRuntimeException("Failed to process endElement for " + UnorderedSequenceBinding.this.qName + " since the current element is " + (element == null ? "null" : element.getQName().toString()));
                }
                if (this.trace) {
                    UnorderedSequenceBinding.this.log.trace((Object)("endElement " + UnorderedSequenceBinding.this.qName + " in " + this.getModelGroup()));
                }
            }

            @Override
            public ParticleBinding getCurrentParticle() {
                if (this.curParticle == null) {
                    throw new JBossXBRuntimeException("The cursor in all group has not been positioned yet!");
                }
                return this.curParticle;
            }

            @Override
            public ElementBinding getElement() {
                if (this.curParticle == null) {
                    throw new JBossXBRuntimeException("The cursor in all group has not been positioned yet!");
                }
                return this.element;
            }

            @Override
            protected ElementBinding getElement(QName name, Attributes atts, Set<ModelGroupBinding.Cursor> passedGroups, boolean ignoreWildcards) {
                return this.getElement((List)UnorderedSequenceBinding.this.getParticles(), name, atts, passedGroups, ignoreWildcards);
            }

            @Override
            public int getOccurence() {
                return this.occurence;
            }

            @Override
            public boolean isPositioned() {
                return this.curParticle != null;
            }

            @Override
            public boolean isWildcardContent() {
                return this.wildcardContent;
            }

            @Override
            protected List<ModelGroupBinding.Cursor> startElement(QName qName, Attributes atts, Set<ModelGroupBinding> passedGroups, List<ModelGroupBinding.Cursor> groupStack, boolean required) {
                if (this.trace) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("startElement ").append(qName).append(" in ").append(UnorderedSequenceBinding.this.toString());
                    UnorderedSequenceBinding.this.log.trace((Object)sb.toString());
                }
                if (this.curParticle != null && (this.curParticle.getMaxOccursUnbounded() || this.occurence < this.curParticle.getMinOccurs() || this.occurence < this.curParticle.getMaxOccurs())) {
                    ModelGroupBinding modelGroup;
                    TermBinding term = this.curParticle.getTerm();
                    if (term.isElement() && ((ElementBinding)term).getQName().equals(qName)) {
                        ++this.occurence;
                        groupStack = this.addItem(groupStack, this);
                        if (this.trace) {
                            UnorderedSequenceBinding.this.log.trace((Object)("found " + qName + " in " + this.getModelGroup()));
                        }
                        return groupStack;
                    }
                    if (term.isModelGroup() && !passedGroups.contains(modelGroup = (ModelGroupBinding)term)) {
                        switch (passedGroups.size()) {
                            case 0: {
                                passedGroups = Collections.singleton(UnorderedSequenceBinding.this);
                                break;
                            }
                            case 1: {
                                passedGroups = new HashSet<ModelGroupBinding>(passedGroups);
                            }
                            default: {
                                passedGroups.add(UnorderedSequenceBinding.this);
                            }
                        }
                        int groupStackSize = groupStack.size();
                        groupStack = modelGroup.newCursor(this.curParticle).startElement(qName, atts, passedGroups, groupStack, this.curParticle.isRequired(this.occurence));
                        if (groupStackSize != groupStack.size()) {
                            ++this.occurence;
                            groupStack = this.addItem(groupStack, this);
                            return groupStack;
                        }
                    }
                }
                this.wildcardContent = false;
                this.occurence = 0;
                this.curParticle = (ParticleBinding)UnorderedSequenceBinding.this.elementParticles.get(qName);
                if (this.curParticle != null) {
                    ++this.occurence;
                    this.element = (ElementBinding)this.curParticle.getTerm();
                    groupStack = this.addItem(groupStack, this);
                    if (this.trace) {
                        UnorderedSequenceBinding.this.log.trace((Object)("found " + qName + " in " + this.getModelGroup()));
                    }
                    return groupStack;
                }
                for (ParticleBinding particle : UnorderedSequenceBinding.this.groupParticles) {
                    int groupStackSize;
                    ModelGroupBinding modelGroup = (ModelGroupBinding)particle.getTerm();
                    if (passedGroups.contains(modelGroup)) continue;
                    switch (passedGroups.size()) {
                        case 0: {
                            passedGroups = Collections.singleton(UnorderedSequenceBinding.this);
                            break;
                        }
                        case 1: {
                            passedGroups = new HashSet<ModelGroupBinding>(passedGroups);
                        }
                        default: {
                            passedGroups.add(UnorderedSequenceBinding.this);
                        }
                    }
                    if ((groupStackSize = groupStack.size()) == (groupStack = modelGroup.newCursor(particle).startElement(qName, atts, passedGroups, groupStack, particle.isRequired(this.occurence))).size()) continue;
                    ++this.occurence;
                    this.element = null;
                    this.curParticle = particle;
                    groupStack = this.addItem(groupStack, this);
                    return groupStack;
                }
                for (ParticleBinding particle : UnorderedSequenceBinding.this.wildcardParticles) {
                    WildcardBinding wildcard = (WildcardBinding)particle.getTerm();
                    ElementBinding e = wildcard.getElement(qName, atts);
                    if (e == null) continue;
                    ++this.occurence;
                    this.curParticle = particle;
                    this.element = e;
                    this.wildcardContent = true;
                    groupStack = this.addItem(groupStack, this);
                    return groupStack;
                }
                return groupStack;
            }
        };
    }

    @Override
    public String getGroupType() {
        return "unordered_sequence";
    }
}

