/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.authz;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.alert.notification.RoleNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.group.ResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Role.findByIds", query="SELECT r FROM Role AS r WHERE r.id IN ( :ids )"), @NamedQuery(name="Role.findAll", query="SELECT r FROM Role AS r"), @NamedQuery(name="Role.findAvailableRolesWithExcludes", query="   SELECT DISTINCT r      FROM Role AS r LEFT JOIN r.subjects AS s     WHERE r.id NOT IN ( SELECT rr.id                           FROM Subject ss                           JOIN ss.roles AS rr                          WHERE ss.id = :subjectId )       AND r.id NOT IN ( :excludes )"), @NamedQuery(name="Role.findAvailableRoles", query="   SELECT DISTINCT r      FROM Role AS r LEFT JOIN r.subjects AS s     WHERE r.id NOT IN ( SELECT rr.id                           FROM Subject ss                           JOIN ss.roles AS rr                          WHERE ss.id = :subjectId )"), @NamedQuery(name="Role.findAvailableRolesForAlertDefinitionWithExcludes", query="SELECT r  FROM Role r WHERE r.id NOT IN ( SELECT rn.role.id                        FROM RoleNotification rn                      WHERE rn.alertDefinition.id = :alertDefinitionId )    AND r.id NOT IN ( :excludes )"), @NamedQuery(name="Role.findAvailableRolesForAlertDefinition", query="SELECT r  FROM Role r WHERE r.id NOT IN ( SELECT rn.role.id                        FROM RoleNotification rn                      WHERE rn.alertDefinition.id = :alertDefinitionId ) ")})
@SequenceGenerator(name="RHQ_ROLE_ID_SEQ", sequenceName="RHQ_ROLE_ID_SEQ")
@Table(name="RHQ_ROLE")
public class Role
implements Serializable {
    public static final String QUERY_FIND_ALL = "Role.findAll";
    public static final String QUERY_FIND_BY_IDS = "Role.findByIds";
    public static final String QUERY_FIND_AVAILABLE_ROLES_WITH_EXCLUDES = "Role.findAvailableRolesWithExcludes";
    public static final String QUERY_FIND_AVAILABLE_ROLES = "Role.findAvailableRoles";
    public static final String QUERY_FIND_AVAILABLE_ROLES_FOR_ALERT_DEFINITION_WITH_EXCLUDES = "Role.findAvailableRolesForAlertDefinitionWithExcludes";
    public static final String QUERY_FIND_AVAILABLE_ROLES_FOR_ALERT_DEFINITION = "Role.findAvailableRolesForAlertDefinition";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ROLE_ID_SEQ")
    @Id
    private Integer id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="FSYSTEM")
    private Boolean fsystem;
    @ManyToMany(mappedBy="roles")
    private Set<Subject> subjects = new HashSet<Subject>();
    @ManyToMany(mappedBy="roles")
    private Set<ResourceGroup> resourceGroups = new HashSet<ResourceGroup>();
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @CollectionOfElements(fetch=FetchType.EAGER)
    @Column(name="operation")
    @JoinTable(name="RHQ_PERMISSION", joinColumns={@JoinColumn(name="ROLE_ID")})
    private Set<Permission> permissions = new HashSet<Permission>();
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL})
    private Set<RoleNotification> roleNotifications = new HashSet<RoleNotification>();

    protected Role() {
        this.fsystem = Boolean.FALSE;
    }

    public Role(@NotNull String name) {
        this();
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getFsystem() {
        return this.fsystem;
    }

    public void setFsystem(Boolean fsystem) {
        this.fsystem = fsystem;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions.clear();
        if (permissions != null) {
            this.permissions.addAll(permissions);
        }
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    public boolean removePermission(Permission permission) {
        return this.permissions.remove((Object)permission);
    }

    public Set<Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(Set<Subject> subjects) {
        this.subjects = subjects;
    }

    public void addSubject(Subject subject) {
        if (this.subjects == null) {
            this.subjects = new HashSet<Subject>();
        }
        subject.addRole(this);
        this.subjects.add(subject);
    }

    public void removeSubject(Subject subject) {
        if (this.subjects == null) {
            this.subjects = new HashSet<Subject>();
        }
        subject.removeRole(this);
        this.subjects.remove(subject);
    }

    public Set<ResourceGroup> getResourceGroups() {
        return this.resourceGroups;
    }

    public void setResourceGroups(Set<ResourceGroup> resourceGroups) {
        this.resourceGroups = resourceGroups;
    }

    public void addResourceGroup(ResourceGroup resourceGroup) {
        if (this.resourceGroups == null) {
            this.resourceGroups = new HashSet<ResourceGroup>();
        }
        resourceGroup.addRole(this);
        this.resourceGroups.add(resourceGroup);
    }

    public void removeResourceGroup(ResourceGroup resourceGroup) {
        if (this.resourceGroups == null) {
            this.resourceGroups = new HashSet<ResourceGroup>();
        }
        resourceGroup.removeRole(this);
        this.resourceGroups.remove(resourceGroup);
    }

    public Set<RoleNotification> getRoleNotifications() {
        return this.roleNotifications;
    }

    public void setRoleNotifications(Set<RoleNotification> roleNotifications) {
        this.roleNotifications = roleNotifications;
    }

    public void addRoleNotification(RoleNotification roleNotification) {
        this.roleNotifications.add(roleNotification);
    }

    public int getMemberCount() {
        int count = 0;
        for (Subject member : this.getSubjects()) {
            if (member.getFsystem() || !member.getFactive()) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "org.rhq.core.domain.authz.Role[id=" + this.id + ", name=" + this.name + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Role)) {
            return false;
        }
        Role role = (Role)o;
        return this.name.equals(role.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

