/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.cloud;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.cloud.FailoverListDetails;
import org.rhq.core.domain.cloud.PartitionEvent;
import org.rhq.core.domain.resource.Agent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="FailoverList")
@NamedQueries(value={@NamedQuery(name="FailoverList.deletViaAgent", query="DELETE FROM FailoverList fl WHERE fl.agent = :agent"), @NamedQuery(name="FailoverList.deletViaPartitionEvent", query="DELETE FROM FailoverList fl WHERE fl.partitionEvent = :partitionEvent"), @NamedQuery(name="FailoverList.getViaAgent", query="SELECT fl FROM FailoverList fl WHERE fl.agent = :agent"), @NamedQuery(name="FailoverList.truncate", query="DELETE FROM FailoverList")})
@SequenceGenerator(name="id", sequenceName="RHQ_FAILOVER_LIST_ID_SEQ")
@Table(name="RHQ_FAILOVER_LIST")
public class FailoverList
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String QUERY_DELETE_VIA_AGENT = "FailoverList.deletViaAgent";
    public static final String QUERY_DELETE_VIA_PARTITION_EVENT = "FailoverList.deletViaPartitionEvent";
    public static final String QUERY_GET_VIA_AGENT = "FailoverList.getViaAgent";
    public static final String QUERY_TRUNCATE = "FailoverList.truncate";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    @Id
    private int id;
    @JoinColumn(name="PARTITION_EVENT_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    protected PartitionEvent partitionEvent;
    @JoinColumn(name="AGENT_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    protected Agent agent;
    @Column(name="AGENT_ID", insertable=false, updatable=false)
    private int agentId;
    @Column(name="CTIME", nullable=false)
    private long ctime;
    @OneToMany(mappedBy="failoverList", cascade={CascadeType.ALL})
    @OrderBy(value="ordinal ASC")
    private List<FailoverListDetails> serverList = new ArrayList<FailoverListDetails>();

    protected FailoverList() {
    }

    public FailoverList(PartitionEvent event, Agent agent) {
        this.partitionEvent = event;
        this.agent = agent;
    }

    public PartitionEvent getPartitionEvent() {
        return this.partitionEvent;
    }

    public void setPartitionEvent(PartitionEvent partitionEvent) {
        this.partitionEvent = partitionEvent;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public long getCtime() {
        return this.ctime;
    }

    public List<FailoverListDetails> getServerList() {
        return this.serverList;
    }

    public void setServerList(List<FailoverListDetails> serverList) {
        this.serverList = serverList;
    }

    @PrePersist
    void onPersist() {
        this.ctime = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.agentId;
        result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FailoverList)) {
            return false;
        }
        FailoverList other = (FailoverList)obj;
        if (this.agentId != other.agentId) {
            return false;
        }
        return this.ctime == other.ctime;
    }
}

