/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.util.EntitySerializer;
import org.rhq.core.domain.util.serial.ExternalizableStrategy;
import org.rhq.core.domain.util.serial.HibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="Configuration")
@NamedQueries(value={@NamedQuery(name="Configuration.getPluginConfigByResourceId", query="select r.pluginConfiguration from Resource r where r.id = :resourceId"), @NamedQuery(name="Configuration.getResourceConfigByResourceId", query="select r.resourceConfiguration from Resource r where r.id = :resourceId"), @NamedQuery(name="Configuration.getResourceConfigMapByGroupId", query="SELECT r.id, r.resourceConfiguration   FROM ResourceGroup rg   JOIN rg.explicitResources r  WHERE rg.id = :resourceGroupId"), @NamedQuery(name="Configuration.getPluginConfigMapByGroupId", query="SELECT r.id, r.pluginConfiguration   FROM ResourceGroup rg   JOIN rg.explicitResources r  WHERE rg.id = :resourceGroupId"), @NamedQuery(name="Configuration.getResourceConfigMapByGroupUpdateId", query="SELECT res.id, cu.configuration   FROM ResourceConfigurationUpdate cu   JOIN cu.resource res  WHERE cu.groupConfigurationUpdate.id = :groupConfigurationUpdateId"), @NamedQuery(name="Configuration.getPluginConfigMapByGroupUpdateId", query="SELECT res.id, cu.configuration   FROM PluginConfigurationUpdate cu   JOIN cu.resource res  WHERE cu.groupConfigurationUpdate.id = :groupConfigurationUpdateId"), @NamedQuery(name="Property.deleteByConfigurationIds", query="DELETE FROM Property p WHERE p.configuration.id IN ( :configurationIds )"), @NamedQuery(name="Configuration.deleteByConfigurationIdS", query="DELETE FROM Configuration c WHERE c.id IN ( :configurationIds )")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONFIG_ID_SEQ")
@Table(name="RHQ_CONFIG")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Configuration
implements Externalizable,
Cloneable,
AbstractPropertyMap {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_GET_PLUGIN_CONFIG_BY_RESOURCE_ID = "Configuration.getPluginConfigByResourceId";
    public static final String QUERY_GET_RESOURCE_CONFIG_BY_RESOURCE_ID = "Configuration.getResourceConfigByResourceId";
    public static final String QUERY_GET_RESOURCE_CONFIG_MAP_BY_GROUP_ID = "Configuration.getResourceConfigMapByGroupId";
    public static final String QUERY_GET_PLUGIN_CONFIG_MAP_BY_GROUP_ID = "Configuration.getPluginConfigMapByGroupId";
    public static final String QUERY_GET_RESOURCE_CONFIG_MAP_BY_GROUP_UPDATE_ID = "Configuration.getResourceConfigMapByGroupUpdateId";
    public static final String QUERY_GET_PLUGIN_CONFIG_MAP_BY_GROUP_UPDATE_ID = "Configuration.getPluginConfigMapByGroupUpdateId";
    public static final String QUERY_DELETE_PROPERTIES_BY_CONFIGURATION_IDS = "Property.deleteByConfigurationIds";
    public static final String QUERY_DELETE_CONFIGURATIONS_BY_CONFIGURATION_IDs = "Configuration.deleteByConfigurationIdS";
    @GeneratedValue(generator="SEQ", strategy=GenerationType.AUTO)
    @Id
    private int id;
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.DELETE_ORPHAN})
    @MapKey(name="name")
    @OneToMany(mappedBy="configuration", fetch=FetchType.EAGER)
    @XmlTransient
    private Map<String, Property> properties;
    @Column(name="NOTES")
    private String notes;
    @Column(name="VERSION")
    private long version;
    @Column(name="CTIME")
    private long ctime = System.currentTimeMillis();
    @Column(name="MTIME")
    private long mtime = System.currentTimeMillis();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public long getModifiedTime() {
        return this.mtime;
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    @Override
    public void put(Property value) {
        this.getMap().put(value.getName(), value);
        value.setConfiguration(this);
    }

    @Override
    public Property get(String name) {
        return this.getMap().get(name);
    }

    public Property remove(String name) {
        return this.getMap().remove(name);
    }

    @Override
    public PropertySimple getSimple(String name) {
        return (PropertySimple)this.getMap().get(name);
    }

    public String getSimpleValue(String name, String defaultValue) {
        PropertySimple property = (PropertySimple)this.getMap().get(name);
        if (property != null && property.getStringValue() != null) {
            return property.getStringValue();
        }
        return defaultValue;
    }

    @Override
    public PropertyList getList(String name) {
        return (PropertyList)this.getMap().get(name);
    }

    @Override
    public PropertyMap getMap(String name) {
        return (PropertyMap)this.getMap().get(name);
    }

    @Override
    @NotNull
    public Map<String, Property> getMap() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        return this.properties;
    }

    @NotNull
    public Collection<String> getNames() {
        return this.getMap().keySet();
    }

    @XmlElementRefs(value={@XmlElementRef(name="PropertyList", type=PropertyList.class), @XmlElementRef(name="PropertySimple", type=PropertySimple.class), @XmlElementRef(name="PropertyMap", type=PropertyMap.class)})
    @NotNull
    public Collection<Property> getProperties() {
        return this.getMap().values();
    }

    public void setProperties(Collection<Property> properties) {
        this.properties = new HashMap<String, Property>();
        for (Property p : properties) {
            this.properties.put(p.getName(), p);
        }
    }

    @XmlTransient
    @NotNull
    public Map<String, PropertyMap> getMapProperties() {
        LinkedHashMap<String, PropertyMap> map = new LinkedHashMap<String, PropertyMap>();
        for (Property prop : this.getProperties()) {
            if (!(prop instanceof PropertyMap)) continue;
            map.put(prop.getName(), (PropertyMap)prop);
        }
        return map;
    }

    @XmlTransient
    @NotNull
    public Map<String, PropertyList> getListProperties() {
        LinkedHashMap<String, PropertyList> map = new LinkedHashMap<String, PropertyList>();
        for (Property prop : this.getProperties()) {
            if (!(prop instanceof PropertyList)) continue;
            map.put(prop.getName(), (PropertyList)prop);
        }
        return map;
    }

    @XmlTransient
    @NotNull
    public Map<String, PropertySimple> getSimpleProperties() {
        LinkedHashMap<String, PropertySimple> map = new LinkedHashMap<String, PropertySimple>();
        for (Property prop : this.getProperties()) {
            if (!(prop instanceof PropertySimple)) continue;
            map.put(prop.getName(), (PropertySimple)prop);
        }
        return map;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public Configuration deepCopy() {
        return this.deepCopy(true);
    }

    public Configuration deepCopy(boolean keepIds) {
        Configuration copy;
        try {
            copy = this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("CloneNotSupported can't happen");
        }
        if (!keepIds) {
            copy.id = 0;
            for (Property property : copy.properties.values()) {
                this.clearIds(property);
            }
        }
        return copy;
    }

    private void clearIds(Property property) {
        block3: {
            block2: {
                property.setId(0);
                if (!(property instanceof PropertyList)) break block2;
                for (Property childProperty : ((PropertyList)property).getList()) {
                    this.clearIds(childProperty);
                }
                break block3;
            }
            if (!(property instanceof PropertyMap)) break block3;
            for (Property childProperty : ((PropertyMap)property).getMap().values()) {
                this.clearIds(childProperty);
            }
        }
    }

    public Configuration clone() throws CloneNotSupportedException {
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return (Configuration)obj;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)obj;
        if (this.properties == null || this.properties.isEmpty()) {
            return that.getMap() == null || that.getMap().isEmpty();
        }
        return ((Object)this.properties).equals(that.getMap());
    }

    public int hashCode() {
        return this.properties != null && !this.properties.isEmpty() ? ((Object)this.properties).hashCode() : 0;
    }

    public String toString() {
        boolean verbose = false;
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder builder = new StringBuilder("Configuration[id=").append(this.id);
        if (this.notes != null) {
            builder.append(", notes=").append(this.notes);
        }
        if (verbose) {
            for (Property property : this.getMap().values()) {
                builder.append(", ");
                builder.append(property.getName());
                builder.append("=");
                if (property instanceof PropertySimple) {
                    builder.append(((PropertySimple)property).getStringValue());
                    continue;
                }
                builder.append(property);
            }
        }
        return builder.append("]").toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableStrategy.Subsystem strategy = ExternalizableStrategy.getStrategy();
        out.writeChar(strategy.id());
        if (ExternalizableStrategy.Subsystem.REMOTEAPI == strategy) {
            this.writeExternalRemote(out);
        } else if (ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION == strategy) {
            EntitySerializer.writeExternalRemote(this, out);
        } else {
            this.writeExternalAgent(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        char c = in.readChar();
        if (ExternalizableStrategy.Subsystem.REMOTEAPI.id() == c) {
            this.readExternalRemote(in);
        } else if (ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION.id() == c) {
            EntitySerializer.readExternalRemote(this, in);
        } else {
            this.readExternalAgent(in);
        }
    }

    public void writeExternalAgent(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(HibernateUtil.safeMap(this.getMap()));
        out.writeUTF(this.notes == null ? "null" : this.notes);
        out.writeLong(this.version);
        out.writeLong(this.ctime);
        out.writeLong(this.mtime);
    }

    public void readExternalAgent(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.properties = (HashMap)in.readObject();
        this.notes = in.readUTF();
        this.version = in.readLong();
        this.ctime = in.readLong();
        this.mtime = in.readLong();
    }

    public void writeExternalRemote(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(HibernateUtil.safeMap(this.properties));
        out.writeUTF(this.notes == null ? "null" : this.notes);
        out.writeLong(this.version);
        out.writeLong(this.ctime);
        out.writeLong(this.mtime);
    }

    public void readExternalRemote(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.properties = (HashMap)in.readObject();
        this.notes = in.readUTF();
        this.version = in.readLong();
        this.ctime = in.readLong();
        this.mtime = in.readLong();
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        for (Property p : this.properties.values()) {
            p.setConfiguration(this);
        }
    }
}

