/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.definition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="ConfigurationDefinition.findResourceByResourceTypeId", query="SELECT cd FROM ResourceType rt JOIN rt.resourceConfigurationDefinition cd WHERE rt.id = :resourceTypeId"), @NamedQuery(name="ConfigurationDefinition.findPluginByResourceTypeId", query="SELECT cd FROM ResourceType rt JOIN rt.pluginConfigurationDefinition cd WHERE rt.id = :resourceTypeId")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONFIG_DEF_ID_SEQ")
@Table(name="RHQ_CONFIG_DEF")
public class ConfigurationDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_RESOURCE_BY_RESOURCE_TYPE_ID = "ConfigurationDefinition.findResourceByResourceTypeId";
    public static final String QUERY_FIND_PLUGIN_BY_RESOURCE_TYPE_ID = "ConfigurationDefinition.findPluginByResourceTypeId";
    @Column(name="id")
    @GeneratedValue(generator="SEQ", strategy=GenerationType.AUTO)
    @Id
    private int id;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="description")
    private String description;
    @MapKey(name="name")
    @OneToMany(mappedBy="configurationDefinition", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy
    private Map<String, PropertyDefinition> propertyDefinitions;
    @MapKey(name="name")
    @OneToMany(mappedBy="configurationDefinition", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy
    private Map<String, ConfigurationTemplate> templates;

    protected ConfigurationDefinition() {
    }

    public ConfigurationDefinition(@NotNull String name, String description) {
        this.name = name;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public Map<String, PropertyDefinition> getPropertyDefinitions() {
        if (this.propertyDefinitions == null) {
            this.propertyDefinitions = new LinkedHashMap<String, PropertyDefinition>();
        }
        return this.propertyDefinitions;
    }

    public void setPropertyDefinitions(Map<String, PropertyDefinition> propertyDefinitions) {
        this.propertyDefinitions = propertyDefinitions;
    }

    public void put(PropertyDefinition propertyDefinition) {
        if (this.propertyDefinitions == null) {
            this.propertyDefinitions = new LinkedHashMap<String, PropertyDefinition>();
        }
        this.propertyDefinitions.put(propertyDefinition.getName(), propertyDefinition);
        propertyDefinition.setConfigurationDefinition(this);
    }

    public PropertyDefinition get(String name) {
        return this.propertyDefinitions.get(name);
    }

    public PropertyDefinitionSimple getPropertyDefinitionSimple(String name) {
        return (PropertyDefinitionSimple)this.propertyDefinitions.get(name);
    }

    public PropertyDefinitionList getPropertyDefinitionList(String name) {
        return (PropertyDefinitionList)this.propertyDefinitions.get(name);
    }

    public PropertyDefinitionMap getPropertyDefinitionMap(String name) {
        return (PropertyDefinitionMap)this.propertyDefinitions.get(name);
    }

    @NotNull
    public List<PropertyGroupDefinition> getGroupDefinitions() {
        HashSet<PropertyGroupDefinition> groupSet = new HashSet<PropertyGroupDefinition>();
        for (PropertyDefinition propertyDefinition : this.getPropertyDefinitions().values()) {
            if (propertyDefinition.getPropertyGroupDefinition() == null) continue;
            groupSet.add(propertyDefinition.getPropertyGroupDefinition());
        }
        ArrayList<PropertyGroupDefinition> groups = new ArrayList<PropertyGroupDefinition>(groupSet.size());
        for (PropertyGroupDefinition group : groupSet) {
            groups.add(group);
        }
        Collections.sort(groups, new GroupComparator());
        return groups;
    }

    @NotNull
    public List<PropertyDefinition> getPropertiesInGroup(String groupName) {
        ArrayList<PropertyDefinition> propertyDefinitions = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition propertyDefinition : this.propertyDefinitions.values()) {
            PropertyGroupDefinition group = propertyDefinition.getPropertyGroupDefinition();
            if (group == null || !group.getName().equals(groupName)) continue;
            propertyDefinitions.add(propertyDefinition);
        }
        Collections.sort(propertyDefinitions, new PropertyDefinitionComparator());
        return propertyDefinitions;
    }

    @NotNull
    public List<PropertyDefinition> getNonGroupedProperties() {
        ArrayList<PropertyDefinition> propertyDefinitions = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition propertyDefinition : this.propertyDefinitions.values()) {
            if (propertyDefinition.getPropertyGroupDefinition() != null) continue;
            propertyDefinitions.add(propertyDefinition);
        }
        Collections.sort(propertyDefinitions, new PropertyDefinitionComparator());
        return propertyDefinitions;
    }

    @NotNull
    public Map<String, ConfigurationTemplate> getTemplates() {
        if (this.templates == null) {
            this.templates = new LinkedHashMap<String, ConfigurationTemplate>();
        }
        return this.templates;
    }

    public void putTemplate(ConfigurationTemplate template) {
        template.setConfigurationDefinition(this);
        this.getTemplates().put(template.getName(), template);
    }

    public ConfigurationTemplate removeTemplate(ConfigurationTemplate template) {
        return this.getTemplates().remove(template.getName());
    }

    @Nullable
    public ConfigurationTemplate getDefaultTemplate() {
        return this.getTemplates().get("default");
    }

    public ConfigurationTemplate getTemplate(@NotNull String name) {
        return this.getTemplates().get(name);
    }

    public Set<String> templateNamesSet() {
        return this.getTemplates().keySet();
    }

    public String toString() {
        return "ConfigurationDefinition[id=" + this.id + ", name=" + this.name + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupComparator
    implements Comparator<PropertyGroupDefinition> {
        private GroupComparator() {
        }

        @Override
        public int compare(PropertyGroupDefinition group1, PropertyGroupDefinition group2) {
            return group1.getOrder() == group2.getOrder() ? group1.getName().compareTo(group2.getName()) : Integer.valueOf(group1.getOrder()).compareTo(group2.getOrder());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyDefinitionComparator
    implements Comparator<PropertyDefinition> {
        private PropertyDefinitionComparator() {
        }

        @Override
        public int compare(PropertyDefinition propDef1, PropertyDefinition propDef2) {
            return propDef1.getOrder() == propDef2.getOrder() ? propDef1.getName().compareTo(propDef2.getName()) : Integer.valueOf(propDef1.getOrder()).compareTo(propDef2.getOrder());
        }
    }
}

