/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.definition;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;

@Entity
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONF_PROP_DEF_ENUM_ID_SEQ")
@Table(name="RHQ_CONF_PROP_DEF_ENUM")
public class PropertyDefinitionEnumeration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private long id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="STRING_VALUE", nullable=false)
    private String value;
    @Column(name="ORDER_INDEX", nullable=false)
    private int orderIndex;
    @Column(name="IS_DEFAULT")
    private boolean isDefault;
    @JoinColumn(name="PROPERTY_DEF_ID")
    @ManyToOne
    private PropertyDefinitionSimple propertyDefinitionSimple;

    protected PropertyDefinitionEnumeration() {
    }

    public PropertyDefinitionEnumeration(@NotNull String name, String value) {
        this(name, value, false);
    }

    public PropertyDefinitionEnumeration(@NotNull String name, String value, boolean isDefault) {
        this.name = name;
        this.value = value;
        this.isDefault = isDefault;
    }

    @PrePersist
    @PreUpdate
    public void updateOrder() {
        this.orderIndex = this.propertyDefinitionSimple.getEnumeratedValues().indexOf(this);
    }

    public PropertyDefinitionSimple getPropertyDefinitionSimple() {
        return this.propertyDefinitionSimple;
    }

    public void setPropertyDefinitionSimple(PropertyDefinitionSimple propertyDefinitionSimple) {
        this.propertyDefinitionSimple = propertyDefinitionSimple;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public void setOrderIndex(int orderIndex) {
        this.orderIndex = orderIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PropertyDefinitionEnumeration)) {
            return false;
        }
        PropertyDefinitionEnumeration that = (PropertyDefinitionEnumeration)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        return result;
    }

    public String toString() {
        return "PropertyDefinitionEnumeration: " + this.value;
    }
}

