/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="PackageType.findByResourceTypeId", query="SELECT pt FROM PackageType pt WHERE pt.resourceType.id = :typeId"), @NamedQuery(name="PackageType.findByResourceTypeIdAndName", query="SELECT pt FROM PackageType pt WHERE pt.resourceType.id = :typeId AND pt.name = :name"), @NamedQuery(name="PackageType.findByResourceTypeIdAndCreationFlag", query="SELECT pt FROM PackageType pt JOIN pt.resourceType rt LEFT JOIN FETCH pt.deploymentConfigurationDefinition cd LEFT JOIN FETCH cd.templates cts WHERE rt.id = :typeId AND pt.isCreationData = true")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_PACKAGE_TYPE_ID_SEQ")
@Table(name="RHQ_PACKAGE_TYPE")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PackageType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_RESOURCE_TYPE_ID = "PackageType.findByResourceTypeId";
    public static final String QUERY_FIND_BY_RESOURCE_TYPE_ID_AND_NAME = "PackageType.findByResourceTypeIdAndName";
    public static final String QUERY_FIND_BY_RESOURCE_TYPE_ID_AND_CREATION_FLAG = "PackageType.findByResourceTypeIdAndCreationFlag";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DISPLAY_NAME", nullable=true)
    private String displayName;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="CATEGORY", nullable=true)
    @Enumerated(value=EnumType.STRING)
    private PackageCategory category;
    @Column(name="DISCOVERY_INTERVAL", nullable=true)
    private long discoveryInterval;
    @Column(name="IS_CREATION_DATA", nullable=false)
    private boolean isCreationData;
    @Column(name="SUPPORTS_ARCHITECTURE", nullable=false)
    private boolean supportsArchitecture;
    @JoinColumn(name="DEPLOYMENT_CONFIG_DEF_ID", referencedColumnName="ID", nullable=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private ConfigurationDefinition deploymentConfigurationDefinition;
    @JoinColumn(name="PACKAGE_EXTRA_CONFIG_ID", referencedColumnName="ID", nullable=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private ConfigurationDefinition packageExtraPropertiesDefinition;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="packageType", cascade={CascadeType.REMOVE})
    private Set<Package> packages;
    @JoinColumn(name="RESOURCE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    @XmlTransient
    private ResourceType resourceType;

    public void afterUnmarshal(Unmarshaller u, Object resourceType) {
        this.resourceType = (ResourceType)resourceType;
    }

    public PackageType() {
    }

    public PackageType(String name, ResourceType resourceType) {
        this.setName(name);
        this.setResourceType(resourceType);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PackageCategory getCategory() {
        return this.category;
    }

    public void setCategory(PackageCategory category) {
        this.category = category;
    }

    public long getDiscoveryInterval() {
        return this.discoveryInterval;
    }

    public void setDiscoveryInterval(long discoveryInterval) {
        this.discoveryInterval = discoveryInterval;
    }

    public boolean isCreationData() {
        return this.isCreationData;
    }

    public void setCreationData(boolean creationData) {
        this.isCreationData = creationData;
    }

    public boolean isSupportsArchitecture() {
        return this.supportsArchitecture;
    }

    public void setSupportsArchitecture(boolean supportsArchitecture) {
        this.supportsArchitecture = supportsArchitecture;
    }

    public ConfigurationDefinition getDeploymentConfigurationDefinition() {
        return this.deploymentConfigurationDefinition;
    }

    public void setDeploymentConfigurationDefinition(ConfigurationDefinition deploymentConfigurationDefinition) {
        this.deploymentConfigurationDefinition = deploymentConfigurationDefinition;
    }

    public ConfigurationDefinition getPackageExtraPropertiesDefinition() {
        return this.packageExtraPropertiesDefinition;
    }

    public void setPackageExtraPropertiesDefinition(ConfigurationDefinition packageExtraPropertiesDefinition) {
        this.packageExtraPropertiesDefinition = packageExtraPropertiesDefinition;
    }

    public Set<Package> getPackages() {
        if (this.packages == null) {
            this.packages = new HashSet<Package>();
        }
        return this.packages;
    }

    public void addPackage(Package pkg) {
        this.getPackages().add(pkg);
        pkg.setPackageType(this);
    }

    public void setPackages(Set<Package> packages) {
        this.packages = packages;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void update(PackageType newType) {
        this.displayName = newType.getDisplayName();
        this.description = newType.getDescription();
        this.category = newType.getCategory();
        this.discoveryInterval = newType.getDiscoveryInterval();
        this.isCreationData = newType.isCreationData();
        this.packages = newType.getPackages();
    }

    public String toString() {
        return "PackageType[id=" + this.id + ",name=" + this.name + ",resourceType=" + (this.resourceType != null ? this.resourceType.getName() : "?") + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PackageType)) {
            return false;
        }
        PackageType other = (PackageType)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.resourceType == null ? other.resourceType != null : !this.resourceType.equals(other.resourceType));
    }
}

