/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ChannelPackageVersion;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.ProductVersionPackageVersion;
import org.rhq.core.domain.resource.ProductVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="PackageVersion.findByPackageVerArch", query="SELECT pv FROM PackageVersion AS pv  WHERE pv.generalPackage.name = :name    AND pv.generalPackage.packageType.id = :packageTypeId    AND pv.architecture.id = :architectureId    AND pv.version = :version "), @NamedQuery(name="PackageVersion.findByPackageDetailsKey", query="SELECT pv FROM PackageVersion AS pv  WHERE pv.generalPackage.name = :packageName    AND pv.generalPackage.packageType.name = :packageTypeName    AND pv.generalPackage.packageType.resourceType.id = :resourceTypeId    AND pv.architecture.name = :architectureName    AND pv.version = :version "), @NamedQuery(name="PackageVersion.findIdByPackageDetailsKeyAndResId", query="SELECT pv.id   FROM PackageVersion AS pv        JOIN pv.generalPackage.packageType.resourceType.resources r  WHERE pv.generalPackage.name = :packageName    AND pv.generalPackage.packageType.name = :packageTypeName    AND r.id = :resourceId    AND pv.architecture.name = :architectureName    AND pv.version = :version "), @NamedQuery(name="PackageVersion.findByChannelId", query="SELECT pv   FROM PackageVersion pv  WHERE pv.id IN (SELECT DISTINCT pv1.id                    FROM PackageVersion pv1                         LEFT JOIN pv1.channelPackageVersions cpv                   WHERE cpv.channel.id = :channelId) "), @NamedQuery(name="PackageVersion.findByChannelIdFiltered", query="SELECT pv   FROM PackageVersion pv  WHERE pv.id IN (SELECT DISTINCT pv1.id                    FROM PackageVersion pv1                         LEFT JOIN pv1.channelPackageVersions cpv                   WHERE cpv.channel.id = :channelId                          AND (UPPER(pv1.displayName) LIKE :filter                              OR :filter IS NULL)) "), @NamedQuery(name="PackageVersion.findByPackageId", query="SELECT pv   FROM PackageVersion pv  WHERE pv.generalPackage.id = :packageId "), @NamedQuery(name="PackageVersion.findByChannelIdWithPackage", query="SELECT pv   FROM PackageVersion pv        LEFT JOIN FETCH pv.generalPackage  WHERE pv.id IN (SELECT DISTINCT pv1.id                    FROM PackageVersion pv1                         LEFT JOIN pv1.channelPackageVersions cpv                   WHERE cpv.channel.id = :channelId) "), @NamedQuery(name="PackageVersion.findByChannelIdWithPackageFiltered", query="SELECT pv   FROM PackageVersion pv        LEFT JOIN FETCH pv.generalPackage  WHERE pv.id IN (SELECT DISTINCT pv1.id                    FROM PackageVersion pv1                         LEFT JOIN pv1.channelPackageVersions cpv                   WHERE cpv.channel.id = :channelId                          AND (UPPER(pv1.displayName) LIKE :filter                              OR :filter IS NULL)) "), @NamedQuery(name="PackageVersion.findMetadataByResourceId", query="SELECT new org.rhq.core.domain.content.composite.PackageVersionMetadataComposite                 (                    pv.id,                    pv.metadata,                    pv.generalPackage.name,                    pv.version,                    pv.generalPackage.packageType.name,                    pv.architecture.name                 )   FROM PackageVersion pv  WHERE pv.id IN (SELECT DISTINCT pv1.id                    FROM PackageVersion pv1                         LEFT JOIN pv1.channelPackageVersions cpv                         LEFT JOIN cpv.channel.resourceChannels rc                   WHERE rc.resource.id = :resourceId) "), @NamedQuery(name="PackageVersion.findByIdIfNoContentSourcesOrChannels", query="SELECT pv   FROM PackageVersion pv  WHERE pv.id = :id    AND pv.id NOT IN (SELECT pvcs.packageVersion.id                        FROM PackageVersionContentSource pvcs                       WHERE pvcs.packageVersion.id = :id)    AND pv.channelPackageVersions IS EMPTY    AND pv.installedPackages IS EMPTY    AND pv.installedPackageHistory IS EMPTY "), @NamedQuery(name="PackageVersion.getPkgBitsLengthByPkgDetailsAndResId", query="SELECT pv.fileSize   FROM PackageVersion AS pv        JOIN pv.generalPackage.packageType.resourceType.resources r  WHERE pv.generalPackage.name = :packageName    AND pv.generalPackage.packageType.name = :packageTypeName    AND r.id = :resourceId    AND pv.architecture.name = :architectureName    AND pv.version = :version "), @NamedQuery(name="PackageVersion.deleteIfNoContentSourcesOrChannels", query="DELETE PackageVersion pv  WHERE pv.id NOT IN (SELECT pvcs.packageVersion.id                        FROM PackageVersionContentSource pvcs)    AND pv.channelPackageVersions IS EMPTY    AND pv.installedPackages IS EMPTY    AND pv.installedPackageHistory IS EMPTY "), @NamedQuery(name="PackageVersion.deletePVPVIfNoContentSourcesOrChannels", query="DELETE ProductVersionPackageVersion pvpv  WHERE pvpv.packageVersion.id NOT IN (SELECT pvcs.packageVersion.id                                         FROM PackageVersionContentSource pvcs)    AND pvpv.packageVersion.channelPackageVersions IS EMPTY    AND pvpv.packageVersion.installedPackages IS EMPTY    AND pvpv.packageVersion.installedPackageHistory IS EMPTY "), @NamedQuery(name="PackageVersion.findOrphanedExtraProps", query="SELECT pv   FROM PackageVersion pv LEFT JOIN FETCH pv.extraProperties  WHERE pv.id NOT IN (SELECT pvcs.packageVersion.id                        FROM PackageVersionContentSource pvcs)    AND pv.channelPackageVersions IS EMPTY    AND pv.installedPackages IS EMPTY    AND pv.installedPackageHistory IS EMPTY    AND pv.extraProperties IS NOT NULL "), @NamedQuery(name="PackageVersion.findOrphanedFiles", query="SELECT new org.rhq.core.domain.content.composite.PackageVersionFile(           pv.id,           pv.fileName        )   FROM PackageVersion pv JOIN pv.packageBits pb  WHERE pv.id NOT IN (SELECT pvcs.packageVersion.id                        FROM PackageVersionContentSource pvcs)    AND pv.channelPackageVersions IS EMPTY    AND pv.installedPackages IS EMPTY    AND pv.installedPackageHistory IS EMPTY    AND pb.bits IS NULL "), @NamedQuery(name="PackageVersion.findCompositeById", query="SELECT new org.rhq.core.domain.content.composite.PackageVersionComposite(           pv,           pv.generalPackage.packageType.name,           pv.generalPackage.packageType.category,           pv.generalPackage.name,           pv.architecture.name,           pv.generalPackage.classification,           pv.packageBits.id,           (SELECT count(pb.id) FROM pv.packageBits pb WHERE pb.bits IS NOT NULL)        )   FROM PackageVersion pv WHERE pv.id = :id "), @NamedQuery(name="PackageVersion.findCompositeByIdWithProps", query="SELECT new org.rhq.core.domain.content.composite.PackageVersionComposite(           pv,           (SELECT c FROM Configuration c WHERE c.id = pv.extraProperties.id),           pv.generalPackage.packageType.name,           pv.generalPackage.packageType.category,           pv.generalPackage.name,           pv.architecture.name,           pv.generalPackage.classification,           pv.packageBits.id,           (SELECT count(pb.id) FROM pv.packageBits pb WHERE pb.bits IS NOT NULL)        )   FROM PackageVersion pv WHERE pv.id = :id"), @NamedQuery(name="PackageVersion.findCompositesByIds", query="SELECT new org.rhq.core.domain.content.composite.PackageVersionComposite(           pv,           pv.generalPackage.packageType.name,           pv.generalPackage.packageType.category,           pv.generalPackage.name,           pv.architecture.name,           pv.generalPackage.classification        )   FROM PackageVersion pv WHERE pv.id IN (:ids) "), @NamedQuery(name="PackageVersion.findCompositeByFilters", query="SELECT new org.rhq.core.domain.content.composite.PackageVersionComposite(           pv,           pv.generalPackage.packageType.displayName,           pv.generalPackage.packageType.category,           pv.generalPackage.name,           pv.architecture.name,           pv.generalPackage.classification        )   FROM PackageVersion pv   JOIN pv.channelPackageVersions cpv   JOIN cpv.channel.resourceChannels rc   LEFT JOIN pv.productVersionPackageVersions pvpv  WHERE rc.resource.id = :resourceId    AND cpv.channel.id = rc.channel.id    AND (UPPER(pv.displayName) LIKE :filter         OR :filter IS NULL)    AND (pv.productVersionPackageVersions IS EMPTY         OR (pv.productVersionPackageVersions IS NOT EMPTY             AND pvpv.productVersion = rc.resource.productVersion))    AND (pv.id NOT IN             (SELECT pv1.id FROM PackageVersion pv1              WHERE pv1.id IN                  (SELECT ip1.packageVersion.id FROM InstalledPackage ip1 WHERE ip1.resource.id = :resourceId)            )       )"), @NamedQuery(name="PackageVersion.findById", query="SELECT pv FROM PackageVersion pv WHERE pv.id = :id")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_PACKAGE_VERSION_ID_SEQ")
@Table(name="RHQ_PACKAGE_VERSION")
public class PackageVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_PACKAGE_VER_ARCH = "PackageVersion.findByPackageVerArch";
    public static final String QUERY_FIND_BY_PACKAGE_DETAILS_KEY = "PackageVersion.findByPackageDetailsKey";
    public static final String QUERY_FIND_ID_BY_PACKAGE_DETAILS_KEY_AND_RES_ID = "PackageVersion.findIdByPackageDetailsKeyAndResId";
    public static final String QUERY_FIND_BY_CHANNEL_ID = "PackageVersion.findByChannelId";
    public static final String QUERY_FIND_BY_CHANNEL_ID_FILTERED = "PackageVersion.findByChannelIdFiltered";
    public static final String QUERY_FIND_BY_PACKAGE_ID = "PackageVersion.findByPackageId";
    public static final String QUERY_FIND_BY_CHANNEL_ID_WITH_PACKAGE = "PackageVersion.findByChannelIdWithPackage";
    public static final String QUERY_FIND_BY_CHANNEL_ID_WITH_PACKAGE_FILTERED = "PackageVersion.findByChannelIdWithPackageFiltered";
    public static final String QUERY_FIND_METADATA_BY_RESOURCE_ID = "PackageVersion.findMetadataByResourceId";
    public static final String QUERY_FIND_BY_ID_IF_NO_CONTENT_SOURCES_OR_CHANNELS = "PackageVersion.findByIdIfNoContentSourcesOrChannels";
    public static final String QUERY_GET_PKG_BITS_LENGTH_BY_PKG_DETAILS_AND_RES_ID = "PackageVersion.getPkgBitsLengthByPkgDetailsAndResId";
    public static final String DELETE_IF_NO_CONTENT_SOURCES_OR_CHANNELS = "PackageVersion.deleteIfNoContentSourcesOrChannels";
    public static final String DELETE_PVPV_IF_NO_CONTENT_SOURCES_OR_CHANNELS = "PackageVersion.deletePVPVIfNoContentSourcesOrChannels";
    public static final String FIND_EXTRA_PROPS_IF_NO_CONTENT_SOURCES_OR_CHANNELS = "PackageVersion.findOrphanedExtraProps";
    public static final String FIND_FILES_IF_NO_CONTENT_SOURCES_OR_CHANNELS = "PackageVersion.findOrphanedFiles";
    public static final String QUERY_FIND_COMPOSITE_BY_ID = "PackageVersion.findCompositeById";
    public static final String QUERY_FIND_COMPOSITE_BY_ID_WITH_PROPS = "PackageVersion.findCompositeByIdWithProps";
    public static final String QUERY_FIND_COMPOSITES_BY_IDS = "PackageVersion.findCompositesByIds";
    public static final String QUERY_FIND_COMPOSITE_BY_FILTERS = "PackageVersion.findCompositeByFilters";
    public static final String QUERY_FIND_BY_ID = "PackageVersion.findById";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="PACKAGE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST})
    private Package generalPackage;
    @Column(name="DISPLAY_NAME", nullable=true)
    private String displayName;
    @Column(name="SHORT_DESCRIPTION", nullable=true)
    private String shortDescription;
    @Column(name="LONG_DESCRIPTION", nullable=true)
    private String longDescription;
    @Column(name="VERSION", nullable=false)
    private String version;
    @Column(name="DISPLAY_VERSION", nullable=true)
    private String displayVersion;
    @JoinColumn(name="ARCHITECTURE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    private Architecture architecture;
    @Column(name="FILE_NAME", nullable=true)
    private String fileName;
    @Column(name="FILE_SIZE", nullable=true)
    private Long fileSize;
    @Column(name="FILE_MD5", nullable=true)
    private String md5;
    @Column(name="FILE_SHA256", nullable=true)
    private String sha256;
    @Column(name="FILE_CREATION_TIME", nullable=true)
    private Long fileCreatedDate;
    @Column(name="LICENSE_NAME", nullable=true)
    private String licenseName;
    @Column(name="LICENSE_VERSION", nullable=true)
    private String licenseVersion;
    @Column(name="METADATA", nullable=true)
    private byte[] metadata;
    @JoinColumn(name="CONFIG_ID", referencedColumnName="ID", nullable=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Configuration extraProperties;
    @OneToMany(mappedBy="packageVersion", fetch=FetchType.LAZY)
    private Set<ChannelPackageVersion> channelPackageVersions;
    @OneToMany(mappedBy="packageVersion", fetch=FetchType.LAZY)
    private Set<InstalledPackage> installedPackages;
    @OneToMany(mappedBy="packageVersion", fetch=FetchType.LAZY)
    private Set<InstalledPackageHistory> installedPackageHistory;
    @JoinColumn(name="PACKAGE_BITS_ID", referencedColumnName="ID", nullable=true)
    @OneToOne(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.LAZY)
    private PackageBits packageBits;
    @OneToMany(mappedBy="packageVersion", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Set<ProductVersionPackageVersion> productVersionPackageVersions;

    public PackageVersion() {
    }

    public PackageVersion(Package pkg, String version, Architecture arch) {
        this.setGeneralPackage(pkg);
        this.setVersion(version);
        this.setArchitecture(arch);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Package getGeneralPackage() {
        return this.generalPackage;
    }

    public void setGeneralPackage(Package generalPackage) {
        this.generalPackage = generalPackage;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDisplayVersion() {
        return this.displayVersion != null ? this.displayVersion : this.version;
    }

    public void setDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getMD5() {
        return this.md5;
    }

    public void setMD5(String md5) {
        this.md5 = md5;
    }

    public String getSHA256() {
        return this.sha256;
    }

    public void setSHA256(String sha256) {
        this.sha256 = sha256;
    }

    public Long getFileCreatedDate() {
        return this.fileCreatedDate;
    }

    public void setFileCreatedDate(Long fileCreatedDate) {
        this.fileCreatedDate = fileCreatedDate;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseVersion() {
        return this.licenseVersion;
    }

    public void setLicenseVersion(String licenseVersion) {
        this.licenseVersion = licenseVersion;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public void setMetadata(byte[] metadata) {
        this.metadata = metadata;
    }

    public Configuration getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Configuration extraProperties) {
        this.extraProperties = extraProperties;
    }

    public Set<ChannelPackageVersion> getChannelPackageVersions() {
        return this.channelPackageVersions;
    }

    public Set<Channel> getChannels() {
        HashSet<Channel> channels = new HashSet<Channel>();
        if (this.channelPackageVersions != null) {
            for (ChannelPackageVersion cpv : this.channelPackageVersions) {
                channels.add(cpv.getChannelPackageVersionPK().getChannel());
            }
        }
        return channels;
    }

    public ChannelPackageVersion addChannel(Channel channel) {
        if (this.channelPackageVersions == null) {
            this.channelPackageVersions = new HashSet<ChannelPackageVersion>();
        }
        ChannelPackageVersion mapping = new ChannelPackageVersion(channel, this);
        this.channelPackageVersions.add(mapping);
        channel.addPackageVersion(this);
        return mapping;
    }

    public Set<InstalledPackage> getInstalledPackages() {
        return this.installedPackages;
    }

    public Set<InstalledPackageHistory> getInstalledPackageHistory() {
        return this.installedPackageHistory;
    }

    public ChannelPackageVersion removeChannel(Channel channel) {
        if (this.channelPackageVersions == null || channel == null) {
            return null;
        }
        ChannelPackageVersion doomed = null;
        for (ChannelPackageVersion cpv : this.channelPackageVersions) {
            if (!channel.equals(cpv.getChannelPackageVersionPK().getChannel())) continue;
            doomed = cpv;
            channel.removePackageVersion(this);
            break;
        }
        if (doomed != null) {
            this.channelPackageVersions.remove(doomed);
        }
        return doomed;
    }

    public PackageBits getPackageBits() {
        return this.packageBits;
    }

    public void setPackageBits(PackageBits packageBits) {
        this.packageBits = packageBits;
    }

    public Set<ProductVersionPackageVersion> getProductVersionPackageVersions() {
        return this.productVersionPackageVersions;
    }

    public Set<ProductVersion> getProductVersions() {
        HashSet<ProductVersion> productVersions = new HashSet<ProductVersion>();
        if (this.productVersionPackageVersions != null) {
            for (ProductVersionPackageVersion pvpv : this.productVersionPackageVersions) {
                productVersions.add(pvpv.getProductVersionPackageVersionPK().getProductVersion());
            }
        }
        return productVersions;
    }

    public ProductVersionPackageVersion addProductVersion(ProductVersion productVersion) {
        if (this.productVersionPackageVersions == null) {
            this.productVersionPackageVersions = new HashSet<ProductVersionPackageVersion>();
        }
        ProductVersionPackageVersion mapping = new ProductVersionPackageVersion(productVersion, this);
        this.productVersionPackageVersions.add(mapping);
        return mapping;
    }

    public ProductVersionPackageVersion removeProductVersion(ProductVersion productVersion) {
        if (this.productVersionPackageVersions == null || productVersion == null) {
            return null;
        }
        ProductVersionPackageVersion doomed = null;
        for (ProductVersionPackageVersion pvpv : this.productVersionPackageVersions) {
            if (!productVersion.equals(pvpv.getProductVersionPackageVersionPK().getProductVersion())) continue;
            doomed = pvpv;
            break;
        }
        if (doomed != null) {
            this.productVersionPackageVersions.remove(doomed);
        }
        return doomed;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("PackageVersion[");
        toString.append("package=").append(this.generalPackage).append(",");
        toString.append("version=").append(this.version).append(",");
        toString.append("architecture=").append(this.architecture);
        toString.append("]");
        return toString.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof PackageVersion)) {
            return false;
        }
        PackageVersion that = (PackageVersion)o;
        if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) {
            return false;
        }
        if (this.generalPackage != null ? !this.generalPackage.equals(that.generalPackage) : that.generalPackage != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.generalPackage != null ? this.generalPackage.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
        return result;
    }
}

