/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ResourceChannelPK;
import org.rhq.core.domain.resource.Resource;

@Entity
@IdClass(value=ResourceChannelPK.class)
@NamedQueries(value={@NamedQuery(name="ResourceChannel.deleteByResources", query="DELETE ResourceChannel rc WHERE rc.resource.id IN ( :resourceIds )"), @NamedQuery(name="ResourceChannel.deleteByResourceId", query="DELETE ResourceChannel rc WHERE rc.resource.id = :resourceId"), @NamedQuery(name="ResourceChannel.deleteByChannelId", query="DELETE ResourceChannel rc WHERE rc.channel.id = :channelId")})
@Table(name="RHQ_CHANNEL_RESOURCE_MAP")
public class ResourceChannel
implements Serializable {
    public static final String DELETE_BY_RESOURCES = "ResourceChannel.deleteByResources";
    public static final String DELETE_BY_RESOURCE_ID = "ResourceChannel.deleteByResourceId";
    public static final String DELETE_BY_CHANNEL_ID = "ResourceChannel.deleteByChannelId";
    private static final long serialVersionUID = 1L;
    @Id
    private Resource resource;
    @Id
    private Channel channel;
    @Column(name="CTIME", nullable=false)
    private long createdTime;

    protected ResourceChannel() {
    }

    public ResourceChannel(Resource resource, Channel channel) {
        this.resource = resource;
        this.channel = channel;
    }

    public ResourceChannelPK getResourceChannelPK() {
        return new ResourceChannelPK(this.resource, this.channel);
    }

    public void setResourceChannelPK(ResourceChannelPK pk) {
        this.resource = pk.getResource();
        this.channel = pk.getChannel();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @PrePersist
    void onPersist() {
        this.createdTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ResourceChannel: ");
        str.append("ctime=[").append(new Date(this.createdTime)).append("]");
        str.append(", re=[").append(this.resource).append("]");
        str.append(", ch=[").append(this.channel).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ResourceChannel)) {
            return false;
        }
        ResourceChannel other = (ResourceChannel)obj;
        if (this.resource == null ? this.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.channel == null ? this.channel != null : !this.channel.equals(other.channel));
    }
}

