/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.criteria;

import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.operation.JobId;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.util.PageOrdering;

public abstract class OperationHistoryCriteria
extends Criteria {
    private static final long serialVersionUID = 1L;
    private Integer filterId;
    private String filterJobName;
    private String filterJobGroup;
    private OperationRequestStatus filterStatus;
    private String filterErrorMessage;
    private Integer filterOperationDefinitionId;
    private String filterOperationName;
    private Long filterStartTime;
    private Long filterEndTime;
    private boolean fetchOperationDefinition;
    private boolean fetchParameters;
    private PageOrdering sortStatus;
    private PageOrdering sortStartTime;
    private PageOrdering sortEndTime;
    private PageOrdering sortOperationName;

    public OperationHistoryCriteria() {
        this.filterOverrides.put("operationDefinitionId", "operationDefinition.id = ?");
        this.filterOverrides.put("operationName", "operationDefinition.name like ?");
        this.filterOverrides.put("startTime", "startedTime >= ?");
        this.filterOverrides.put("endTime", "modifiedTime <= ?");
        this.filterOverrides.put("resourceIds", "id IN  ( SELECT roh.id      FROM ResourceOperationHistory roh     WHERE roh.resource.id IN ( ? ) ) ");
        this.sortOverrides.put("startTime", "startedTime");
        this.sortOverrides.put("endTime", "modifiedTime");
        this.sortOverrides.put("operationName", "operationDefinition.name");
    }

    public void addFilterId(Integer filterId) {
        this.filterId = filterId;
    }

    public void addFilterJobId(JobId filterJobId) {
        this.filterJobName = filterJobId.getJobName();
        this.filterJobGroup = filterJobId.getJobGroup();
    }

    public void addFilterStatus(OperationRequestStatus filterStatus) {
        this.filterStatus = filterStatus;
    }

    public void addFilterErrorMessage(String filterErrorMessage) {
        this.filterErrorMessage = filterErrorMessage;
    }

    public void addFilterOperationDefinitionId(Integer filterOperationDefinitionId) {
        this.filterOperationDefinitionId = filterOperationDefinitionId;
    }

    public void addFilterOperationName(String filterOperationName) {
        this.filterOperationName = filterOperationName;
    }

    public void addFilterStartTime(Long filterStartTime) {
        this.filterStartTime = filterStartTime;
    }

    public void addFilterEndTime(Long filterEndTime) {
        this.filterEndTime = filterEndTime;
    }

    public void fetchOperationDefinition(boolean fetchOperationDefinition) {
        this.fetchOperationDefinition = fetchOperationDefinition;
    }

    public void fetchParameters(boolean fetchParameters) {
        this.fetchParameters = fetchParameters;
    }

    public void addSortStatus(PageOrdering sortStatus) {
        this.addSortField("sort");
        this.sortStatus = sortStatus;
    }

    public void addSortStartTime(PageOrdering sortStartTime) {
        this.addSortField("startTime");
        this.sortStartTime = sortStartTime;
    }

    public void addSortEndTime(PageOrdering sortEndTime) {
        this.addSortField("endTime");
        this.sortEndTime = sortEndTime;
    }

    public void addSortOperationName(PageOrdering sortOperationName) {
        this.addSortField("operationName");
        this.sortOperationName = sortOperationName;
    }
}

