/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.criteria;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageOrdering;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class PackageVersionCriteria
extends Criteria {
    private static final long serialVersionUID = 1L;
    private Integer filterId;
    private Integer filterChannelId;
    private Integer filterResourceId;
    private Integer filterPackageTypeId;
    private String filterDisplayName;
    private String filterVersion;
    private String filterFileName;
    private Long filterFileSizeMinimum;
    private Long filterFileSizeMaximum;
    private String filterLicenseName;
    private String filterLicenseVersion;
    private boolean fetchPackage;
    private boolean fetchArchitecture;
    private boolean fetchExtraProperties;
    private boolean fetchChannelPackageVersions;
    private boolean fetchInstalledPackages;
    private boolean fetchInstalledPackageHistory;
    private boolean fetchProductVersionPackageVersions;
    private PageOrdering sortDisplayName;

    public PackageVersionCriteria() {
        this.filterOverrides.put("channelId", "id IN ( SELECT cpv.packageVersion.id    FROM pv.channelPackageVersions cpv    WHERE cpv.channel.id = ? )");
        this.filterOverrides.put("fileSizeMinimum", "fileSize >= ?");
        this.filterOverrides.put("fileSizeMaximum", "fileSize <= ?");
        this.filterOverrides.put("packageTypeId", "generalPackage.packageType.id = ? ");
        this.filterOverrides.put("resourceId", "id IN ( SELECT ip.packageVersion.id    FROM pv.installedPackages ip    WHERE ip.resource.id = ? )");
    }

    public void addFilterId(Integer filterId) {
        this.filterId = filterId;
    }

    public void addFilterChannelId(Integer filterChannelId) {
        this.filterChannelId = filterChannelId;
    }

    public Integer getFilterChannelId() {
        return this.filterChannelId;
    }

    public void addFilterResourceId(Integer filterResourceId) {
        this.filterResourceId = filterResourceId;
    }

    public Integer getFilterResourceId() {
        return this.filterResourceId;
    }

    public void addFilterPackageTypeId(Integer filterPackageTypeId) {
        this.filterPackageTypeId = filterPackageTypeId;
    }

    public void addFilterDisplayName(String filterDisplayName) {
        this.filterDisplayName = filterDisplayName;
    }

    public void addFilterVersion(String filterVersion) {
        this.filterVersion = filterVersion;
    }

    public void addFilterFileName(String filterFileName) {
        this.filterFileName = filterFileName;
    }

    public void addFilterFileSizeMinimum(Long filterFileSizeMinimum) {
        this.filterFileSizeMinimum = filterFileSizeMinimum;
    }

    public void addFilterFileSizeMaximum(Long filterFileSizeMaximum) {
        this.filterFileSizeMaximum = filterFileSizeMaximum;
    }

    public void addFilterLicenseName(String filterLicenseName) {
        this.filterLicenseName = filterLicenseName;
    }

    public void addFilterLicenseVersion(String filterLicenseVersion) {
        this.filterLicenseVersion = filterLicenseVersion;
    }

    public void fetchPackage(boolean fetchPackage) {
        this.fetchPackage = fetchPackage;
    }

    public void fetchArchitecture(boolean fetchArchitecture) {
        this.fetchArchitecture = fetchArchitecture;
    }

    public void fetchExtraProperties(boolean fetchExtraProperties) {
        this.fetchExtraProperties = fetchExtraProperties;
    }

    public void fetchChannelPackageVersions(boolean fetchChannelPackageVersions) {
        this.fetchChannelPackageVersions = fetchChannelPackageVersions;
    }

    public void fetchInstalledPackages(boolean fetchInstalledPackages) {
        this.fetchInstalledPackages = fetchInstalledPackages;
        if (fetchInstalledPackages) {
            this.addRequiredPermission(Permission.MANAGE_INVENTORY);
        }
    }

    public void fetchInstalledPackageHistory(boolean fetchInstalledPackageHistory) {
        this.fetchInstalledPackageHistory = fetchInstalledPackageHistory;
        if (fetchInstalledPackageHistory) {
            this.addRequiredPermission(Permission.MANAGE_INVENTORY);
        }
    }

    public void fetchProductVersionPackageVersions(boolean fetchProductVersionPackageVersions) {
        this.fetchProductVersionPackageVersions = fetchProductVersionPackageVersions;
    }

    public void addSortDisplayName(PageOrdering sortDisplayName) {
        this.addSortField("displayName");
        this.sortDisplayName = sortDisplayName;
    }
}

