/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="EventSource.deleteByResources", query="DELETE FROM EventSource evs WHERE evs.resource.id IN ( :resourceIds ) "), @NamedQuery(name="EventSource.deletebyEventDefinition", query="SELECT evs FROM EventSource evs WHERE evs.eventDefinition = :definition")})
@Table(name="RHQ_EVENT_SOURCE")
@SequenceGenerator(name="idGenerator", sequenceName="RHQ_EVENT_SOURCE_ID_SEQ", allocationSize=100)
public class EventSource
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "RHQ_EVENT_SOURCE";
    public static final String QUERY_DELETE_BY_RESOURCES = "EventSource.deleteByResources";
    public static final String QUERY_BY_EVENT_DEFINITION = "EventSource.deletebyEventDefinition";
    @Id
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="idGenerator")
    private int id;
    @JoinColumn(name="EVENT_DEF_ID", nullable=false)
    @ManyToOne
    private EventDefinition eventDefinition;
    @JoinColumn(name="RESOURCE_ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Resource resource;
    @Column(name="RESOURCE_ID", insertable=false, updatable=false)
    private int resourceId;
    @Column(name="LOCATION", length=2000, nullable=false)
    private String location;
    @OneToMany(mappedBy="source", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Set<Event> events = new HashSet<Event>();

    public EventSource() {
    }

    public EventSource(@NotNull String location, @NotNull EventDefinition eventDefinition, @NotNull Resource resource) {
        if (location == null) {
            throw new IllegalArgumentException("location parameter must not be null.");
        }
        if (eventDefinition == null) {
            throw new IllegalArgumentException("eventDefinition parameter must not be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource parameter must not be null.");
        }
        this.location = location;
        this.eventDefinition = eventDefinition;
        this.resource = resource;
        this.resourceId = this.resource.getId();
    }

    public int getId() {
        return this.id;
    }

    public EventDefinition getEventDefinition() {
        return this.eventDefinition;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    @NotNull
    public String getLocation() {
        return this.location;
    }

    public Set<Event> getEvents() {
        return this.events;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof EventSource)) {
            return false;
        }
        EventSource that = (EventSource)obj;
        if (!this.eventDefinition.equals(that.eventDefinition)) {
            return false;
        }
        if (this.resourceId != that.resourceId) {
            return false;
        }
        return this.location.equals(that.location);
    }

    public int hashCode() {
        int result = this.eventDefinition.hashCode();
        result = 31 * result + this.resourceId;
        result = 31 * result + this.location.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "id=" + this.id + ", " + "eventDefinition.name=" + (this.eventDefinition != null ? this.eventDefinition.getName() : "null") + ", " + "resource.name=" + (this.resource != null ? this.resource.getName() : "null") + ", " + "location=" + this.location + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.eventDefinition);
        out.writeInt(this.resource != null ? this.resource.getId() : 0);
        out.writeUTF(this.location);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.eventDefinition = (EventDefinition)in.readObject();
        int resourceId = in.readInt();
        this.resource = new Resource(resourceId);
        this.location = in.readUTF();
    }
}

