/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement.calltime;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.measurement.MeasurementSchedule;

@Entity
@NamedQueries(value={@NamedQuery(name="CallTimeDataKey.deleteByResources", query="DELETE CallTimeDataKey ctdk WHERE ctdk.schedule IN ( SELECT ms FROM MeasurementSchedule ms WHERE ms.resource.id IN ( :resourceIds ) )")})
@SequenceGenerator(name="idGenerator", sequenceName="RHQ_CALLTIME_DATA_KEY_ID_SEQ")
@Table(name="RHQ_CALLTIME_DATA_KEY")
public class CallTimeDataKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_DELETE_BY_RESOURCES = "CallTimeDataKey.deleteByResources";
    public static final int DESTINATION_MAX_LENGTH = 4000;
    @GeneratedValue(strategy=GenerationType.AUTO, generator="idGenerator")
    @Id
    private int id;
    @JoinColumn(name="SCHEDULE_ID", insertable=false, updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private MeasurementSchedule schedule;
    @Column(name="CALL_DESTINATION", length=4000, nullable=false)
    private String callDestination;

    public CallTimeDataKey(@NotNull MeasurementSchedule schedule, @NotNull String callDestination) {
        this.schedule = schedule;
        this.callDestination = callDestination;
    }

    protected CallTimeDataKey() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Nullable
    public MeasurementSchedule getSchedule() {
        return this.schedule;
    }

    @NotNull
    public String getCallDestination() {
        return this.callDestination;
    }

    public String toString() {
        return "MeasurementCallDestination[id=" + this.id + ", " + "value=" + this.callDestination + "]";
    }
}

