/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.operation;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.ResourceType;

@Entity
@NamedQueries(value={@NamedQuery(name="OperationDefinition.findByTypeAndName", query="   SELECT od      FROM OperationDefinition AS od     WHERE od.resourceType.id = :resourceTypeId       AND ( od.name = :operationName or :operationName IS NULL ) ORDER BY od.displayName"), @NamedQuery(name="OperationDefinition.findLightWeightByTypeAndName", query="   SELECT new org.rhq.core.domain.operation.OperationDefinition           ( od.id, od.name, od.resourceVersionRange, od.description, od.timeout, od.displayName )      FROM OperationDefinition AS od     WHERE od.resourceType.id = :resourceTypeId       AND ( od.name = :operationName or :operationName IS NULL ) ORDER BY od.displayName"), @NamedQuery(name="OperationDefinition.findByResourceAndName", query="   SELECT od      FROM OperationDefinition AS od, Resource res     WHERE od.resourceType.id = res.resourceType.id       AND res.id = :resourceId       AND ( od.name = :operationName or :operationName IS NULL ) ORDER BY od.displayName"), @NamedQuery(name="OperationDefinition.findLightWeightByResourceAndName", query="   SELECT new org.rhq.core.domain.operation.OperationDefinition           ( od.id, od.name, od.resourceVersionRange, od.description, od.timeout, od.displayName )      FROM OperationDefinition AS od, Resource res     WHERE od.resourceType.id = res.resourceType.id       AND res.id = :resourceId       AND ( od.name = :operationName or :operationName IS NULL ) ORDER BY od.displayName"), @NamedQuery(name="OperationDefinition.findByGroupAndName", query="   SELECT od      FROM OperationDefinition AS od, ResourceGroup rg     WHERE od.resourceType.id = rg.resourceType.id       AND rg.id = :groupId       AND ( od.name = :operationName or :operationName IS NULL ) ORDER BY od.displayName"), @NamedQuery(name="OperationDefinition.findLightWeightByGroupAndName", query="   SELECT new org.rhq.core.domain.operation.OperationDefinition           ( od.id, od.name, od.resourceVersionRange, od.description, od.timeout, od.displayName )      FROM OperationDefinition AS od, ResourceGroup rg     WHERE od.resourceType.id = rg.resourceType.id       AND rg.id = :groupId       AND ( od.name = :operationName or :operationName IS NULL ) ORDER BY od.displayName")})
@SequenceGenerator(name="id", sequenceName="RHQ_OPERATION_DEF_ID_SEQ")
@Table(name="RHQ_OPERATION_DEF")
public class OperationDefinition
implements Serializable {
    public static final String QUERY_FIND_BY_TYPE_AND_NAME = "OperationDefinition.findByTypeAndName";
    public static final String QUERY_FIND_LIGHT_WEIGHT_BY_TYPE_AND_NAME = "OperationDefinition.findLightWeightByTypeAndName";
    public static final String QUERY_FIND_BY_RESOURCE_AND_NAME = "OperationDefinition.findByResourceAndName";
    public static final String QUERY_FIND_LIGHT_WEIGHT_BY_RESOURCE_AND_NAME = "OperationDefinition.findLightWeightByResourceAndName";
    public static final String QUERY_FIND_BY_GROUP_AND_NAME = "OperationDefinition.findByGroupAndName";
    public static final String QUERY_FIND_LIGHT_WEIGHT_BY_GROUP_AND_NAME = "OperationDefinition.findLightWeightByGroupAndName";
    private static final long serialVersionUID = 1L;
    public static final String TIMEOUT_PARAM_NAME = "rhq.timeout";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    @Id
    private int id;
    @JoinColumn(name="RESOURCE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private ResourceType resourceType;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="RESOURCE_VERSION_RANGE")
    private String resourceVersionRange;
    @JoinColumn(name="PARAMETER_CONFIG_DEF_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL})
    private ConfigurationDefinition parametersConfigurationDefinition;
    @JoinColumn(name="RESULTS_CONFIG_DEF_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL})
    private ConfigurationDefinition resultsConfigurationDefinition;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="TIMEOUT")
    private Integer timeout;
    @Column(name="DISPLAY_NAME")
    private String displayName;

    protected OperationDefinition() {
    }

    public OperationDefinition(int id, String name, String resourceVersionRange, String description, Integer timeout, String displayName) {
        this(name, resourceVersionRange, description);
        this.setId(id);
        this.setTimeout(timeout);
        this.setDisplayName(displayName);
    }

    public OperationDefinition(@NotNull String name, String resourceVersionRange, String description) {
        this.name = name;
        this.resourceVersionRange = resourceVersionRange;
        this.description = description;
    }

    public OperationDefinition(ResourceType resourceType, @NotNull String name) {
        this.resourceType = resourceType;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getResourceVersionRange() {
        return this.resourceVersionRange;
    }

    public void setResourceVersionRange(String resourceVersionRange) {
        this.resourceVersionRange = resourceVersionRange;
    }

    public ConfigurationDefinition getParametersConfigurationDefinition() {
        return this.parametersConfigurationDefinition;
    }

    public void setParametersConfigurationDefinition(ConfigurationDefinition parametersConfigurationDefinition) {
        this.parametersConfigurationDefinition = parametersConfigurationDefinition;
    }

    public ConfigurationDefinition getResultsConfigurationDefinition() {
        return this.resultsConfigurationDefinition;
    }

    public void setResultsConfigurationDefinition(ConfigurationDefinition resultsConfigurationDefinition) {
        this.resultsConfigurationDefinition = resultsConfigurationDefinition;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "OperationDefinition[id=" + this.id + ", resourceType=" + this.resourceType + ", name=" + this.name + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OperationDefinition)) {
            return false;
        }
        OperationDefinition that = (OperationDefinition)obj;
        return this.name.equals(that.name) && this.resourceType.equals(that.resourceType);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = this.name.hashCode();
        result = 31 * result + this.resourceType.hashCode();
        return result;
    }
}

