/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.ProductVersionPackageVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="ProductVersion.findByResourceTypeAndVersion", query="SELECT pv FROM ProductVersion AS pv WHERE pv.resourceType = :resourceType AND pv.version = :version")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_PRD_VER_ID_SEQ")
@Table(name="RHQ_PRD_VER")
public class ProductVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_RESOURCE_TYPE_AND_VERSION = "ProductVersion.findByResourceTypeAndVersion";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="VERSION", nullable=false)
    private String version;
    @JoinColumn(name="RES_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private ResourceType resourceType;
    @OneToMany(mappedBy="productVersion", fetch=FetchType.LAZY)
    private Set<Resource> resources;
    @OneToMany(mappedBy="productVersion", fetch=FetchType.LAZY)
    private Set<ProductVersionPackageVersion> productVersionPackageVersions;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public Set<ProductVersionPackageVersion> getProductVersionPackageVersions() {
        return this.productVersionPackageVersions;
    }

    public Set<PackageVersion> getPackageVersions() {
        HashSet<PackageVersion> packageVersions = new HashSet<PackageVersion>();
        if (this.productVersionPackageVersions != null) {
            for (ProductVersionPackageVersion pvpv : this.productVersionPackageVersions) {
                packageVersions.add(pvpv.getProductVersionPackageVersionPK().getPackageVersion());
            }
        }
        return packageVersions;
    }

    public ProductVersionPackageVersion addPackageVersion(PackageVersion packageVersion) {
        if (this.productVersionPackageVersions == null) {
            this.productVersionPackageVersions = new HashSet<ProductVersionPackageVersion>();
        }
        ProductVersionPackageVersion mapping = new ProductVersionPackageVersion(this, packageVersion);
        this.productVersionPackageVersions.add(mapping);
        return mapping;
    }

    public ProductVersionPackageVersion removePackageVersion(PackageVersion packageVersion) {
        if (this.productVersionPackageVersions == null || packageVersion == null) {
            return null;
        }
        ProductVersionPackageVersion doomed = null;
        for (ProductVersionPackageVersion pvpv : this.productVersionPackageVersions) {
            if (!packageVersion.equals(pvpv.getProductVersionPackageVersionPK().getPackageVersion())) continue;
            doomed = pvpv;
            break;
        }
        if (doomed != null) {
            this.productVersionPackageVersions.remove(doomed);
        }
        return doomed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductVersion)) {
            return false;
        }
        ProductVersion that = (ProductVersion)o;
        if (!this.resourceType.equals(that.resourceType)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = 31 * result + this.resourceType.hashCode();
        return result;
    }

    public String toString() {
        return "ProductVersion[Version=" + this.version + ", " + this.resourceType + "]";
    }
}

