/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PostPersist;
import javax.persistence.PrePersist;
import javax.persistence.QueryHint;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ContentServiceRequest;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.content.ResourceChannel;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.DeleteResourceHistory;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.EntitySerializer;
import org.rhq.core.domain.util.Summary;
import org.rhq.core.domain.util.serial.ExternalizableStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Resource.findProblemResourcesAlert_admin", query="  SELECT DISTINCT new org.rhq.core.domain.resource.composite.ProblemResourceComposite         (          res.id, res.name, res.currentAvailability.availabilityType, COUNT(DISTINCT alert.id)         )     FROM Resource res          LEFT JOIN res.alertDefinitions alertDef          LEFT JOIN alertDef.alerts alert     WHERE res.inventoryStatus = 'COMMITTED'      AND (( res.currentAvailability.availabilityType = 0)           OR (alert.ctime >= :oldest)) GROUP BY res.id, res.name, res.currentAvailability.availabilityType "), @NamedQuery(name="Resource.findProblemResourcesAlert", query="  SELECT DISTINCT new org.rhq.core.domain.resource.composite.ProblemResourceComposite         (          res.id, res.name, res.currentAvailability.availabilityType, COUNT(DISTINCT alert.id)         )     FROM Resource res          LEFT JOIN res.alertDefinitions alertDef          LEFT JOIN alertDef.alerts alert     WHERE res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)     AND res.inventoryStatus = 'COMMITTED'      AND (( res.currentAvailability.availabilityType = 0)           OR (alert.ctime >= :oldest)) GROUP BY res.id, res.name, res.currentAvailability.availabilityType "), @NamedQuery(name="Resource.findProblemResourcesAlertCount_admin", query="  SELECT COUNT( DISTINCT res.id )     FROM Resource res          LEFT JOIN res.alertDefinitions alertDef          LEFT JOIN alertDef.alerts alert     WHERE res.inventoryStatus = 'COMMITTED'      AND (( res.currentAvailability.availabilityType = 0)           OR (alert.ctime >= :oldest)) "), @NamedQuery(name="Resource.findProblemResourcesAlertCount", query="  SELECT COUNT( DISTINCT res.id )     FROM Resource res          LEFT JOIN res.alertDefinitions alertDef          LEFT JOIN alertDef.alerts alert     WHERE res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)     AND res.inventoryStatus = 'COMMITTED'      AND (( res.currentAvailability.availabilityType = 0)           OR (alert.ctime >= :oldest)) "), @NamedQuery(name="Resource.findByParentAndType", query="  SELECT res, a.availabilityType     FROM Resource res     JOIN res.currentAvailability a    WHERE res.parentResource = :parent      AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)     AND res.resourceType = :type      AND res.inventoryStatus = :inventoryStatus ORDER BY res.name"), @NamedQuery(name="Resource.findByParentAndType_admin", query="  SELECT res, a.availabilityType     FROM Resource res     JOIN res.currentAvailability a    WHERE res.parentResource = :parent      AND res.resourceType = :type      AND res.inventoryStatus = :inventoryStatus ORDER BY res.name"), @NamedQuery(name="Resource.findForAutogroup", query="SELECT res   FROM Resource res  WHERE res.parentResource.id = :parent    AND res.resourceType.id = :type    AND res.inventoryStatus = :inventoryStatus "), @NamedQuery(name="Resource.findByParentAndInventoryStatus", query="SELECT res   FROM Resource res  WHERE res.parentResource = :parent    AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)   AND res.inventoryStatus = :inventoryStatus "), @NamedQuery(name="Resource.findByParentAndInventoryStatus_admin", query="SELECT res   FROM Resource res  WHERE res.parentResource = :parent    AND res.inventoryStatus = :inventoryStatus "), @NamedQuery(name="Resource.findValidCommittedResourceIds_admin", query="SELECT res.id   FROM Resource res  WHERE res.inventoryStatus = 'COMMITTED'    AND res.id IN ( :resourceIds ) "), @NamedQuery(name="Resource.findChildrenIds_admin", query="SELECT res.id   FROM Resource res  WHERE res.parentResource.id = :parentResourceId    AND (:inventoryStatus = res.inventoryStatus OR :inventoryStatus is null)"), @NamedQuery(name="Resource.findChildrenIdsByParentIds", query="SELECT res.id   FROM Resource res  WHERE res.parentResource.id IN ( :parentIds ) "), @NamedQuery(name="Resource.findChildren", query="SELECT res   FROM Resource res  WHERE res.parentResource = :parent    AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)"), @NamedQuery(name="Resource.findChildren_admin", query="SELECT res   FROM Resource res  WHERE res.parentResource = :parent "), @NamedQuery(name="Resource.findRecentlyAddedPlatforms", query="  SELECT DISTINCT new org.rhq.core.domain.resource.composite.RecentlyAddedResourceComposite(res.id, res.name, res.itime)     FROM Resource res JOIN res.childResources child JOIN res.implicitGroups g JOIN g.roles r JOIN r.subjects s    WHERE (res.itime >= :oldestEpochTime OR ((child.itime >= :oldestEpochTime) AND (child.inventoryStatus = 'COMMITTED')))      AND res.resourceType.category = 'PLATFORM'      AND res.inventoryStatus = 'COMMITTED'      AND s = :subject ORDER BY res.itime DESC "), @NamedQuery(name="Resource.findRecentlyAddedPlatforms_admin", query="  SELECT DISTINCT new org.rhq.core.domain.resource.composite.RecentlyAddedResourceComposite(res.id, res.name, res.itime)     FROM Resource res JOIN res.childResources child    WHERE ((res.itime >= :oldestEpochTime) OR ((child.itime >= :oldestEpochTime) AND (child.inventoryStatus = 'COMMITTED')))      AND res.resourceType.category = 'PLATFORM'      AND res.inventoryStatus = 'COMMITTED' ORDER BY res.itime DESC "), @NamedQuery(name="Resource.findRecentlyAddedServers", query="  SELECT DISTINCT new org.rhq.core.domain.resource.composite.RecentlyAddedResourceComposite(res.id, res.name, res.itime)     FROM Resource res JOIN res.implicitGroups g JOIN g.roles r JOIN r.subjects s    WHERE res.itime >= :oldestEpochTime      AND res.resourceType.category = 'SERVER'      AND res.inventoryStatus = 'COMMITTED'      AND res.parentResource.id = :platformId      AND s = :subject ORDER BY res.itime DESC "), @NamedQuery(name="Resource.findRecentlyAddedServers_admin", query="  SELECT DISTINCT new org.rhq.core.domain.resource.composite.RecentlyAddedResourceComposite(res.id, res.name, res.itime)     FROM Resource res    WHERE res.itime >= :oldestEpochTime      AND res.resourceType.category = 'SERVER'      AND res.inventoryStatus = 'COMMITTED'      AND res.parentResource.id = :platformId ORDER BY res.itime DESC "), @NamedQuery(name="Resource.findAvailabilityByResourceId", query="SELECT new org.rhq.core.domain.resource.composite.ResourceWithAvailability(res, a.availabilityType)   FROM Resource res   JOIN res.currentAvailability a  WHERE res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)   AND res.id = :id "), @NamedQuery(name="Resource.findAvailabilityByResourceId_admin", query="SELECT new org.rhq.core.domain.resource.composite.ResourceWithAvailability(res, a.availabilityType)   FROM Resource res JOIN res.currentAvailability a  WHERE res.id = :id "), @NamedQuery(name="Resource.findAvailabilityByResourceIds", query="SELECT res, a.availabilityType   FROM Resource res   LEFT OUTER JOIN res.availability a  WHERE (a is null OR a.startTime = (SELECT MAX(aa.startTime) FROM Availability aa where res.id = aa.resource.id))    AND res.id IN (:ids)    AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)ORDER BY res.name "), @NamedQuery(name="Resource.findAvailabilityByResourceIds_admin", query="SELECT res, a.availabilityType   FROM Resource res   LEFT OUTER JOIN res.availability a  WHERE (a is null OR a.startTime = (SELECT MAX(aa.startTime) FROM Availability aa where res.id = aa.resource.id))    AND res.id IN (:ids) ORDER BY res.name "), @NamedQuery(name="Resource.findResourceAutogroupComposite", query="  SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))     FROM Resource res     JOIN res.resourceType rt LEFT JOIN rt.subCategory JOIN res.currentAvailability a    WHERE res.id = :id      AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)GROUP BY res.parentResource, rt "), @NamedQuery(name="Resource.findResourceAutogroupsComposite", query="  SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))     FROM Resource res     JOIN res.resourceType rt  JOIN res.currentAvailability a    WHERE res.id IN ( :ids )      AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)GROUP BY res.parentResource, rt "), @NamedQuery(name="Resource.findResourceAutogroupComposite_admin", query="  SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))     FROM Resource res JOIN res.currentAvailability a JOIN res.resourceType rt LEFT JOIN rt.subCategory    WHERE res.id = :id GROUP BY res.parentResource, rt"), @NamedQuery(name="Resource.findResourceAutogroupsComposite_admin", query="  SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))     FROM Resource res JOIN res.currentAvailability a JOIN res.resourceType rt LEFT JOIN rt.subCategory    WHERE res.id IN ( :ids ) GROUP BY res.parentResource, rt"), @NamedQuery(name="Resource.findChildrenAutogroupComposites", query="  SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))     FROM Resource res     JOIN res.resourceType rt LEFT JOIN rt.subCategory JOIN res.currentAvailability a    WHERE res.parentResource = :parent      AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)     AND res.inventoryStatus = :inventoryStatus GROUP BY res.parentResource, rt "), @NamedQuery(name="Resource.findChildrenAutogroupComposites_admin", query="   SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))      FROM Resource res      JOIN res.currentAvailability a      JOIN res.resourceType rt LEFT JOIN rt.subCategory     WHERE res.parentResource = :parent       AND res.inventoryStatus = :inventoryStatus GROUP BY res.parentResource, rt"), @NamedQuery(name="Resource.findChildrenAutogroupCompositesByType", query="  SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))     FROM Resource res     JOIN res.resourceType rt LEFT JOIN rt.subCategory JOIN res.currentAvailability a    WHERE res.parentResource = :parent      AND rt.id IN ( :resourceTypeIds )      AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)     AND res.inventoryStatus = :inventoryStatus GROUP BY res.parentResource, rt "), @NamedQuery(name="Resource.findChildrenAutogroupCompositesByType_admin", query="   SELECT new org.rhq.core.domain.resource.group.composite.AutoGroupComposite(avg(a.availabilityType), res.parentResource, rt, count(res))      FROM Resource res      JOIN res.currentAvailability a      JOIN res.resourceType rt LEFT JOIN rt.subCategory     WHERE res.parentResource = :parent       AND rt.id IN ( :resourceTypeIds )       AND res.inventoryStatus = :inventoryStatus GROUP BY res.parentResource, rt"), @NamedQuery(name="Resource.findChildrenByCategoryAndInventoryStatus", query="SELECT res   FROM Resource res  WHERE res.parentResource = :parent    AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)   AND res.resourceType.category = :category    AND res.inventoryStatus = :status "), @NamedQuery(name="Resource.findChildrenByCategoryAndInventoryStatus_admin", query="SELECT res   FROM Resource res  WHERE res.parentResource = :parent    AND res.inventoryStatus = :status    AND res.resourceType.category = :category "), @NamedQuery(name="Resource.findByCategoryAndInventoryStatus", query="SELECT res   FROM Resource res  WHERE res.resourceType.category = :category    AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)   AND (:inventoryStatus = res.inventoryStatus OR :inventoryStatus is null) "), @NamedQuery(name="Resource.findByCategoryAndInventoryStatus_admin", query="SELECT res   FROM Resource res  WHERE res.resourceType.category = :category    AND (:inventoryStatus = res.inventoryStatus OR :inventoryStatus is null) "), @NamedQuery(name="Resource.findQueuedPlatformsByInventoryStatus", query="SELECT res FROM Resource res WHERE    ((       res.id IN       (SELECT res1.id          FROM Resource res1         WHERE res1.inventoryStatus IN (:inventoryStatuses)           AND res1.resourceType.category = 'PLATFORM'           AND res1.parentResource IS NULL)     )     OR     (       res.id IN       (SELECT res2.parentResource.id          FROM Resource res2         WHERE res2.inventoryStatus IN (:inventoryStatuses)           AND res2.resourceType.category = 'SERVER'           AND res2.parentResource.resourceType.category = 'PLATFORM')     )) "), @NamedQuery(name="Resource.findByType", query="SELECT res   FROM Resource res  WHERE res.resourceType = :type    AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject) "), @NamedQuery(name="Resource.findByType_admin", query="SELECT res   FROM Resource res  WHERE res.resourceType = :type "), @NamedQuery(name="Resource.findByTypeAndIds", query="SELECT res   FROM Resource res  WHERE res.resourceType = :type    AND res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)   AND res.id IN ( :ids ) "), @NamedQuery(name="Resource.findByTypeAndIds_admin", query="SELECT res   FROM Resource res  WHERE res.resourceType = :type    AND res.id IN ( :ids ) "), @NamedQuery(name="Resource.findByParentAndKey", hints={@QueryHint(name="cacheable", value="true")}, query="SELECT r   FROM Resource AS r  WHERE (:parent = r.parentResource OR :parent IS NULL)    AND r.resourceKey = :key    AND r.resourceType.plugin = :plugin    AND r.resourceType.name = :typeName"), @NamedQuery(name="Resource.findExplicitIdsByResourceGroup_admin", query="SELECT res.id   FROM ResourceGroup rg, IN (rg.explicitResources) res  WHERE rg.id = :groupId "), @NamedQuery(name="Resource.findImplicitIdsByResourceGroup_admin", query="SELECT res.id   FROM ResourceGroup rg, IN (rg.implicitResources) res  WHERE rg.id = :groupId "), @NamedQuery(name="Resource.findFlyWeights", query="SELECT new org.rhq.core.domain.resource.composite.ResourceIdFlyWeight(res.id, res.uuid)   FROM Resource res  WHERE res.id IN ( :resourceIds ) "), @NamedQuery(name="Resource.findByExplicitResourceGroup", query="SELECT DISTINCT res   FROM ResourceGroup rg JOIN rg.roles r JOIN r.subjects s JOIN rg.explicitResources res  WHERE rg = :group    AND s = :subject"), @NamedQuery(name="Resource.findByExplicitResourceGroup_admin", query="SELECT res   FROM ResourceGroup rg, IN (rg.explicitResources) res  WHERE rg = :group "), @NamedQuery(name="Resource.findByImplicitResourceGroup", query="SELECT DISTINCT res   FROM ResourceGroup rg JOIN rg.roles r JOIN r.subjects s JOIN rg.implicitResources res  WHERE rg = :group    AND s = :subject"), @NamedQuery(name="Resource.findByImplicitResourceGroup_admin", query="SELECT res   FROM ResourceGroup rg, IN (rg.implicitResources) res  WHERE rg = :group "), @NamedQuery(name="ResourceWithAvailability.findExplicitByResourceGroup", query="SELECT new org.rhq.core.domain.resource.composite.ResourceWithAvailability(res,  (SELECT parentRes FROM Resource parentRes WHERE parentRes = res.parentResource),  a.availabilityType,  1, (SELECT count(iir) FROM rg.implicitResources iir WHERE iir = res))   FROM ResourceGroup rg JOIN rg.explicitResources res LEFT JOIN res.parentResource parent   LEFT JOIN res.currentAvailability a  WHERE rg.id = :groupId    AND rg.id IN (SELECT irg.id FROM ResourceGroup irg JOIN irg.roles r JOIN r.subjects s WHERE s = :subject)    AND res.inventoryStatus = 'COMMITTED' "), @NamedQuery(name="ResourceWithAvailability.findExplicitByResourceGroup_admin", query="SELECT new org.rhq.core.domain.resource.composite.ResourceWithAvailability(res,  (SELECT parentRes FROM Resource parentRes WHERE parentRes = res.parentResource),  a.availabilityType, 1, (SELECT count(iir) FROM rg.implicitResources iir WHERE iir = res))   FROM ResourceGroup rg JOIN rg.explicitResources res LEFT JOIN res.parentResource parent   LEFT JOIN res.currentAvailability a  WHERE rg.id = :groupId    AND res.inventoryStatus = 'COMMITTED' "), @NamedQuery(name="ResourceWithAvailability.findImplicitByResourceGroup", query="SELECT new org.rhq.core.domain.resource.composite.ResourceWithAvailability(res,  (SELECT parentRes FROM Resource parentRes WHERE parentRes = res.parentResource),  a.availabilityType, (SELECT count(ier) FROM rg.explicitResources ier WHERE ier = res), 1)   FROM ResourceGroup rg JOIN rg.implicitResources res LEFT JOIN res.parentResource parent   LEFT JOIN res.currentAvailability a  WHERE rg.id = :groupId    AND rg.id IN (SELECT irg.id FROM ResourceGroup irg JOIN irg.roles r JOIN r.subjects s WHERE s = :subject)    AND res.inventoryStatus = 'COMMITTED' "), @NamedQuery(name="ResourceWithAvailability.findImplicitByResourceGroup_admin", query="SELECT new org.rhq.core.domain.resource.composite.ResourceWithAvailability(res,  (SELECT parentRes FROM Resource parentRes WHERE parentRes = res.parentResource),  a.availabilityType, (SELECT count(ier) FROM rg.explicitResources ier WHERE ier = res), 1)   FROM ResourceGroup rg JOIN rg.implicitResources res LEFT JOIN res.parentResource parent   LEFT JOIN res.currentAvailability a  WHERE rg.id = :groupId    AND res.inventoryStatus = 'COMMITTED' "), @NamedQuery(name="ResourceWithAvailability.findImplicitByResourceGroup_count", query="SELECT count(DISTINCT res)   FROM ResourceGroup rg JOIN rg.implicitResources res JOIN rg.roles r JOIN r.subjects s  WHERE rg.id = :groupId    AND res.inventoryStatus = 'COMMITTED'    AND s = :subject "), @NamedQuery(name="ResourceWithAvailability.findImplicitByResourceGroup_count_admin", query="SELECT count(res)   FROM ResourceGroup rg JOIN rg.implicitResources res  WHERE rg.id = :groupId    AND res.inventoryStatus = 'COMMITTED' "), @NamedQuery(name="ResourceWithAvailability.findExplicitByResourceGroup_count", query="SELECT count(DISTINCT res)   FROM ResourceGroup rg JOIN rg.explicitResources res JOIN rg.roles r JOIN r.subjects s  WHERE rg.id = :groupId    AND res.inventoryStatus = 'COMMITTED'    AND s = :subject "), @NamedQuery(name="ResourceWithAvailability.findExplicitByResourceGroup_count_admin", query="SELECT count(res)   FROM ResourceGroup rg JOIN rg.explicitResources res  WHERE rg.id = :groupId    AND res.inventoryStatus = 'COMMITTED' "), @NamedQuery(name="Resource.getAvailableResourcesForChannel", query="  SELECT res     FROM Resource AS res    WHERE res.id NOT IN        ( SELECT rc.resource.id            FROM ResourceChannel rc           WHERE rc.channel.id = :channelId )      AND (:category = res.resourceType.category OR :category IS NULL)      AND (res.inventoryStatus = :inventoryStatus)      AND (UPPER(res.name) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.getAvailableResourcesForResourceGroup", query="SELECT res   FROM Resource AS res  WHERE res.id NOT IN        ( SELECT ires.id            FROM Resource ires JOIN ires.explicitGroups AS irg           WHERE irg.id = :groupId )    AND (:type = res.resourceType OR :type IS NULL)    AND (:category = res.resourceType.category OR :category IS NULL)    AND (res.inventoryStatus = :inventoryStatus)    AND (UPPER(res.name) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.getAvailableResourcesForResourceGroupWithExcludes", query="SELECT res   FROM Resource AS res  WHERE res.id NOT IN        ( SELECT ires.id            FROM Resource ires JOIN ires.explicitGroups AS irg           WHERE irg.id = :groupId )    AND (:type = res.resourceType OR :type IS NULL)    AND (:category = res.resourceType.category OR :category IS NULL)    AND (res.inventoryStatus = :inventoryStatus)    AND (UPPER(res.name) LIKE :search OR :search is null)    AND res.id NOT IN ( :excludeIds ) "), @NamedQuery(name="Resource.getAvailableResourcesWithParentForResourceGroup", query="SELECT res   FROM Resource AS res   LEFT JOIN FETCH res.parentResource parent  WHERE res.id NOT IN        ( SELECT ires.id            FROM Resource ires JOIN ires.explicitGroups AS irg           WHERE irg.id = :groupId )    AND (:type = res.resourceType OR :type IS NULL)    AND (:category = res.resourceType.category OR :category IS NULL)    AND (res.inventoryStatus = :inventoryStatus)    AND (UPPER(res.name) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.getAvailableResourcesWithParentForResourceGroupWithExcludes", query="SELECT res   FROM Resource AS res   LEFT JOIN FETCH res.parentResource parent  WHERE res.id NOT IN        ( SELECT ires.id            FROM Resource ires JOIN ires.explicitGroups AS irg           WHERE irg.id = :groupId )    AND (:type = res.resourceType OR :type IS NULL)    AND (:category = res.resourceType.category OR :category IS NULL)    AND (res.inventoryStatus = :inventoryStatus)    AND (UPPER(res.name) LIKE :search OR :search is null)    AND res.id NOT IN ( :excludeIds ) "), @NamedQuery(name="Resource.getAvailableResourcesForDashboardPortlet", query="SELECT res   FROM Resource AS res  WHERE (:typeId = res.resourceType.id OR :typeId IS NULL)    AND (:category = res.resourceType.category OR :category IS NULL)    AND (res.inventoryStatus = :inventoryStatus) "), @NamedQuery(name="Resource.getAvailableResourcesForDashboardPortletWithExcludes", query="SELECT res   FROM Resource AS res  WHERE (:typeId = res.resourceType.id OR :typeId IS NULL)    AND (:category = res.resourceType.category OR :category IS NULL)    AND (res.inventoryStatus = :inventoryStatus)    AND res.id NOT IN ( :excludeIds ) "), @NamedQuery(name="Resource.findById", query="         SELECT res            FROM Resource res LEFT JOIN FETCH res.currentAvailability      JOIN FETCH res.resourceType           WHERE res.id =  :resourceId "), @NamedQuery(name="Resource.findByIds", query="         SELECT res            FROM Resource res LEFT JOIN FETCH res.currentAvailability      JOIN FETCH res.resourceType           WHERE res.id IN ( :ids )             AND res.id IN ( SELECT rr.id FROM Resource rr                               JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s                              WHERE s = :subject) "), @NamedQuery(name="Resource.findByIds_admin", query="         SELECT res            FROM Resource res LEFT JOIN FETCH res.currentAvailability      JOIN FETCH res.resourceType           WHERE res.id IN ( :ids )"), @NamedQuery(name="Resource.findWithParentByIds", query="         SELECT res            FROM Resource res LEFT JOIN FETCH res.currentAvailability      JOIN FETCH res.resourceType LEFT JOIN FETCH res.parentResource parent LEFT JOIN FETCH parent.currentAvailability LEFT JOIN FETCH parent.resourceType           WHERE res.id IN ( :ids )             AND res.id IN ( SELECT rr.id FROM Resource rr                               JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s                              WHERE s = :subject) "), @NamedQuery(name="Resource.findWithParentByIds_admin", query="         SELECT res            FROM Resource res LEFT JOIN FETCH res.currentAvailability      JOIN FETCH res.resourceType LEFT JOIN FETCH res.parentResource parent LEFT JOIN FETCH parent.currentAvailability LEFT JOIN FETCH parent.resourceType           WHERE res.id IN ( :ids )"), @NamedQuery(name="Resource.findComposite", query="SELECT new org.rhq.core.domain.resource.composite.ResourceComposite(res, a.availabilityType,  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 8),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 4),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 10),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 7),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 11),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 9),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 6),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 5)) FROM Resource res      LEFT JOIN res.currentAvailability a WHERE res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)  AND (:category = res.resourceType.category OR :category is null)   AND (:parentResource = res.parentResource OR :parentResource is null)  AND (:resourceTypeName = res.resourceType.name OR :resourceTypeName is null)   AND (:pluginName = res.resourceType.plugin OR :pluginName is null)   AND (res.inventoryStatus = :inventoryStatus OR :inventoryStatus is null)   AND (UPPER(res.name) LIKE :search OR UPPER(res.description) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.findCompositeWithParent", query="SELECT new org.rhq.core.domain.resource.composite.ResourceComposite(res,  (SELECT ires FROM Resource ires WHERE ires = res.parentResource),  a.availabilityType,  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 8),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 4),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 10),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 7),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 11),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 9),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 6),  (SELECT count(p) FROM res.implicitGroups g JOIN g.roles r JOIN r.subjects s JOIN r.permissions p WHERE s = :subject AND p = 5)) FROM Resource res      LEFT JOIN res.parentResource parent      LEFT JOIN res.currentAvailability a WHERE res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)  AND (:category = res.resourceType.category OR :category is null)   AND (:parentResource = res.parentResource OR :parentResource is null)  AND (:resourceTypeName = res.resourceType.name OR :resourceTypeName is null)   AND (:pluginName = res.resourceType.plugin OR :pluginName is null)   AND (res.inventoryStatus = :inventoryStatus OR :inventoryStatus is null)   AND (UPPER(res.name) LIKE :search OR UPPER(res.description) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.findComposite_count", query="SELECT count(res)   FROM Resource res  WHERE res.id IN (SELECT rr.id FROM Resource rr JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s WHERE s = :subject)   AND (:category = res.resourceType.category OR :category is null)    AND (:parentResource = res.parentResource OR :parentResource is null)   AND (:resourceTypeName = res.resourceType.name OR :resourceTypeName is null)    AND (:pluginName = res.resourceType.plugin OR :pluginName is null)    AND (res.inventoryStatus = :inventoryStatus OR :inventoryStatus is null)    AND (UPPER(res.name) LIKE :search OR UPPER(res.description) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.findComposite_admin", query="SELECT new org.rhq.core.domain.resource.composite.ResourceComposite(res, a.availabilityType)   FROM Resource res        LEFT JOIN res.currentAvailability a  WHERE (:category = res.resourceType.category OR :category is null)    AND (:parentResource = res.parentResource OR :parentResource is null)   AND (:resourceTypeName = res.resourceType.name OR :resourceTypeName is null)    AND (:pluginName = res.resourceType.plugin OR :pluginName is null)    AND (res.inventoryStatus = :inventoryStatus OR :inventoryStatus is null)    AND (UPPER(res.name) LIKE :search OR UPPER(res.description) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.findCompositeWithParent_admin", query="SELECT new org.rhq.core.domain.resource.composite.ResourceComposite( res,        (SELECT ires FROM Resource ires WHERE ires = res.parentResource),        a.availabilityType )   FROM Resource res        LEFT JOIN res.parentResource parent        LEFT JOIN res.currentAvailability a  WHERE (:category = res.resourceType.category OR :category is null)    AND (:parentResource = res.parentResource OR :parentResource is null)   AND (:resourceTypeName = res.resourceType.name OR :resourceTypeName is null)    AND (:pluginName = res.resourceType.plugin OR :pluginName is null)    AND (res.inventoryStatus = :inventoryStatus OR :inventoryStatus is null)    AND (UPPER(res.name) LIKE :search OR UPPER(res.description) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.findComposite_count_admin", query=" SELECT count(res)   FROM Resource res  WHERE (:category = res.resourceType.category OR :category is null)    AND (:parentResource = res.parentResource OR :parentResource is null)   AND (:resourceTypeName = res.resourceType.name OR :resourceTypeName is null)    AND (:pluginName = res.resourceType.plugin OR :pluginName is null)    AND (res.inventoryStatus = :inventoryStatus OR :inventoryStatus is null)    AND (UPPER(res.name) LIKE :search OR UPPER(res.description) LIKE :search OR :search is null) "), @NamedQuery(name="Resource.getStatusesByParent", query="SELECT r.id, r.inventoryStatus   FROM Resource r  WHERE r.parentResource.id = :parentResourceId"), @NamedQuery(name="Resource.getResourceHealthByIds", query="  SELECT new org.rhq.core.domain.resource.composite.ResourceHealthComposite(           res.id, res.name, res.resourceType.name, avail.availabilityType, COUNT(alert))     FROM Resource res          LEFT JOIN res.availability avail          LEFT JOIN res.alertDefinitions alertDef          LEFT JOIN alertDef.alerts alert    WHERE res.id IN (:resourceIds)      AND avail.endTime IS NULL GROUP BY res.id, res.name, res.resourceType.name, avail.availabilityType "), @NamedQuery(name="Resource.findByIdWithInstalledPackages", query="SELECT r FROM Resource AS r LEFT JOIN r.installedPackages ip WHERE r.id = :id"), @NamedQuery(name="Resource.findByIdWithInstalledPackageHist", query="SELECT r FROM Resource AS r LEFT JOIN r.installedPackageHistory ip WHERE r.id = :id"), @NamedQuery(name="Resource.findPlatformByAgent", query="SELECT res FROM Resource res WHERE res.resourceType.category = :category AND res.agent = :agent"), @NamedQuery(name="Resource.findParentId", query="SELECT res.parentResource.id FROM Resource AS res WHERE res.id = :id"), @NamedQuery(name="Resource.findRootPlatformOfResource", query="SELECT DISTINCT r FROM Resource r WHERE r.parentResource.id is null AND   (     r.id = :resourceId     OR EXISTS (SELECT rr FROM Resource rr WHERE rr.id = :resourceId AND rr.parentResource = r)     OR EXISTS (SELECT rr FROM Resource rr WHERE rr.id = :resourceId AND rr.parentResource.parentResource = r)     OR EXISTS (SELECT rr FROM Resource rr WHERE rr.id = :resourceId AND rr.parentResource.parentResource.parentResource = r)     OR EXISTS (SELECT rr FROM Resource rr WHERE rr.id = :resourceId AND rr.parentResource.parentResource.parentResource.parentResource = r)     OR EXISTS (SELECT rr FROM Resource rr WHERE rr.id = :resourceId AND rr.parentResource.parentResource.parentResource.parentResource.parentResource = r)     OR EXISTS (SELECT rr FROM Resource rr WHERE rr.id = :resourceId AND rr.parentResource.parentResource.parentResource.parentResource.parentResource.parentResource = r)   )"), @NamedQuery(name="Resource.findDescendents", query="SELECT r.id   FROM Resource r  WHERE r.id = :resourceId     OR r.id IN (SELECT rr.id FROM Resource rr WHERE rr.parentResource.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr WHERE rr.parentResource.parentResource.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr WHERE rr.parentResource.parentResource.parentResource.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr WHERE rr.parentResource.parentResource.parentResource.parentResource.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr WHERE rr.parentResource.parentResource.parentResource.parentResource.parentResource.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr WHERE rr.parentResource.parentResource.parentResource.parentResource.parentResource.parentResource.id = :resourceId)    "), @NamedQuery(name="Resource.markResourcesForAsyncDeletion", query="UPDATE Resource r    SET r.inventoryStatus = :status,        r.agent = NULL,        r.parentResource = NULL,        r.resourceKey = 'deleted'  WHERE r.id = :resourceId     OR r.id IN (SELECT rr.id FROM Resource rr JOIN rr.parentResource p1 WHERE p1.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr JOIN rr.parentResource.parentResource p2 WHERE p2.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr JOIN rr.parentResource.parentResource.parentResource p3 WHERE p3.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr JOIN rr.parentResource.parentResource.parentResource.parentResource p4 WHERE p4.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr JOIN rr.parentResource.parentResource.parentResource.parentResource.parentResource p5 WHERE p5.id = :resourceId)     OR r.id IN (SELECT rr.id FROM Resource rr JOIN rr.parentResource.parentResource.parentResource.parentResource.parentResource.parentResource p6 WHERE p6.id = :resourceId)    "), @NamedQuery(name="Resource.findResourcesMarkedForAsyncDeletion", query="SELECT r.id FROM Resource AS r WHERE r.agent IS NULL"), @NamedQuery(name="Resource.findResourceReport", query="SELECT new org.rhq.core.domain.resource.composite.ResourceInstallCount(  r.resourceType.name, r.resourceType.plugin, r.resourceType.category, r.resourceType.id, count(r))\n FROM Resource r\n GROUP BY r.resourceType.name, r.resourceType.plugin, r.resourceType.category, r.resourceType.id\n ORDER BY r.resourceType.category, r.resourceType.plugin, r.resourceType.name"), @NamedQuery(name="Resource.findResourceVersionReport", query="SELECT new org.rhq.core.domain.resource.composite.ResourceInstallCount( r.resourceType.name, r.resourceType.plugin, r.resourceType.category, r.resourceType.id, count(r), r.version)\n FROM Resource r\n GROUP BY r.resourceType.name, r.resourceType.plugin, r.resourceType.category, r.resourceType.id, r.version\n ORDER BY r.resourceType.category, r.resourceType.plugin, r.resourceType.name, r.version")})
@SequenceGenerator(name="RHQ_RESOURCE_SEQ", sequenceName="RHQ_RESOURCE_ID_SEQ")
@Table(name="RHQ_RESOURCE")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Resource
implements Comparable<Resource>,
Externalizable {
    public static final String QUERY_FIND_PROBLEM_RESOURCES_ALERT = "Resource.findProblemResourcesAlert";
    public static final String QUERY_FIND_PROBLEM_RESOURCES_ALERT_ADMIN = "Resource.findProblemResourcesAlert_admin";
    public static final String QUERY_FIND_PROBLEM_RESOURCES_ALERT_COUNT = "Resource.findProblemResourcesAlertCount";
    public static final String QUERY_FIND_PROBLEM_RESOURCES_ALERT_COUNT_ADMIN = "Resource.findProblemResourcesAlertCount_admin";
    public static final String QUERY_FIND_BY_PARENT_AND_TYPE = "Resource.findByParentAndType";
    public static final String QUERY_FIND_BY_PARENT_AND_TYPE_ADMIN = "Resource.findByParentAndType_admin";
    public static final String QUERY_FIND_FOR_AUTOGROUP = "Resource.findForAutogroup";
    public static final String QUERY_FIND_BY_PARENT_AND_INVENTORY_STATUS = "Resource.findByParentAndInventoryStatus";
    public static final String QUERY_FIND_BY_PARENT_AND_INVENTORY_STATUS_ADMIN = "Resource.findByParentAndInventoryStatus_admin";
    public static final String QUERY_FIND_VALID_COMMITTED_RESOURCE_IDS_ADMIN = "Resource.findValidCommittedResourceIds_admin";
    public static final String QUERY_FIND_CHILDREN_IDS_ADMIN = "Resource.findChildrenIds_admin";
    public static final String QUERY_FIND_CHILDREN_IDS_BY_PARENT_IDS = "Resource.findChildrenIdsByParentIds";
    public static final String QUERY_FIND_CHILDREN = "Resource.findChildren";
    public static final String QUERY_FIND_CHILDREN_ADMIN = "Resource.findChildren_admin";
    public static final String QUERY_RECENTLY_ADDED_PLATFORMS = "Resource.findRecentlyAddedPlatforms";
    public static final String QUERY_RECENTLY_ADDED_PLATFORMS_ADMIN = "Resource.findRecentlyAddedPlatforms_admin";
    public static final String QUERY_RECENTLY_ADDED_SERVERS = "Resource.findRecentlyAddedServers";
    public static final String QUERY_RECENTLY_ADDED_SERVERS_ADMIN = "Resource.findRecentlyAddedServers_admin";
    public static final String QUERY_FIND_AVAILABILITY_BY_RESOURCE_ID = "Resource.findAvailabilityByResourceId";
    public static final String QUERY_FIND_AVAILABILITY_BY_RESOURCE_ID_ADMIN = "Resource.findAvailabilityByResourceId_admin";
    public static final String QUERY_FIND_AVAILABILITY_BY_RESOURCE_IDS = "Resource.findAvailabilityByResourceIds";
    public static final String QUERY_FIND_AVAILABILITY_BY_RESOURCE_IDS_ADMIN = "Resource.findAvailabilityByResourceIds_admin";
    public static final String QUERY_FIND_RESOURCE_AUTOGROUP_COMPOSITE = "Resource.findResourceAutogroupComposite";
    public static final String QUERY_FIND_RESOURCE_AUTOGROUP_COMPOSITE_ADMIN = "Resource.findResourceAutogroupComposite_admin";
    public static final String QUERY_FIND_RESOURCE_AUTOGROUPS_COMPOSITE = "Resource.findResourceAutogroupsComposite";
    public static final String QUERY_FIND_RESOURCE_AUTOGROUPS_COMPOSITE_ADMIN = "Resource.findResourceAutogroupsComposite_admin";
    public static final String QUERY_FIND_CHILDREN_AUTOGROUP_COMPOSITES = "Resource.findChildrenAutogroupComposites";
    public static final String QUERY_FIND_CHILDREN_AUTOGROUP_COMPOSITES_ADMIN = "Resource.findChildrenAutogroupComposites_admin";
    public static final String QUERY_FIND_CHILDREN_AUTOGROUP_COMPOSITES_BY_TYPE = "Resource.findChildrenAutogroupCompositesByType";
    public static final String QUERY_FIND_CHILDREN_AUTOGROUP_COMPOSITES_BY_TYPE_ADMIN = "Resource.findChildrenAutogroupCompositesByType_admin";
    public static final String QUERY_FIND_CHILDREN_BY_CATEGORY_AND_INVENTORY_STATUS = "Resource.findChildrenByCategoryAndInventoryStatus";
    public static final String QUERY_FIND_CHILDREN_BY_CATEGORY_AND_INVENTORY_STATUS_ADMIN = "Resource.findChildrenByCategoryAndInventoryStatus_admin";
    public static final String QUERY_FIND_BY_CATEGORY_AND_INVENTORY_STATUS = "Resource.findByCategoryAndInventoryStatus";
    public static final String QUERY_FIND_BY_CATEGORY_AND_INVENTORY_STATUS_ADMIN = "Resource.findByCategoryAndInventoryStatus_admin";
    public static final String QUERY_FIND_QUEUED_PLATFORMS_BY_INVENTORY_STATUS = "Resource.findQueuedPlatformsByInventoryStatus";
    public static final String QUERY_FIND_BY_TYPE = "Resource.findByType";
    public static final String QUERY_FIND_BY_TYPE_ADMIN = "Resource.findByType_admin";
    public static final String QUERY_FIND_BY_TYPE_AND_IDS = "Resource.findByTypeAndIds";
    public static final String QUERY_FIND_BY_TYPE_AND_IDS_ADMIN = "Resource.findByTypeAndIds_admin";
    public static final String QUERY_FIND_BY_PARENT_AND_KEY = "Resource.findByParentAndKey";
    public static final String QUERY_FIND_EXPLICIT_IDS_BY_RESOURCE_GROUP_ADMIN = "Resource.findExplicitIdsByResourceGroup_admin";
    public static final String QUERY_FIND_IMPLICIT_IDS_BY_RESOURCE_GROUP_ADMIN = "Resource.findImplicitIdsByResourceGroup_admin";
    public static final String QUERY_FIND_FLY_WEIGHTS_BY_RESOURCE_IDS = "Resource.findFlyWeights";
    public static final String QUERY_FIND_BY_EXPLICIT_RESOURCE_GROUP = "Resource.findByExplicitResourceGroup";
    public static final String QUERY_FIND_BY_EXPLICIT_RESOURCE_GROUP_ADMIN = "Resource.findByExplicitResourceGroup_admin";
    public static final String QUERY_FIND_BY_IMPLICIT_RESOURCE_GROUP = "Resource.findByImplicitResourceGroup";
    public static final String QUERY_FIND_BY_IMPLICIT_RESOURCE_GROUP_ADMIN = "Resource.findByImplicitResourceGroup_admin";
    public static final String QUERY_FIND_EXPLICIT_RESOURCES_WITH_AVAILABILITY_FOR_RESOURCE_GROUP = "ResourceWithAvailability.findExplicitByResourceGroup";
    public static final String QUERY_FIND_EXPLICIT_RESOURCES_WITH_AVAILABILITY_FOR_RESOURCE_GROUP_ADMIN = "ResourceWithAvailability.findExplicitByResourceGroup_admin";
    public static final String QUERY_FIND_IMPLICIT_RESOURCES_WITH_AVAILABILITY_FOR_RESOURCE_GROUP = "ResourceWithAvailability.findImplicitByResourceGroup";
    public static final String QUERY_FIND_IMPLICIT_RESOURCES_WITH_AVAILABILITY_FOR_RESOURCE_GROUP_ADMIN = "ResourceWithAvailability.findImplicitByResourceGroup_admin";
    public static final String QUERY_FIND_IMPLICIT_RESOURCES_FOR_RESOURCE_GROUP_COUNT = "ResourceWithAvailability.findImplicitByResourceGroup_count";
    public static final String QUERY_FIND_IMPLICIT_RESOURCES_FOR_RESOURCE_GROUP_COUNT_ADMIN = "ResourceWithAvailability.findImplicitByResourceGroup_count_admin";
    public static final String QUERY_FIND_EXPLICIT_RESOURCES_FOR_RESOURCE_GROUP_COUNT = "ResourceWithAvailability.findExplicitByResourceGroup_count";
    public static final String QUERY_FIND_EXPLICIT_RESOURCES_FOR_RESOURCE_GROUP_COUNT_ADMIN = "ResourceWithAvailability.findExplicitByResourceGroup_count_admin";
    public static final String QUERY_GET_AVAILABLE_RESOURCES_FOR_CHANNEL = "Resource.getAvailableResourcesForChannel";
    public static final String QUERY_GET_AVAILABLE_RESOURCES_FOR_RESOURCE_GROUP = "Resource.getAvailableResourcesForResourceGroup";
    public static final String QUERY_GET_AVAILABLE_RESOURCES_FOR_RESOURCE_GROUP_WITH_EXCLUDES = "Resource.getAvailableResourcesForResourceGroupWithExcludes";
    public static final String QUERY_GET_AVAILABLE_RESOURCES_WITH_PARENT_FOR_RESOURCE_GROUP = "Resource.getAvailableResourcesWithParentForResourceGroup";
    public static final String QUERY_GET_AVAILABLE_RESOURCES_WITH_PARENT_FOR_RESOURCE_GROUP_WITH_EXCLUDES = "Resource.getAvailableResourcesWithParentForResourceGroupWithExcludes";
    public static final String QUERY_GET_AVAILABLE_RESOURCES_FOR_DASHBOARD_PORTLET = "Resource.getAvailableResourcesForDashboardPortlet";
    public static final String QUERY_GET_AVAILABLE_RESOURCES_FOR_DASHBOARD_PORTLET_WITH_EXCLUDES = "Resource.getAvailableResourcesForDashboardPortletWithExcludes";
    public static final String QUERY_FIND_BY_ID = "Resource.findById";
    public static final String QUERY_FIND_BY_IDS = "Resource.findByIds";
    public static final String QUERY_FIND_BY_IDS_ADMIN = "Resource.findByIds_admin";
    public static final String QUERY_FIND_WITH_PARENT_BY_IDS = "Resource.findWithParentByIds";
    public static final String QUERY_FIND_WITH_PARENT_BY_IDS_ADMIN = "Resource.findWithParentByIds_admin";
    public static final String QUERY_FIND_COMPOSITE = "Resource.findComposite";
    public static final String QUERY_FIND_COMPOSITE_WITH_PARENT = "Resource.findCompositeWithParent";
    public static final String QUERY_FIND_COMPOSITE_COUNT = "Resource.findComposite_count";
    public static final String QUERY_FIND_COMPOSITE_ADMIN = "Resource.findComposite_admin";
    public static final String QUERY_FIND_COMPOSITE_WITH_PARENT_ADMIN = "Resource.findCompositeWithParent_admin";
    public static final String QUERY_FIND_COMPOSITE_COUNT_ADMIN = "Resource.findComposite_count_admin";
    public static final String QUERY_GET_STATUSES_BY_PARENT = "Resource.getStatusesByParent";
    public static final String QUERY_GET_RESOURCE_HEALTH_BY_IDS = "Resource.getResourceHealthByIds";
    public static final String QUERY_FIND_BY_ID_WITH_INSTALLED_PACKAGES = "Resource.findByIdWithInstalledPackages";
    public static final String QUERY_FIND_BY_ID_WITH_INSTALLED_PACKAGE_HIST = "Resource.findByIdWithInstalledPackageHist";
    public static final String QUERY_FIND_PLATFORM_BY_AGENT = "Resource.findPlatformByAgent";
    public static final String QUERY_FIND_PAREBT_ID = "Resource.findParentId";
    public static final String QUERY_FIND_ROOT_PLATFORM_OF_RESOURCE = "Resource.findRootPlatformOfResource";
    public static final String QUERY_FIND_DESCENDENTS = "Resource.findDescendents";
    public static final String QUERY_MARK_RESOURCES_FOR_ASYNC_DELETION = "Resource.markResourcesForAsyncDeletion";
    public static final String QUERY_FIND_RESOURCES_MARKED_FOR_ASYNC_DELETION = "Resource.findResourcesMarkedForAsyncDeletion";
    public static final String QUERY_RESOURCE_REPORT = "Resource.findResourceReport";
    public static final String QUERY_RESOURCE_VERSION_REPORT = "Resource.findResourceVersionReport";
    private static final long serialVersionUID = 1L;
    public static final Resource ROOT = null;
    public static final int ROOT_ID = -1;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_RESOURCE_SEQ")
    @Id
    @Summary(index=0)
    private int id;
    @Column(name="UUID")
    private String uuid = UUID.randomUUID().toString();
    @Column(name="RESOURCE_KEY")
    private String resourceKey;
    @Column(name="NAME", nullable=false)
    @Summary(index=1)
    private String name;
    @Column(name="INVENTORY_STATUS")
    @Enumerated(value=EnumType.STRING)
    private InventoryStatus inventoryStatus = InventoryStatus.NEW;
    @Column(name="CONNECTED")
    private boolean connected;
    @Column(name="VERSION")
    @Summary(index=2)
    private String version;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CTIME")
    private Long ctime = System.currentTimeMillis();
    @Column(name="MTIME")
    private Long mtime = System.currentTimeMillis();
    @Column(name="ITIME")
    private Long itime = System.currentTimeMillis();
    @JoinColumn(name="MODIFIED_BY")
    @ManyToOne(fetch=FetchType.LAZY)
    private Subject modifiedBy;
    @Column(name="LOCATION")
    private String location;
    @JoinColumn(name="RESOURCE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    @Summary(index=4)
    private ResourceType resourceType;
    @OneToMany(mappedBy="parentResource", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @OrderBy
    private Set<Resource> childResources = new LinkedHashSet<Resource>();
    @JoinColumn(name="PARENT_RESOURCE_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    @XmlTransient
    private Resource parentResource;
    @JoinColumn(name="RES_CONFIGURATION_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration resourceConfiguration = new Configuration();
    @JoinColumn(name="PLUGIN_CONFIGURATION_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration pluginConfiguration = new Configuration();
    @JoinColumn(name="AGENT_ID", referencedColumnName="ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private Agent agent;
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlertDefinition> alertDefinitions = new LinkedHashSet<AlertDefinition>();
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @OrderBy
    private List<ResourceConfigurationUpdate> resourceConfigurationUpdates = new ArrayList<ResourceConfigurationUpdate>();
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @OrderBy
    private List<PluginConfigurationUpdate> pluginConfigurationUpdates = new ArrayList<PluginConfigurationUpdate>();
    @ManyToMany(mappedBy="implicitResources", fetch=FetchType.LAZY)
    private Set<ResourceGroup> implicitGroups = new HashSet<ResourceGroup>();
    @ManyToMany(mappedBy="explicitResources", fetch=FetchType.LAZY)
    private Set<ResourceGroup> explicitGroups = new HashSet<ResourceGroup>();
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @OrderBy
    private List<ContentServiceRequest> contentServiceRequests = new ArrayList<ContentServiceRequest>();
    @OneToMany(mappedBy="parentResource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @OrderBy
    private List<CreateResourceHistory> createChildResourceRequests = new ArrayList<CreateResourceHistory>();
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @OrderBy
    private List<DeleteResourceHistory> deleteResourceRequests = new ArrayList<DeleteResourceHistory>();
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @OrderBy
    private List<ResourceOperationHistory> operationHistories = new ArrayList<ResourceOperationHistory>();
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    private Set<InstalledPackage> installedPackages = new HashSet<InstalledPackage>();
    @OneToMany(mappedBy="resource", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    private List<InstalledPackageHistory> installedPackageHistory = new ArrayList<InstalledPackageHistory>();
    @OneToMany(mappedBy="resource", fetch=FetchType.LAZY)
    private Set<ResourceChannel> resourceChannels = new HashSet<ResourceChannel>();
    @OneToMany(mappedBy="resource")
    private Set<MeasurementSchedule> schedules = new LinkedHashSet<MeasurementSchedule>();
    @OneToMany(mappedBy="resource")
    @OrderBy(value="startTime")
    private List<Availability> availability;
    @OneToOne(mappedBy="resource", cascade={CascadeType.PERSIST, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @Summary(index=3)
    private ResourceAvailability currentAvailability;
    @OneToMany(mappedBy="resource", fetch=FetchType.LAZY)
    private List<ResourceError> resourceErrors = new ArrayList<ResourceError>();
    @OneToMany(mappedBy="resource", fetch=FetchType.LAZY)
    private Set<EventSource> eventSources = new HashSet<EventSource>();
    @JoinColumn(name="PRODUCT_VERSION_ID", referencedColumnName="ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private ProductVersion productVersion;

    public Resource() {
        this.uuid = UUID.randomUUID().toString();
    }

    public Resource(int id) {
        this.id = id;
    }

    public Resource(@NotNull String resourceKey, @NotNull String name, @NotNull ResourceType type) {
        this.resourceKey = resourceKey;
        this.name = name;
        this.resourceType = type;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.setAgentSynchronizationNeeded();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
        this.setAgentSynchronizationNeeded();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
        this.setAgentSynchronizationNeeded();
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        this.setAgentSynchronizationNeeded();
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.setAgentSynchronizationNeeded();
    }

    public InventoryStatus getInventoryStatus() {
        return this.inventoryStatus;
    }

    public void setInventoryStatus(InventoryStatus inventoryStatus) {
        this.inventoryStatus = inventoryStatus;
        this.setAgentSynchronizationNeeded();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setAgentSynchronizationNeeded();
    }

    public long getCtime() {
        return this.ctime;
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = Long.valueOf(System.currentTimeMillis());
    }

    @PostPersist
    void afterPersist() {
        this.initCurrentAvailability();
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public long getItime() {
        return this.itime;
    }

    public void setItime(long inventoryTime) {
        this.itime = inventoryTime;
    }

    public void setAgentSynchronizationNeeded() {
        this.mtime = System.currentTimeMillis();
    }

    public Subject getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Subject modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.setAgentSynchronizationNeeded();
    }

    public Set<Resource> getChildResources() {
        return this.childResources;
    }

    public void addChildResource(Resource childResource) {
        childResource.setParentResource(this);
        this.childResources.add(childResource);
    }

    public boolean removeChildResource(Resource childResource) {
        return this.childResources.remove(childResource);
    }

    public void setChildResources(Set<Resource> children) {
        if (children == null) {
            children = new LinkedHashSet<Resource>();
        }
        this.childResources = children;
    }

    @Nullable
    public Resource getParentResource() {
        return this.parentResource;
    }

    public void setParentResource(@Nullable Resource parentResource) {
        this.parentResource = parentResource;
    }

    public Configuration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public void setResourceConfiguration(Configuration resourceConfiguration) {
        this.resourceConfiguration = resourceConfiguration;
    }

    public Configuration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(Configuration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public List<ResourceConfigurationUpdate> getResourceConfigurationUpdates() {
        return this.resourceConfigurationUpdates;
    }

    public void setResourceConfigurationUpdates(List<ResourceConfigurationUpdate> updates) {
        this.resourceConfigurationUpdates = updates;
    }

    public void addResourceConfigurationUpdates(ResourceConfigurationUpdate update) {
        update.setResource(this);
        this.resourceConfigurationUpdates.add(update);
    }

    public List<PluginConfigurationUpdate> getPluginConfigurationUpdates() {
        return this.pluginConfigurationUpdates;
    }

    public void setPluginConfigurationUpdates(List<PluginConfigurationUpdate> updates) {
        this.pluginConfigurationUpdates = updates;
    }

    public void addPluginConfigurationUpdates(PluginConfigurationUpdate update) {
        update.setResource(this);
        this.pluginConfigurationUpdates.add(update);
    }

    public Set<MeasurementSchedule> getSchedules() {
        return this.schedules;
    }

    public void setSchendules(Set<MeasurementSchedule> schedules) {
        this.schedules = schedules;
    }

    public void addSchedule(MeasurementSchedule schedule) {
        this.schedules.add(schedule);
    }

    public Set<AlertDefinition> getAlertDefinitions() {
        if (this.alertDefinitions == null) {
            this.alertDefinitions = new LinkedHashSet<AlertDefinition>();
        }
        return this.alertDefinitions;
    }

    public void setAlertDefinitions(Set<AlertDefinition> alertDefinitions) {
        this.alertDefinitions = alertDefinitions;
    }

    public void addAlertDefinition(AlertDefinition alertDefinition) {
        this.getAlertDefinitions().add(alertDefinition);
        alertDefinition.setResource(this);
    }

    public List<ContentServiceRequest> getContentServiceRequests() {
        return this.contentServiceRequests;
    }

    public void setContentServiceRequests(List<ContentServiceRequest> contentServiceRequests) {
        this.contentServiceRequests = contentServiceRequests;
    }

    public void addContentServiceRequest(ContentServiceRequest request) {
        request.setResource(this);
        this.contentServiceRequests.add(request);
    }

    public List<CreateResourceHistory> getCreateChildResourceRequests() {
        return this.createChildResourceRequests;
    }

    public void setCreateChildResourceRequests(List<CreateResourceHistory> createChildResourceRequests) {
        this.createChildResourceRequests = createChildResourceRequests;
    }

    public void addCreateChildResourceHistory(CreateResourceHistory request) {
        request.setParentResource(this);
        this.createChildResourceRequests.add(request);
    }

    public List<DeleteResourceHistory> getDeleteResourceRequests() {
        return this.deleteResourceRequests;
    }

    public void setDeleteResourceRequests(List<DeleteResourceHistory> deleteResourceRequests) {
        this.deleteResourceRequests = deleteResourceRequests;
    }

    public void addDeleteResourceHistory(DeleteResourceHistory history) {
        history.setResource(this);
        this.deleteResourceRequests.add(history);
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public Set<ResourceGroup> getImplicitGroups() {
        return this.implicitGroups;
    }

    public void setImplicitGroups(Set<ResourceGroup> implicitGroups) {
        this.implicitGroups = implicitGroups;
    }

    public void addImplicitGroup(ResourceGroup implicitGroup) {
        this.implicitGroups.add(implicitGroup);
    }

    public void removeImplicitGroup(ResourceGroup implicitGroup) {
        this.implicitGroups.remove(implicitGroup);
    }

    public Set<ResourceGroup> getExplicitGroups() {
        return this.explicitGroups;
    }

    public void setExplicitGroups(Set<ResourceGroup> explicitGroups) {
        this.explicitGroups = explicitGroups;
    }

    public void addExplicitGroup(ResourceGroup explicitGroup) {
        this.explicitGroups.add(explicitGroup);
    }

    public void removeExplicitGroup(ResourceGroup explicitGroup) {
        this.explicitGroups.remove(explicitGroup);
    }

    @NotNull
    public List<ResourceOperationHistory> getOperationHistories() {
        if (this.operationHistories == null) {
            this.operationHistories = new ArrayList<ResourceOperationHistory>();
        }
        return this.operationHistories;
    }

    public void setOperationHistories(List<ResourceOperationHistory> operationHistories) {
        this.operationHistories = operationHistories;
    }

    public List<ResourceError> getResourceErrors() {
        return this.resourceErrors;
    }

    public List<ResourceError> getResourceErrors(ResourceErrorType type) {
        ArrayList<ResourceError> errors = new ArrayList<ResourceError>();
        for (ResourceError error : this.resourceErrors) {
            if (error.getErrorType() != type) continue;
            errors.add(error);
        }
        return errors;
    }

    public void setResourceErrors(List<ResourceError> resourceErrors) {
        if (resourceErrors == null) {
            resourceErrors = new ArrayList<ResourceError>();
        }
        this.resourceErrors = resourceErrors;
    }

    public void addResourceError(ResourceError resourceError) {
        resourceError.setResource(this);
        this.resourceErrors.add(resourceError);
    }

    public List<Availability> getAvailability() {
        return this.availability;
    }

    public ResourceAvailability getCurrentAvailability() {
        return this.currentAvailability;
    }

    public void setCurrentAvailability(ResourceAvailability currentAvailability) {
        this.currentAvailability = currentAvailability;
    }

    public Set<ResourceChannel> getResourceChannels() {
        return this.resourceChannels;
    }

    public Set<Channel> getChannels() {
        HashSet<Channel> channels = new HashSet<Channel>();
        if (this.resourceChannels != null) {
            for (ResourceChannel rc : this.resourceChannels) {
                channels.add(rc.getResourceChannelPK().getChannel());
            }
        }
        return channels;
    }

    public ResourceChannel addChannel(Channel channel) {
        if (this.resourceChannels == null) {
            this.resourceChannels = new HashSet<ResourceChannel>();
        }
        ResourceChannel mapping = new ResourceChannel(this, channel);
        this.resourceChannels.add(mapping);
        channel.addResource(this);
        return mapping;
    }

    public ResourceChannel removeChannel(Channel channel) {
        if (this.resourceChannels == null || channel == null) {
            return null;
        }
        ResourceChannel doomed = null;
        for (ResourceChannel rc : this.resourceChannels) {
            if (!channel.equals(rc.getResourceChannelPK().getChannel())) continue;
            doomed = rc;
            channel.removeResource(this);
            break;
        }
        if (doomed != null) {
            this.resourceChannels.remove(doomed);
        }
        return doomed;
    }

    public Set<InstalledPackage> getInstalledPackages() {
        return this.installedPackages;
    }

    public void addInstalledPackage(InstalledPackage installedPackage) {
        if (this.installedPackages == null) {
            this.installedPackages = new LinkedHashSet<InstalledPackage>();
        }
        this.installedPackages.add(installedPackage);
        installedPackage.setResource(this);
    }

    public void setInstalledPackages(Set<InstalledPackage> installedPackages) {
        this.installedPackages = installedPackages;
    }

    public List<InstalledPackageHistory> getInstalledPackageHistory() {
        return this.installedPackageHistory;
    }

    public void addInstalledPackageHistory(InstalledPackageHistory history) {
        if (this.installedPackageHistory == null) {
            this.installedPackageHistory = new ArrayList<InstalledPackageHistory>(1);
        }
        this.installedPackageHistory.add(history);
        history.setResource(this);
    }

    public void setInstalledPackageHistory(List<InstalledPackageHistory> installedPackageHistory) {
        this.installedPackageHistory = installedPackageHistory;
    }

    public Set<EventSource> getEventSources() {
        return this.eventSources;
    }

    public ProductVersion getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(ProductVersion productVersion) {
        this.productVersion = productVersion;
    }

    @Override
    public int compareTo(Resource that) {
        return this.name.compareTo(that.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)o;
        return !(this.uuid != null ? !this.uuid.equals(resource.uuid) : resource.uuid != null);
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public String toString() {
        String parentName;
        StringBuilder buffer = new StringBuilder();
        buffer.append(Resource.class.getSimpleName()).append("[");
        buffer.append("id=").append(this.id);
        String typeName = this.resourceType != null ? this.resourceType.getName() : "<null>";
        buffer.append(", type=").append(typeName);
        buffer.append(", key=").append(this.resourceKey);
        buffer.append(", name=").append(this.name);
        try {
            parentName = this.parentResource != null ? this.parentResource.getName() : "<null>";
        }
        catch (RuntimeException e) {
            parentName = null;
        }
        if (parentName != null) {
            buffer.append(", parent=").append(parentName);
        }
        if (this.version != null && !this.version.equals("")) {
            buffer.append(", version=").append(this.version);
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableStrategy.Subsystem strategy = ExternalizableStrategy.getStrategy();
        out.writeChar(strategy.id());
        if (ExternalizableStrategy.Subsystem.REMOTEAPI == strategy) {
            this.writeExternalRemote(out);
        } else if (ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION == strategy) {
            EntitySerializer.writeExternalRemote(this, out);
        } else {
            this.writeExternalAgent(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        char c = in.readChar();
        if (ExternalizableStrategy.Subsystem.REMOTEAPI.id() == c) {
            this.readExternalRemote(in);
        } else if (ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION.id() == c) {
            EntitySerializer.readExternalRemote(this, in);
        } else {
            this.readExternalAgent(in);
        }
    }

    public void writeExternalAgent(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.uuid);
        out.writeUTF(null == this.resourceKey ? "" : this.resourceKey);
        out.writeUTF(null == this.name ? "" : this.name);
        out.writeInt(this.inventoryStatus.ordinal());
        out.writeUTF(null == this.version ? "" : this.version);
        out.writeUTF(null == this.description ? "" : this.description);
        out.writeLong(this.ctime);
        out.writeLong(this.mtime);
        out.writeLong(this.itime);
        out.writeObject(this.parentResource);
        if (null == this.resourceType) {
            out.writeUTF("");
            out.writeUTF("");
            out.writeObject(null);
        } else {
            out.writeUTF(this.resourceType.getName());
            out.writeUTF(this.resourceType.getPlugin());
            out.writeObject((Object)this.resourceType.getCategory());
        }
        out.writeObject(new LinkedHashSet<Resource>(this.childResources));
        if (this.pluginConfiguration != null && this.pluginConfiguration.getClass().getName().contains("hibernate")) {
            out.writeObject(null);
        } else {
            out.writeObject(this.pluginConfiguration);
        }
    }

    public void readExternalAgent(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.uuid = in.readUTF();
        this.resourceKey = in.readUTF();
        this.name = in.readUTF();
        this.inventoryStatus = InventoryStatus.values()[in.readInt()];
        this.version = in.readUTF();
        this.description = in.readUTF();
        this.ctime = in.readLong();
        this.mtime = in.readLong();
        this.itime = in.readLong();
        this.parentResource = (Resource)in.readObject();
        this.resourceType = new ResourceType(in.readUTF(), in.readUTF(), (ResourceCategory)((Object)in.readObject()), this.parentResource != null ? this.parentResource.getResourceType() : null);
        this.childResources = (Set)in.readObject();
        this.pluginConfiguration = (Configuration)in.readObject();
    }

    public void writeExternalRemote(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.uuid);
        out.writeUTF(this.resourceKey);
        out.writeUTF(this.name);
        out.writeInt(this.inventoryStatus.ordinal());
        out.writeUTF(null == this.version ? "" : this.version);
        out.writeUTF(null == this.description ? "" : this.description);
        out.writeLong(this.ctime);
        out.writeLong(this.mtime);
        out.writeLong(this.itime);
        out.writeUTF(null == this.location ? "" : this.location);
        out.writeObject(this.resourceType);
        out.writeObject(null == this.childResources ? null : new LinkedHashSet<Resource>(this.childResources));
        out.writeObject(this.parentResource);
        out.writeObject(this.resourceConfiguration);
        out.writeObject(this.pluginConfiguration);
        out.writeObject(this.agent);
        out.writeObject(null == this.implicitGroups ? null : new LinkedHashSet<ResourceGroup>(this.implicitGroups));
        out.writeObject(null == this.explicitGroups ? null : new LinkedHashSet<ResourceGroup>(this.explicitGroups));
        out.writeObject(this.availability);
        out.writeObject(this.currentAvailability);
        out.writeObject(this.resourceErrors);
        out.writeObject(this.productVersion);
    }

    public void readExternalRemote(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.uuid = in.readUTF();
        this.resourceKey = in.readUTF();
        this.name = in.readUTF();
        this.inventoryStatus = InventoryStatus.values()[in.readInt()];
        this.version = in.readUTF();
        this.description = in.readUTF();
        this.ctime = in.readLong();
        this.mtime = in.readLong();
        this.itime = in.readLong();
        this.location = in.readUTF();
        this.resourceType = (ResourceType)in.readObject();
        this.childResources = (Set)in.readObject();
        this.parentResource = (Resource)in.readObject();
        this.resourceConfiguration = (Configuration)in.readObject();
        this.pluginConfiguration = (Configuration)in.readObject();
        this.agent = (Agent)in.readObject();
        this.implicitGroups = (Set)in.readObject();
        this.explicitGroups = (Set)in.readObject();
        this.availability = (List)in.readObject();
        this.currentAvailability = (ResourceAvailability)in.readObject();
        this.resourceErrors = (List)in.readObject();
        this.productVersion = (ProductVersion)in.readObject();
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.parentResource = (Resource)parent;
    }

    public void initCurrentAvailability() {
        this.currentAvailability = new ResourceAvailability(this, null);
    }
}

