/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.PersistenceUtility;

public final class CriteriaQueryGenerator {
    private static final Log LOG = LogFactory.getLog(CriteriaQueryGenerator.class);
    private Criteria criteria;
    private String authorizationJoinFragment;
    private int authorizationSubjectId;
    private String alias;
    private String className;
    private static String NL = System.getProperty("line.separator");

    public CriteriaQueryGenerator(Criteria criteria) {
        this.criteria = criteria;
        String criteriaClassName = criteria.getClass().getSimpleName();
        this.className = criteriaClassName.substring(0, criteriaClassName.length() - 8);
        StringBuilder aliasBuilder = new StringBuilder();
        for (char c : this.className.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            aliasBuilder.append(Character.toLowerCase(c));
        }
        this.alias = aliasBuilder.toString();
    }

    public void setAuthorizationResourceFragment(AuthorizationTokenType type, int subjectId) {
        String defaultFragment = null;
        if (type == AuthorizationTokenType.RESOURCE) {
            defaultFragment = "resource";
        } else if (type == AuthorizationTokenType.GROUP) {
            defaultFragment = "group";
        }
        this.setAuthorizationResourceFragment(type, defaultFragment, subjectId);
    }

    private String fixFilterOverride(String expression, String fieldName) {
        boolean wantCaseInsensitiveMatch;
        boolean fuzzyMatch = expression.toLowerCase().indexOf(" like ") != -1;
        boolean bl = wantCaseInsensitiveMatch = !this.criteria.isCaseSensitive() && fuzzyMatch;
        while (expression.indexOf(63) != -1) {
            String replacement = ":" + fieldName;
            expression = expression.replaceFirst("\\?", replacement);
        }
        if (wantCaseInsensitiveMatch) {
            int indexOfFirstSpace = expression.indexOf(" ");
            String filterToken = expression.substring(0, indexOfFirstSpace);
            expression = "LOWER( " + this.alias + "." + filterToken + " ) " + expression.substring(indexOfFirstSpace);
        } else {
            expression = this.alias + "." + expression;
        }
        if (fuzzyMatch) {
            expression = expression + " ESCAPE '\\\\'";
        }
        return expression;
    }

    public void setAuthorizationResourceFragment(AuthorizationTokenType type, String fragment, int subjectId) {
        this.authorizationSubjectId = subjectId;
        if (type == AuthorizationTokenType.RESOURCE) {
            this.authorizationJoinFragment = fragment == null ? "JOIN " + this.alias + ".implicitGroups authGroup " + NL + "JOIN authGroup.roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL : "JOIN " + this.alias + "." + fragment + " authRes " + NL + "JOIN authRes.implicitGroups authGroup " + NL + "JOIN authGroup.roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL;
        } else if (type == AuthorizationTokenType.GROUP) {
            this.authorizationJoinFragment = fragment == null ? "JOIN " + this.alias + ".roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL : "JOIN " + this.alias + "." + fragment + " authGroup " + NL + "JOIN authGroup.roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL;
        } else {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not yet support generating queries for '" + (Object)((Object)type) + "' token types");
        }
    }

    public String getQueryString(boolean countQuery) {
        Map<String, Object> filterFields;
        StringBuilder results = new StringBuilder();
        results.append("SELECT ");
        if (countQuery) {
            results.append("COUNT(").append(this.alias).append(")").append(NL);
        } else {
            results.append(this.alias).append(NL);
        }
        results.append("FROM ").append(this.className).append(' ').append(this.alias).append(NL);
        if (!countQuery) {
            for (String fetchJoin : this.criteria.getFetchFields()) {
                results.append("LEFT JOIN FETCH ").append(this.alias).append('.').append(fetchJoin).append(NL);
            }
        }
        if (this.authorizationJoinFragment != null) {
            results.append(this.authorizationJoinFragment);
        }
        if ((filterFields = this.criteria.getFilterFields()).size() > 0 || this.authorizationJoinFragment != null) {
            results.append("WHERE ");
        }
        String conjunctiveFragment = this.criteria.isFiltersOptional() ? "OR " : "AND ";
        boolean wantCaseInsensitiveMatch = !this.criteria.isCaseSensitive();
        StringBuilder conjunctiveResults = new StringBuilder();
        boolean firstCrit = true;
        for (Map.Entry<String, Object> filterField : filterFields.entrySet()) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                conjunctiveResults.append(NL).append(conjunctiveFragment);
            }
            String fieldName = filterField.getKey();
            String override = this.criteria.getJPQLFilterOverride(fieldName);
            String fragment = null;
            if (override != null) {
                fragment = this.fixFilterOverride(override, fieldName);
            } else {
                String operator = "=";
                if (filterField.getValue() instanceof String) {
                    operator = "like";
                    fragment = wantCaseInsensitiveMatch ? "LOWER( " + this.alias + "." + fieldName + " ) " + operator + " :" + fieldName : this.alias + "." + fieldName + " " + operator + " :" + fieldName;
                    fragment = fragment + " ESCAPE '\\\\'";
                } else {
                    fragment = this.alias + "." + fieldName + " " + operator + " :" + fieldName;
                }
            }
            conjunctiveResults.append(fragment).append(' ');
        }
        if (conjunctiveResults.length() > 0) {
            results.append("( ").append((CharSequence)conjunctiveResults).append(")");
        }
        if (this.authorizationJoinFragment != null) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                results.append(NL).append(" AND ");
            }
            results.append("authSubject.id = " + this.authorizationSubjectId + " ");
        }
        if (!countQuery) {
            boolean first = true;
            for (OrderingField orderingField : this.criteria.getPageControl().getOrderingFields()) {
                if (first) {
                    results.append(NL).append("ORDER BY ");
                    first = false;
                } else {
                    results.append(", ");
                }
                String fieldName = orderingField.getField();
                String override = this.criteria.getJPQLSortOverride(fieldName);
                String fragment = override != null ? override : fieldName;
                results.append(this.alias).append('.').append(fragment);
                results.append(' ').append((Object)orderingField.getOrdering());
            }
        }
        results.append(NL);
        LOG.debug((Object)results);
        System.out.println(results);
        return results.toString();
    }

    public Query getQuery(EntityManager em) {
        String queryString = this.getQueryString(false);
        Query query = em.createQuery(queryString);
        this.setBindValues(query, false);
        PersistenceUtility.setDataPage(query, this.criteria.getPageControl());
        return query;
    }

    public Query getCountQuery(EntityManager em) {
        String countQueryString = this.getQueryString(true);
        Query query = em.createQuery(countQueryString);
        this.setBindValues(query, false);
        return query;
    }

    private void setBindValues(Query query, boolean countQuery) {
        boolean wantCaseInsensitiveMatch = !this.criteria.isCaseSensitive();
        boolean wantsFuzzyMatching = !this.criteria.isStrict();
        for (Map.Entry<String, Object> critField : this.criteria.getFilterFields().entrySet()) {
            Object value = critField.getValue();
            if (value instanceof String) {
                String formattedValue = (String)value;
                if (wantCaseInsensitiveMatch) {
                    formattedValue = formattedValue.toLowerCase();
                }
                formattedValue = formattedValue.replaceAll("\\_", "\\\\_");
                if (wantsFuzzyMatching) {
                    formattedValue = (formattedValue.startsWith("%") ? "" : "%") + formattedValue + (formattedValue.endsWith("%") ? "" : "%");
                }
                value = formattedValue;
            }
            LOG.debug((Object)("Bind: (" + critField.getKey() + ", " + value + ")"));
            query.setParameter(critField.getKey(), value);
        }
    }

    public static void main(String[] args) {
        CriteriaQueryGenerator.testResourceCriteria();
    }

    public static void testSubjectCriteria() {
        SubjectCriteria subjectCriteria = new SubjectCriteria();
        subjectCriteria.addFilterFirstName("joe");
        subjectCriteria.addFilterFactive(true);
        subjectCriteria.fetchRoles(true);
        subjectCriteria.addSortName(PageOrdering.ASC);
        CriteriaQueryGenerator subjectGenerator = new CriteriaQueryGenerator(subjectCriteria);
        System.out.println(subjectGenerator.getQueryString(false));
        System.out.println(subjectGenerator.getQueryString(true));
    }

    public static void testAlertCriteria() {
        AlertCriteria alertCriteria = new AlertCriteria();
        alertCriteria.addFilterName("joe");
        alertCriteria.addFilterDescription("query generation is cool");
        alertCriteria.addFilterStartTime(42L);
        alertCriteria.addFilterEndTime(100L);
        alertCriteria.addFilterResourceIds(1, 2, 3);
        alertCriteria.fetchAlertDefinition(true);
        alertCriteria.addSortPriority(PageOrdering.DESC);
        alertCriteria.addSortName(PageOrdering.ASC);
        alertCriteria.setPaging(0, 100);
        alertCriteria.setFiltersOptional(true);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(alertCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
        generator.setAuthorizationResourceFragment(AuthorizationTokenType.RESOURCE, "definition.resource", 1);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static void testInheritanceCriteria() {
        ResourceOperationHistoryCriteria historyCriteria = new ResourceOperationHistoryCriteria();
        historyCriteria.addFilterResourceIds(1);
        historyCriteria.addFilterStatus(OperationRequestStatus.FAILURE);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(historyCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static void testResourceCriteria() {
        ResourceCriteria resourceCriteria = new ResourceCriteria();
        resourceCriteria.addFilterResourceCategory(ResourceCategory.SERVER);
        resourceCriteria.addFilterName("marques");
        resourceCriteria.fetchAgent(true);
        resourceCriteria.addSortResourceTypeName(PageOrdering.ASC);
        resourceCriteria.setCaseSensitive(true);
        resourceCriteria.setFiltersOptional(true);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(resourceCriteria);
        generator.getQueryString(false);
        generator.getQueryString(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthorizationTokenType {
        RESOURCE,
        GROUP;

    }
}

