/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.persistent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionSerializationFactory;
import org.jboss.web.tomcat.service.session.persistent.IncomingDistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.persistent.PersistentStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RDBMSStoreBase
implements PersistentStore {
    private static final Logger LOG = Logger.getLogger(RDBMSStoreBase.class);
    public static final String DEFAULT_TABLE = "httpsessions";
    public static final String DEFAULT_APP_COL = "app";
    public static final String DEFAULT_ID_COL = "id";
    public static final String DEFAULT_FULLID_COL = "fullid";
    public static final String DEFAULT_ATTRIBUTE_COL = "attributes";
    public static final String DEFAULT_METADATA_COL = "metadata";
    public static final String DEFAULT_ISNEW_COL = "isnew";
    public static final String DEFAULT_ISVALID_COL = "valid";
    public static final String DEFAULT_CREATION_TIME_COL = "creationtime";
    public static final String DEFAULT_LAST_ACCESSED_COL = "lastaccess";
    public static final String DEFAULT_MAX_INACTIVE_COL = "maxinactive";
    public static final String DEFAULT_VERSION_COL = "version";
    public static final int DEFAULT_CLEANUP_INTERVAL = 14400;
    private Logger logger = null;
    private boolean started = false;
    private String name = null;
    private int cleanupInterval = 14400;
    private long lastCleanup = 0L;
    private int maxUnreplicatedInterval = -1;
    private String connectionName = null;
    private String connectionPassword = null;
    private String sessionTable = "httpsessions";
    private String sessionAppCol = "app";
    private String sessionIdCol = "id";
    private String sessionFullIdCol = "fullid";
    private String sessionCreationTimeCol = "creationtime";
    private String sessionMaxInactiveCol = "maxinactive";
    private String sessionVersionCol = "version";
    private String sessionLastAccessedCol = "lastaccess";
    private String sessionNewCol = "isnew";
    private String sessionValidCol = "valid";
    private String sessionMetadataCol = "metadata";
    private String sessionAttributeCol = "attributes";
    private String clearSql;
    private String sizeSql;
    private String insertSql;
    private String fullUpdateSql;
    private String keysSql;
    private String fullLoadSql;
    private String partialLoadSql;
    private String removeSql;
    private String versionSql;
    private String timestampSql;
    private final Map<Connection, Set<Statement>> statementsByConnection = new ConcurrentHashMap<Connection, Set<Statement>>();
    private String simpleUpdateSql;
    private String attributeUpdateSql;
    private String metadataUpdateSql;
    private String cleanupSql;
    private final byte[] emptyAttributes;

    protected RDBMSStoreBase() {
        try {
            SimpleCachableMarshalledValue empty = new SimpleCachableMarshalledValue(new HashMap());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(empty);
            oos.close();
            this.emptyAttributes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize simple HashMap");
        }
    }

    public abstract String getStoreName();

    public abstract String getInfo();

    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("Must configure a name for PersistentStore");
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public void setSessionTable(String sessionTable) {
        this.sessionTable = sessionTable;
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionAppCol(String sessionAppCol) {
        this.sessionAppCol = sessionAppCol;
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionIdCol(String sessionIdCol) {
        this.sessionIdCol = sessionIdCol;
    }

    public String getSessionFullIdCol() {
        return this.sessionFullIdCol;
    }

    public void setSessionFullIdCol(String sessionFullIdCol) {
        this.sessionFullIdCol = sessionFullIdCol;
    }

    public String getSessionCreationTimeCol() {
        return this.sessionCreationTimeCol;
    }

    public void setSessionCreationTimeCol(String sessionCreationTimeCol) {
        this.sessionCreationTimeCol = sessionCreationTimeCol;
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
    }

    public String getSessionNewCol() {
        return this.sessionNewCol;
    }

    public void setSessionNewCol(String sessionNewCol) {
        this.sessionNewCol = sessionNewCol;
    }

    public String getSessionVersionCol() {
        return this.sessionVersionCol;
    }

    public void setSessionVersionCol(String sessionVersionCol) {
        this.sessionVersionCol = sessionVersionCol;
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        this.sessionLastAccessedCol = sessionLastAccessedCol;
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionValidCol(String sessionValidCol) {
        this.sessionValidCol = sessionValidCol;
    }

    public String getSessionMetadataCol() {
        return this.sessionMetadataCol;
    }

    public void setSessionMetadataCol(String sessionMetadataCol) {
        this.sessionMetadataCol = sessionMetadataCol;
    }

    public String getSessionAttributeCol() {
        return this.sessionAttributeCol;
    }

    public void setSessionAttributeCol(String sessionAttributeCol) {
        this.sessionAttributeCol = sessionAttributeCol;
    }

    public int getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(int cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval = maxUnreplicatedInterval;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var9_9;
            Object var7_8;
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            try {
                try {
                    PreparedStatement preparedClearSql = this.prepareStatement(_conn, this.getClearSql());
                    preparedClearSql.setString(1, this.getName());
                    preparedClearSql.execute();
                    _conn.commit();
                    success = true;
                    exception = null;
                    var7_8 = null;
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught SQLException executing store clear", e);
                    }
                    var7_8 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, null, true);
                        }
                        var9_9 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (RuntimeException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    var7_8 = null;
                    try {}
                    catch (Throwable throwable) {
                        var9_9 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                    if (!success) {
                        this.cleanup(_conn, null, true);
                    }
                    var9_9 = null;
                    this.releaseConnection(_conn);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                try {}
                catch (Throwable throwable2) {
                    var9_9 = null;
                    this.releaseConnection(_conn);
                    throw throwable2;
                }
                if (!success) {
                    this.cleanup(_conn, null, true);
                }
                var9_9 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                var9_9 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            if (!success) {
                this.cleanup(_conn, null, true);
            }
            var9_9 = null;
            this.releaseConnection(_conn);
            break;
        }
        if (exception == null) return;
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSize() {
        int size = 0;
        ResultSet rst = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var12_12;
            Connection _conn;
            block29: {
                block28: {
                    SQLException e222;
                    Object var9_10;
                    _conn = this.safeGetConnection();
                    boolean success = false;
                    try {
                        try {
                            PreparedStatement preparedSizeSql = this.prepareStatement(_conn, this.getSizeSql());
                            preparedSizeSql.setString(1, this.getName());
                            rst = preparedSizeSql.executeQuery();
                            if (rst.next()) {
                                size = rst.getInt(1);
                            }
                            _conn.commit();
                            success = true;
                            exception = null;
                            var9_10 = null;
                        }
                        catch (SQLException e3) {
                            if (exception == null) {
                                exception = new RuntimeException("Caught SQLException getting store size", e3);
                            }
                            var9_10 = null;
                            try {
                                block24: {
                                    try {
                                        if (!success) {
                                            this.cleanup(_conn, rst, true);
                                            break block24;
                                        }
                                        if (rst == null) break block24;
                                        rst.close();
                                    }
                                    catch (SQLException e222) {
                                        var12_12 = null;
                                        this.releaseConnection(_conn);
                                        continue;
                                    }
                                }
                                var12_12 = null;
                                this.releaseConnection(_conn);
                                continue;
                            }
                            catch (Throwable throwable) {
                                var12_12 = null;
                                this.releaseConnection(_conn);
                                throw throwable;
                            }
                        }
                        catch (RuntimeException e4) {
                            block26: {
                                block25: {
                                    if (exception == null) {
                                        exception = e4;
                                    }
                                    var9_10 = null;
                                    try {}
                                    catch (Throwable throwable) {
                                        var12_12 = null;
                                        this.releaseConnection(_conn);
                                        throw throwable;
                                    }
                                    try {}
                                    catch (SQLException e222) {
                                        var12_12 = null;
                                        this.releaseConnection(_conn);
                                        continue;
                                    }
                                    if (success) break block25;
                                    this.cleanup(_conn, rst, true);
                                    break block26;
                                }
                                if (rst == null) break block26;
                                rst.close();
                            }
                            var12_12 = null;
                            this.releaseConnection(_conn);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        try {}
                        catch (Throwable throwable2) {
                            var12_12 = null;
                            this.releaseConnection(_conn);
                            throw throwable2;
                        }
                        try {}
                        catch (SQLException e222) {
                            var12_12 = null;
                            this.releaseConnection(_conn);
                            throw throwable;
                        }
                        if (!success) {
                            this.cleanup(_conn, rst, true);
                        } else if (rst != null) {
                            rst.close();
                        }
                        var12_12 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                    try {}
                    catch (Throwable throwable) {
                        var12_12 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                    try {}
                    catch (SQLException e222) {
                        var12_12 = null;
                        this.releaseConnection(_conn);
                        break;
                    }
                    if (success) break block28;
                    this.cleanup(_conn, rst, true);
                    break block29;
                }
                if (rst == null) break block29;
                rst.close();
            }
            var12_12 = null;
            this.releaseConnection(_conn);
            break;
        }
        if (exception == null) return size;
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getSessionIds() {
        ResultSet rst = null;
        HashSet<String> keys = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var12_12;
            Connection _conn;
            block30: {
                block29: {
                    SQLException e22;
                    Object var9_10;
                    _conn = this.safeGetConnection();
                    boolean success = true;
                    try {
                        try {
                            PreparedStatement preparedKeysSql = this.prepareStatement(_conn, this.getKeysSql());
                            preparedKeysSql.setString(1, this.getName());
                            rst = preparedKeysSql.executeQuery();
                            keys = new HashSet<String>();
                            if (rst != null) {
                                while (rst.next()) {
                                    keys.add(rst.getString(1));
                                }
                            }
                            _conn.commit();
                            success = true;
                            exception = null;
                            var9_10 = null;
                        }
                        catch (SQLException e3) {
                            if (exception == null) {
                                exception = new RuntimeException("Caught SQLException getting session ids", e3);
                            }
                            var9_10 = null;
                            try {
                                block25: {
                                    try {
                                        if (!success) {
                                            this.cleanup(_conn, rst, true);
                                            break block25;
                                        }
                                        if (rst == null) break block25;
                                        rst.close();
                                    }
                                    catch (SQLException e22) {
                                        var12_12 = null;
                                        this.releaseConnection(_conn);
                                        continue;
                                    }
                                }
                                var12_12 = null;
                                this.releaseConnection(_conn);
                                continue;
                            }
                            catch (Throwable throwable) {
                                var12_12 = null;
                                this.releaseConnection(_conn);
                                throw throwable;
                            }
                        }
                        catch (RuntimeException e4) {
                            block27: {
                                block26: {
                                    if (exception == null) {
                                        exception = e4;
                                    }
                                    var9_10 = null;
                                    try {}
                                    catch (Throwable throwable) {
                                        var12_12 = null;
                                        this.releaseConnection(_conn);
                                        throw throwable;
                                    }
                                    try {}
                                    catch (SQLException e22) {
                                        var12_12 = null;
                                        this.releaseConnection(_conn);
                                        continue;
                                    }
                                    if (success) break block26;
                                    this.cleanup(_conn, rst, true);
                                    break block27;
                                }
                                if (rst == null) break block27;
                                rst.close();
                            }
                            var12_12 = null;
                            this.releaseConnection(_conn);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        try {}
                        catch (Throwable throwable2) {
                            var12_12 = null;
                            this.releaseConnection(_conn);
                            throw throwable2;
                        }
                        try {}
                        catch (SQLException e22) {
                            var12_12 = null;
                            this.releaseConnection(_conn);
                            throw throwable;
                        }
                        if (!success) {
                            this.cleanup(_conn, rst, true);
                        } else if (rst != null) {
                            rst.close();
                        }
                        var12_12 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                    try {}
                    catch (Throwable throwable) {
                        var12_12 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                    try {}
                    catch (SQLException e22) {
                        var12_12 = null;
                        this.releaseConnection(_conn);
                        break;
                    }
                    if (success) break block29;
                    this.cleanup(_conn, rst, true);
                    break block30;
                }
                if (rst == null) break block30;
                rst.close();
            }
            var12_12 = null;
            this.releaseConnection(_conn);
            break;
        }
        if (exception == null) return keys;
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public IncomingDistributableSessionData getSessionData(String realId, boolean includeAttributes) {
        ResultSet rst = null;
        IncomingDistributableSessionDataImpl incomingSession = null;
        ObjectInputStream attributes_ois = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var24_17;
            Exception e2222;
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            String sql = includeAttributes ? this.getFullLoadSql() : this.getPartialLoadSql();
            PreparedStatement preparedLoadSql = this.prepareStatement(_conn, sql);
            preparedLoadSql.setString(1, realId);
            preparedLoadSql.setString(2, this.getName());
            rst = preparedLoadSql.executeQuery();
            if (rst.next()) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace((Object)("Loading session " + RDBMSStoreBase.maskId(realId)));
                }
                DistributableSessionMetadata metadata = new DistributableSessionMetadata();
                metadata.setId(rst.getString(1));
                metadata.setCreationTime(rst.getLong(2));
                String isNew = rst.getString(3);
                metadata.setNew("1".equals(isNew));
                metadata.setMaxInactiveInterval(rst.getInt(4));
                String valid = rst.getString(7);
                metadata.setValid("1".equals(valid));
                Integer version = rst.getInt(5);
                Long timestamp = rst.getLong(6);
                Map attributes = null;
                if (includeAttributes) {
                    BufferedInputStream attributes_bis = new BufferedInputStream(rst.getBinaryStream(8));
                    attributes_ois = new ObjectInputStream(attributes_bis);
                    SimpleCachableMarshalledValue mv = (SimpleCachableMarshalledValue)attributes_ois.readObject();
                    mv.setObjectStreamSource(SessionSerializationFactory.getObjectStreamSource());
                    attributes = (Map)RDBMSStoreBase.uncheckedCast(mv.get());
                }
                incomingSession = new IncomingDistributableSessionDataImpl(version, timestamp, metadata, attributes);
            } else if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)(this.getStoreName() + ": No persisted data object found"));
            }
            _conn.commit();
            success = true;
            exception = null;
            Object var21_15 = null;
            try {
                try {
                    if (!success) {
                        this.cleanup(_conn, rst, true);
                    } else if (rst != null) {
                        rst.close();
                    }
                    if (attributes_ois != null) {
                        try {
                            attributes_ois.close();
                        }
                        catch (IOException e2222) {
                        }
                    }
                    var24_17 = null;
                    this.releaseConnection(_conn);
                }
                catch (SQLException e2222) {
                    var24_17 = null;
                    this.releaseConnection(_conn);
                }
                break;
            }
            catch (Throwable throwable) {
                var24_17 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            {
                catch (SQLException e3) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught SQLException loading session " + RDBMSStoreBase.maskId(realId), e3);
                    }
                    var21_15 = null;
                    try {
                        try {
                            if (!success) {
                                this.cleanup(_conn, rst, true);
                            } else if (rst != null) {
                                rst.close();
                            }
                            if (attributes_ois != null) {
                                try {
                                    attributes_ois.close();
                                }
                                catch (IOException e2222) {
                                }
                            }
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        catch (SQLException e2222) {
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        var24_17 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (IOException e4) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught IOException loading session " + RDBMSStoreBase.maskId(realId), e4);
                    }
                    var21_15 = null;
                    try {
                        try {
                            if (!success) {
                                this.cleanup(_conn, rst, true);
                            } else if (rst != null) {
                                rst.close();
                            }
                            if (attributes_ois != null) {
                                try {
                                    attributes_ois.close();
                                }
                                catch (IOException e2222) {
                                }
                            }
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        catch (SQLException e2222) {
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        var24_17 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (ClassNotFoundException e5) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught ClassNotFoundException loading session " + RDBMSStoreBase.maskId(realId), e5);
                    }
                    var21_15 = null;
                    try {
                        try {
                            if (!success) {
                                this.cleanup(_conn, rst, true);
                            } else if (rst != null) {
                                rst.close();
                            }
                            if (attributes_ois != null) {
                                try {
                                    attributes_ois.close();
                                }
                                catch (IOException e2222) {
                                }
                            }
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        catch (SQLException e2222) {
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        var24_17 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (RuntimeException e6) {
                    if (exception == null) {
                        exception = e6;
                    }
                    var21_15 = null;
                    try {
                        try {
                            if (!success) {
                                this.cleanup(_conn, rst, true);
                            } else if (rst != null) {
                                rst.close();
                            }
                            if (attributes_ois != null) {
                                try {
                                    attributes_ois.close();
                                }
                                catch (IOException e2222) {
                                }
                            }
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        catch (SQLException e2222) {
                            var24_17 = null;
                            this.releaseConnection(_conn);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        var24_17 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                var21_15 = null;
                try {
                    try {
                        if (!success) {
                            this.cleanup(_conn, rst, true);
                        } else if (rst != null) {
                            rst.close();
                        }
                        if (attributes_ois != null) {
                            try {
                                attributes_ois.close();
                            }
                            catch (IOException e2222) {
                            }
                        }
                        var24_17 = null;
                        this.releaseConnection(_conn);
                    }
                    catch (SQLException e2222) {
                        var24_17 = null;
                        this.releaseConnection(_conn);
                    }
                }
                catch (Throwable throwable2) {
                    var24_17 = null;
                    this.releaseConnection(_conn);
                    throw throwable2;
                }
                throw throwable;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return incomingSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(String realId) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Loading session " + RDBMSStoreBase.maskId(realId)));
        }
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var10_10;
            Object var8_9;
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            try {
                try {
                    this.executeRemove(realId, _conn);
                    _conn.commit();
                    success = true;
                    exception = null;
                    var8_9 = null;
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught SQLException removing session " + RDBMSStoreBase.maskId(realId), e);
                    }
                    var8_9 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, null, true);
                        }
                        var10_10 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (RuntimeException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    var8_9 = null;
                    try {}
                    catch (Throwable throwable) {
                        var10_10 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                    if (!success) {
                        this.cleanup(_conn, null, true);
                    }
                    var10_10 = null;
                    this.releaseConnection(_conn);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var8_9 = null;
                try {}
                catch (Throwable throwable2) {
                    var10_10 = null;
                    this.releaseConnection(_conn);
                    throw throwable2;
                }
                if (!success) {
                    this.cleanup(_conn, null, true);
                }
                var10_10 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                var10_10 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            if (!success) {
                this.cleanup(_conn, null, true);
            }
            var10_10 = null;
            this.releaseConnection(_conn);
            break;
        }
        if (exception == null) return;
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void storeSessionData(OutgoingSessionGranularitySessionData sessionData) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Storing session " + RDBMSStoreBase.maskId(sessionData)));
        }
        RuntimeException exception = null;
        ObjectOutputStream oos = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var14_13;
            IOException ignored22;
            boolean success = false;
            Connection _conn = this.safeGetConnection();
            if (_conn == null) {
                return;
            }
            byte[] obs = this.writeSessionAttributes(sessionData);
            DistributableSessionMetadata metadata = sessionData.getMetadata();
            if (metadata != null && metadata.isNew()) {
                try {
                    this.executeInsert(sessionData, obs, _conn);
                }
                catch (SQLException e) {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace((Object)("Caught SQLException inserting session " + RDBMSStoreBase.maskId(sessionData)), (Throwable)e);
                    }
                    if (this.executeGetSessionVersion(_conn, sessionData.getRealId()) != null) {
                        this.executeUpdate(sessionData, obs, _conn);
                    }
                    throw e;
                }
            } else {
                int count = this.executeUpdate(sessionData, obs, _conn);
                if (count < 1) {
                    if (metadata != null && obs != null) {
                        this.executeInsert(sessionData, obs, _conn);
                    } else {
                        throw new IllegalStateException("Cannot insert session " + RDBMSStoreBase.maskId(sessionData) + " as session metadata is not available");
                    }
                }
            }
            _conn.commit();
            success = true;
            exception = null;
            Object var11_11 = null;
            try {
                if (!success) {
                    this.cleanup(_conn, null, true);
                }
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ignored22) {
                    }
                }
                var14_13 = null;
                this.releaseConnection(_conn);
                break;
            }
            catch (Throwable throwable) {
                var14_13 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            {
                catch (SQLException e) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught SQLException storing session " + RDBMSStoreBase.maskId(sessionData), e);
                    }
                    var11_11 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, null, true);
                        }
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (IOException ignored22) {
                            }
                        }
                        var14_13 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught IOException storing session " + RDBMSStoreBase.maskId(sessionData), e);
                    }
                    var11_11 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, null, true);
                        }
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (IOException ignored22) {
                            }
                        }
                        var14_13 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (RuntimeException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    var11_11 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, null, true);
                        }
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (IOException ignored22) {
                            }
                        }
                        var14_13 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                try {
                    if (!success) {
                        this.cleanup(_conn, null, true);
                    }
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException ignored22) {
                        }
                    }
                    var14_13 = null;
                    this.releaseConnection(_conn);
                }
                catch (Throwable throwable2) {
                    var14_13 = null;
                    this.releaseConnection(_conn);
                    throw throwable2;
                }
                throw throwable;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static String maskId(OutgoingSessionGranularitySessionData sessionData) {
        String realId = sessionData == null ? null : sessionData.getRealId();
        return RDBMSStoreBase.maskId(realId);
    }

    private static String maskId(String realId) {
        if (realId == null) {
            return null;
        }
        int length = realId.length();
        if (length <= 8) {
            return realId;
        }
        StringBuilder sb = new StringBuilder(realId.substring(0, 2));
        sb.append("****");
        sb.append(realId.substring(length - 6, length));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Long getSessionTimestamp(String realId) {
        ResultSet rst = null;
        Long result = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var13_13;
            SQLException e222;
            boolean success = false;
            Connection _conn = this.safeGetConnection();
            PreparedStatement preparedTimestampSql = this.prepareStatement(_conn, this.getTimestampSql());
            preparedTimestampSql.setString(1, realId);
            preparedTimestampSql.setString(2, this.getName());
            rst = preparedTimestampSql.executeQuery();
            if (rst.next()) {
                result = rst.getLong(1);
            }
            _conn.commit();
            success = true;
            exception = null;
            Object var10_11 = null;
            try {
                if (!success) {
                    this.cleanup(_conn, rst, true);
                } else if (rst != null) {
                    try {
                        rst.close();
                    }
                    catch (SQLException e222) {
                    }
                }
                var13_13 = null;
                this.releaseConnection(_conn);
                break;
            }
            catch (Throwable throwable) {
                var13_13 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            {
                catch (SQLException e3) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught SQLException getting timestamp for session " + RDBMSStoreBase.maskId(realId), e3);
                    }
                    var10_11 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, rst, true);
                        } else if (rst != null) {
                            try {
                                rst.close();
                            }
                            catch (SQLException e222) {
                            }
                        }
                        var13_13 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var13_13 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (RuntimeException e4) {
                    if (exception == null) {
                        exception = e4;
                    }
                    var10_11 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, rst, true);
                        } else if (rst != null) {
                            try {
                                rst.close();
                            }
                            catch (SQLException e222) {
                            }
                        }
                        var13_13 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var13_13 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                var10_11 = null;
                try {
                    if (!success) {
                        this.cleanup(_conn, rst, true);
                    } else if (rst != null) {
                        try {
                            rst.close();
                        }
                        catch (SQLException e222) {
                        }
                    }
                    var13_13 = null;
                    this.releaseConnection(_conn);
                }
                catch (Throwable throwable2) {
                    var13_13 = null;
                    this.releaseConnection(_conn);
                    throw throwable2;
                }
                throw throwable;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer getSessionVersion(String realId) {
        Integer result = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Object var11_11;
            Object var9_10;
            boolean success = false;
            Connection _conn = this.safeGetConnection();
            try {
                try {
                    result = this.executeGetSessionVersion(_conn, realId);
                    _conn.commit();
                    success = true;
                    exception = null;
                    var9_10 = null;
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = new RuntimeException("Caught SQLException getting version for session " + RDBMSStoreBase.maskId(realId), e);
                    }
                    var9_10 = null;
                    try {
                        if (!success) {
                            this.cleanup(_conn, null, true);
                        }
                        var11_11 = null;
                        this.releaseConnection(_conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var11_11 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                }
                catch (RuntimeException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    var9_10 = null;
                    try {}
                    catch (Throwable throwable) {
                        var11_11 = null;
                        this.releaseConnection(_conn);
                        throw throwable;
                    }
                    if (!success) {
                        this.cleanup(_conn, null, true);
                    }
                    var11_11 = null;
                    this.releaseConnection(_conn);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_10 = null;
                try {}
                catch (Throwable throwable2) {
                    var11_11 = null;
                    this.releaseConnection(_conn);
                    throw throwable2;
                }
                if (!success) {
                    this.cleanup(_conn, null, true);
                }
                var11_11 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                var11_11 = null;
                this.releaseConnection(_conn);
                throw throwable;
            }
            if (!success) {
                this.cleanup(_conn, null, true);
            }
            var11_11 = null;
            this.releaseConnection(_conn);
            break;
        }
        if (exception == null) return result;
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processExpires() {
        long interval;
        long now = System.currentTimeMillis();
        long earliest = now - (interval = (long)(this.cleanupInterval * 1000));
        if (earliest <= this.lastCleanup) return;
        long maxUnrep = this.maxUnreplicatedInterval < 0 ? 60000L : (long)(this.maxUnreplicatedInterval * 1000);
        Connection _conn = this.safeGetConnection();
        boolean success = false;
        try {
            try {
                PreparedStatement preparedCleanupSql = this.prepareStatement(_conn, this.getCleanupSql());
                preparedCleanupSql.setString(1, this.getName());
                preparedCleanupSql.setLong(2, earliest);
                preparedCleanupSql.setLong(3, now - maxUnrep);
                preparedCleanupSql.execute();
                _conn.commit();
                this.lastCleanup = now;
                success = true;
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Caught exception cleaning out expired sessions", (Throwable)e);
                Object var13_10 = null;
                try {
                    if (!success) {
                        this.cleanup(_conn, null, true);
                    }
                    Object var15_14 = null;
                    this.releaseConnection(_conn);
                    return;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    this.releaseConnection(_conn);
                    throw throwable;
                }
            }
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            try {}
            catch (Throwable throwable2) {
                Object var15_17 = null;
                this.releaseConnection(_conn);
                throw throwable2;
            }
            if (!success) {
                this.cleanup(_conn, null, true);
            }
            Object var15_16 = null;
            this.releaseConnection(_conn);
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var15_13 = null;
            this.releaseConnection(_conn);
            throw throwable;
        }
        if (!success) {
            this.cleanup(_conn, null, true);
        }
        Object var15_12 = null;
        this.releaseConnection(_conn);
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException(this.getStoreName() + " is already started");
        }
        this.getName();
        this.createSql();
        this.startStore();
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            throw new IllegalStateException(this.getStoreName() + " is not started");
        }
        this.started = false;
    }

    protected abstract void startStore();

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void releaseConnection(Connection var1);

    protected void cleanup(Connection conn, ResultSet resultSet, boolean rollback) {
        if (conn != null) {
            Set<Statement> stmts;
            block13: {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().warn((Object)("Caught SQLException closing a result set -- " + e.getLocalizedMessage()));
                    }
                }
                if (rollback) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        if (!this.getLogger().isTraceEnabled()) break block13;
                        this.getLogger().trace((Object)("Caught SQLException rolling back connection -- " + e.getLocalizedMessage()), (Throwable)e);
                    }
                }
            }
            if ((stmts = this.statementsByConnection.remove(conn)) != null) {
                for (Statement stmt : stmts) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().debug((Object)("Caught SQLException closing statement -- " + e.getLocalizedMessage()));
                    }
                }
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.getLogger().error((Object)("Caught SQLException closing connection -- " + e.getLocalizedMessage()));
            }
        }
    }

    protected Logger getLogger() {
        return this.logger == null ? LOG : this.logger;
    }

    private void createSql() {
        this.clearSql = "DELETE FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?";
        this.keysSql = "SELECT " + this.getSessionIdCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?";
        this.sizeSql = "SELECT COUNT(" + this.getSessionIdCol() + ") " + "        FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?";
        this.fullLoadSql = "SELECT " + this.getSessionFullIdCol() + ", " + this.getSessionCreationTimeCol() + ", " + this.getSessionNewCol() + ", " + this.getSessionMaxInactiveCol() + ", " + this.getSessionVersionCol() + ", " + this.getSessionLastAccessedCol() + ", " + this.getSessionValidCol() + ", " + this.getSessionAttributeCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.partialLoadSql = "SELECT " + this.getSessionFullIdCol() + ", " + this.getSessionCreationTimeCol() + ", " + this.getSessionNewCol() + ", " + this.getSessionMaxInactiveCol() + ", " + this.getSessionVersionCol() + ", " + this.getSessionLastAccessedCol() + ", " + this.getSessionValidCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.removeSql = "DELETE FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.insertSql = "INSERT INTO " + this.getSessionTable() + " (" + this.getSessionAppCol() + ", " + this.getSessionIdCol() + ", " + this.getSessionFullIdCol() + ", " + this.getSessionCreationTimeCol() + ", " + this.getSessionNewCol() + ", " + this.getSessionMaxInactiveCol() + ", " + this.getSessionVersionCol() + ", " + this.getSessionLastAccessedCol() + ", " + this.getSessionValidCol() + ", " + this.getSessionAttributeCol() + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.simpleUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.attributeUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?, " + this.getSessionAttributeCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.metadataUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?, " + this.getSessionFullIdCol() + " = ?, " + this.getSessionNewCol() + " = ?, " + this.getSessionMaxInactiveCol() + " = ?, " + this.getSessionValidCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.fullUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?, " + this.getSessionFullIdCol() + " = ?, " + this.getSessionNewCol() + " = ?, " + this.getSessionMaxInactiveCol() + " = ?, " + this.getSessionValidCol() + " = ?, " + this.getSessionAttributeCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.timestampSql = "SELECT " + this.getSessionLastAccessedCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.versionSql = "SELECT " + this.getSessionVersionCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.cleanupSql = "DELETE FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?" + " AND " + this.getSessionLastAccessedCol() + " < ? AND " + this.getSessionLastAccessedCol() + " < (? - (" + this.getSessionMaxInactiveCol() + " * 1000))";
    }

    private void executeRemove(String id, Connection _conn) throws SQLException {
        PreparedStatement preparedRemoveSql = this.prepareStatement(_conn, this.getRemoveSql());
        preparedRemoveSql.setString(1, id);
        preparedRemoveSql.setString(2, this.getName());
        preparedRemoveSql.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInsert(OutgoingSessionGranularitySessionData session, byte[] obs, Connection conn) throws SQLException, IOException {
        DistributableSessionMetadata metadata;
        if (obs == null) {
            obs = this.emptyAttributes;
        }
        if ((metadata = session.getMetadata()) == null) {
            throw new IllegalStateException("Cannot insert session " + RDBMSStoreBase.maskId(session) + " as session metadata is missing");
        }
        int size = obs.length;
        ByteArrayInputStream bis = new ByteArrayInputStream(obs);
        BufferedInputStream in = new BufferedInputStream(bis, size);
        try {
            PreparedStatement preparedInsertSql = this.prepareStatement(conn, this.getInsertSql());
            preparedInsertSql.setString(1, this.getName());
            preparedInsertSql.setString(2, session.getRealId());
            preparedInsertSql.setString(3, metadata.getId());
            preparedInsertSql.setLong(4, metadata.getCreationTime());
            preparedInsertSql.setString(5, metadata.isNew() ? "1" : "0");
            preparedInsertSql.setInt(6, metadata.getMaxInactiveInterval());
            preparedInsertSql.setInt(7, session.getVersion());
            preparedInsertSql.setLong(8, session.getTimestamp());
            preparedInsertSql.setString(9, metadata.isValid() ? "1" : "0");
            preparedInsertSql.setBinaryStream(10, (InputStream)in, size);
            preparedInsertSql.execute();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(OutgoingSessionGranularitySessionData session, byte[] obs, Connection conn) throws SQLException, IOException {
        int n;
        block9: {
            DistributableSessionMetadata metadata = session.getMetadata();
            int size = obs == null ? -1 : obs.length;
            InputStream in = null;
            if (obs != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(obs);
                in = new BufferedInputStream(bis, size);
            }
            try {
                int count;
                PreparedStatement preparedUpdateSql = null;
                int idParam = -1;
                if (metadata != null) {
                    if (obs != null) {
                        preparedUpdateSql = this.prepareStatement(conn, this.getFullUpdateSql());
                        preparedUpdateSql.setBinaryStream(7, in, size);
                        idParam = 8;
                    } else {
                        preparedUpdateSql = this.prepareStatement(conn, this.getMetadataUpdateSql());
                        idParam = 7;
                    }
                    preparedUpdateSql.setString(3, metadata.getId());
                    preparedUpdateSql.setString(4, metadata.isNew() ? "1" : "0");
                    preparedUpdateSql.setInt(5, metadata.getMaxInactiveInterval());
                    preparedUpdateSql.setString(6, metadata.isValid() ? "1" : "0");
                } else if (obs != null) {
                    preparedUpdateSql = this.prepareStatement(conn, this.getAttributeUpdateSql());
                    preparedUpdateSql.setBinaryStream(3, in, size);
                    idParam = 4;
                } else {
                    preparedUpdateSql = this.prepareStatement(conn, this.getSimpleUpdateSql());
                    idParam = 3;
                }
                preparedUpdateSql.setInt(1, session.getVersion());
                preparedUpdateSql.setLong(2, session.getTimestamp());
                preparedUpdateSql.setString(idParam, session.getRealId());
                preparedUpdateSql.setString(idParam + 1, this.getName());
                n = count = preparedUpdateSql.executeUpdate();
                Object var12_11 = null;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var12_12 = null;
                    if (in == null) break block10;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer executeGetSessionVersion(Connection _conn, String realId) throws SQLException {
        Integer n;
        block3: {
            PreparedStatement preparedTimestampSql = this.prepareStatement(_conn, this.getVersionSql());
            preparedTimestampSql.setString(1, realId);
            preparedTimestampSql.setString(2, this.getName());
            ResultSet rst = null;
            try {
                Integer result = null;
                rst = preparedTimestampSql.executeQuery();
                if (rst.next()) {
                    result = rst.getInt(1);
                }
                n = result;
                Object var8_7 = null;
                if (rst == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (rst == null) break block4;
                    rst.close();
                }
                throw throwable;
            }
            rst.close();
        }
        return n;
    }

    private String getCleanupSql() {
        return this.cleanupSql;
    }

    private String getClearSql() {
        return this.clearSql;
    }

    private String getInsertSql() {
        return this.insertSql;
    }

    private String getFullUpdateSql() {
        return this.fullUpdateSql;
    }

    private String getSimpleUpdateSql() {
        return this.simpleUpdateSql;
    }

    private String getMetadataUpdateSql() {
        return this.metadataUpdateSql;
    }

    private String getAttributeUpdateSql() {
        return this.attributeUpdateSql;
    }

    private String getKeysSql() {
        return this.keysSql;
    }

    private String getFullLoadSql() {
        return this.fullLoadSql;
    }

    private String getPartialLoadSql() {
        return this.partialLoadSql;
    }

    private String getRemoveSql() {
        return this.removeSql;
    }

    private String getSizeSql() {
        return this.sizeSql;
    }

    private String getVersionSql() {
        return this.versionSql;
    }

    private String getTimestampSql() {
        return this.timestampSql;
    }

    private Connection safeGetConnection() {
        try {
            return this.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Caught SQLException getting a connection", e);
        }
    }

    private PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        Set<Statement> stmts = this.statementsByConnection.get(conn);
        if (stmts == null) {
            stmts = new HashSet<Statement>();
            this.statementsByConnection.put(conn, stmts);
        }
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmts.add(stmt);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeSessionAttributes(OutgoingSessionGranularitySessionData session) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream bos;
        block5: {
            Map attrs = session.getSessionAttributes();
            if (attrs == null) {
                return null;
            }
            ObjectOutputStream oos = null;
            bos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
                oos.writeObject(new SimpleCachableMarshalledValue((Serializable)((Object)attrs)));
                oos.close();
                byArray = bos.toByteArray();
                Object var7_6 = null;
                if (oos == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_7 = null;
                    if (oos != null) {
                        oos.close();
                    }
                    if (bos == null) break block6;
                    bos.close();
                }
                throw throwable;
            }
            oos.close();
        }
        if (bos != null) {
            bos.close();
        }
        return byArray;
    }

    private static <T> T uncheckedCast(Object obj) {
        return (T)obj;
    }
}

