/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpCodecUtil;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelPipelineCoverage(value="all")
public abstract class HttpMessageEncoder
extends OneToOneEncoder {
    private static final ChannelBuffer LAST_CHUNK = ChannelBuffers.copiedBuffer("0\r\n\r\n", "ASCII");

    protected HttpMessageEncoder() {
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof HttpMessage) {
            HttpMessage request = (HttpMessage)msg;
            ChannelBuffer header = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
            this.encodeInitialLine(header, request);
            this.encodeHeaders(header, request);
            header.writeBytes(HttpCodecUtil.CRLF);
            ChannelBuffer content = request.getContent();
            if (!content.readable()) {
                return header;
            }
            return ChannelBuffers.wrappedBuffer(header, content);
        }
        if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            if (chunk.isLast()) {
                return LAST_CHUNK.duplicate();
            }
            ChannelBuffer content = chunk.getContent();
            int contentLength = content.readableBytes();
            return ChannelBuffers.wrappedBuffer(ChannelBuffers.copiedBuffer(Integer.toHexString(contentLength), "ASCII"), ChannelBuffers.wrappedBuffer(HttpCodecUtil.CRLF), content.slice(content.readerIndex(), contentLength), ChannelBuffers.wrappedBuffer(HttpCodecUtil.CRLF));
        }
        return msg;
    }

    private void encodeHeaders(ChannelBuffer buf, HttpMessage message) {
        Set<String> headers = message.getHeaderNames();
        try {
            for (String header : headers) {
                List<String> values = message.getHeaders(header);
                for (String value : values) {
                    buf.writeBytes(header.getBytes("ASCII"));
                    buf.writeByte((byte)58);
                    buf.writeByte((byte)32);
                    buf.writeBytes(value.getBytes("ASCII"));
                    buf.writeBytes(HttpCodecUtil.CRLF);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw (Error)new Error().initCause(e);
        }
    }

    protected abstract void encodeInitialLine(ChannelBuffer var1, HttpMessage var2) throws Exception;
}

