/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.catalina.Container;
import org.jboss.modcluster.Context;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.catalina.CatalinaContext;
import org.jboss.modcluster.catalina.CatalinaEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaHost
implements Host {
    private final org.apache.catalina.Host host;
    private final Engine engine;

    public CatalinaHost(org.apache.catalina.Host host, Engine engine) {
        this.host = host;
        this.engine = engine;
    }

    public CatalinaHost(org.apache.catalina.Host host) {
        this(host, new CatalinaEngine((org.apache.catalina.Engine)host.getParent()));
    }

    @Override
    public Set<String> getAliases() {
        String name = this.host.getName();
        String[] aliases = this.host.findAliases();
        if (aliases.length == 0) {
            return Collections.singleton(name);
        }
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        hosts.add(name);
        for (String alias : aliases) {
            hosts.add(alias);
        }
        return hosts;
    }

    @Override
    public Iterable<Context> getContexts() {
        final Iterator<Container> children = Arrays.asList(this.host.findChildren()).iterator();
        final Iterator<Context> contexts = new Iterator<Context>(){

            @Override
            public boolean hasNext() {
                return children.hasNext();
            }

            @Override
            public Context next() {
                return new CatalinaContext((org.apache.catalina.Context)children.next(), CatalinaHost.this);
            }

            @Override
            public void remove() {
                children.remove();
            }
        };
        return new Iterable<Context>(){

            @Override
            public Iterator<Context> iterator() {
                return contexts;
            }
        };
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public String getName() {
        return this.host.getName();
    }

    @Override
    public Context findContext(String path) {
        org.apache.catalina.Context context = (org.apache.catalina.Context)this.host.findChild(path);
        return context != null ? new CatalinaContext(context, this) : null;
    }

    public String toString() {
        return this.host.getName();
    }
}

