/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import org.jboss.ws.core.client.transport.NettyTransportHandler;

public class KeepAliveCache
implements Runnable {
    private static final long serialVersionUID = 1L;
    private Hashtable<KeepAliveKey, TransportHandlerVector> table = new Hashtable();
    private static final int DEFAULT_MAX_CONNECTIONS = 5;
    private static int maxConnections = -1;
    private static final int LIFETIME = 5000;
    private Thread keepAliveTimer = null;

    static int getMaxConnections() {
        if (maxConnections == -1 && (maxConnections = Integer.parseInt(KeepAliveCache.getSystemProperty("org.jboss.ws.http.maxConnections", String.valueOf(5)))) <= 0) {
            maxConnections = 5;
        }
        return maxConnections;
    }

    public synchronized void put(URL url, NettyTransportHandler transport) {
        KeepAliveKey key;
        TransportHandlerVector v;
        boolean startThread;
        boolean bl = startThread = this.keepAliveTimer == null;
        if (!startThread && !this.keepAliveTimer.isAlive()) {
            startThread = true;
        }
        if (startThread) {
            this.table.clear();
            final KeepAliveCache cache = this;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ThreadGroup grp = Thread.currentThread().getThreadGroup();
                    ThreadGroup parent = null;
                    while ((parent = grp.getParent()) != null) {
                        grp = parent;
                    }
                    KeepAliveCache.this.keepAliveTimer = new Thread(grp, cache, "JBossWS-Keep-Alive-Timer");
                    KeepAliveCache.this.keepAliveTimer.setDaemon(true);
                    KeepAliveCache.this.keepAliveTimer.setPriority(8);
                    KeepAliveCache.this.keepAliveTimer.start();
                    return null;
                }
            });
        }
        if ((v = this.table.get(key = new KeepAliveKey(url))) == null) {
            int keepAliveTimeout = transport.getKeepAliveTimeout();
            v = new TransportHandlerVector(keepAliveTimeout > 0 ? keepAliveTimeout * 1000 : 5000);
            v.put(transport);
            this.table.put(key, v);
        } else {
            v.put(transport);
        }
    }

    public synchronized void remove(NettyTransportHandler h, Object obj) {
        KeepAliveKey key = new KeepAliveKey(h.getUrl());
        TransportHandlerVector v = this.table.get(key);
        if (v != null) {
            v.remove(h);
            if (v.empty()) {
                this.removeVector(key);
            }
        }
    }

    synchronized void removeVector(KeepAliveKey k) {
        this.table.remove(k);
    }

    public synchronized NettyTransportHandler get(URL url) {
        KeepAliveKey key = new KeepAliveKey(url);
        TransportHandlerVector v = this.table.get(key);
        if (v == null) {
            return null;
        }
        return v.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                long currentTime = System.currentTimeMillis();
                ArrayList<KeepAliveKey> keysToRemove = new ArrayList<KeepAliveKey>();
                for (KeepAliveKey key : this.table.keySet()) {
                    TransportHandlerVector v;
                    TransportHandlerVector transportHandlerVector = v = this.table.get(key);
                    synchronized (transportHandlerVector) {
                        int i;
                        for (i = 0; i < v.size(); ++i) {
                            KeepAliveEntry e = (KeepAliveEntry)v.elementAt(i);
                            if (currentTime - e.idleStartTime <= (long)v.nap) break;
                            NettyTransportHandler h = e.hc;
                            h.end();
                        }
                        v.subList(0, i).clear();
                        if (v.size() == 0) {
                            keysToRemove.add(key);
                        }
                    }
                }
                for (KeepAliveKey key : keysToRemove) {
                    this.removeVector(key);
                }
            }
        } while (this.table.size() > 0);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    static String getSystemProperty(final String name, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(name, defaultValue);
        }
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }
        };
        return AccessController.doPrivileged(action);
    }

    class KeepAliveEntry {
        NettyTransportHandler hc;
        long idleStartTime;

        KeepAliveEntry(NettyTransportHandler hc, long idleStartTime) {
            this.hc = hc;
            this.idleStartTime = idleStartTime;
        }
    }

    class KeepAliveKey {
        private String protocol = null;
        private String host = null;
        private int port = 0;

        public KeepAliveKey(URL url) {
            this.protocol = url.getProtocol();
            this.host = url.getHost();
            this.port = url.getPort();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeepAliveKey)) {
                return false;
            }
            KeepAliveKey kae = (KeepAliveKey)obj;
            return this.host.equals(kae.host) && this.port == kae.port && this.protocol.equals(kae.protocol);
        }

        public int hashCode() {
            String str = this.protocol + this.host + this.port;
            return str.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransportHandlerVector
    extends Stack<KeepAliveEntry> {
        private static final long serialVersionUID = 1L;
        int nap;

        TransportHandlerVector(int nap) {
            this.nap = nap;
        }

        synchronized NettyTransportHandler get() {
            if (this.empty()) {
                return null;
            }
            NettyTransportHandler hc = null;
            long currentTime = System.currentTimeMillis();
            do {
                KeepAliveEntry e = (KeepAliveEntry)this.pop();
                if (currentTime - e.idleStartTime > (long)this.nap) {
                    e.hc.end();
                    continue;
                }
                hc = e.hc;
            } while (hc == null && !this.empty());
            return hc;
        }

        synchronized void put(NettyTransportHandler h) {
            if (this.size() > KeepAliveCache.getMaxConnections()) {
                h.end();
            } else {
                this.push(new KeepAliveEntry(h, System.currentTimeMillis()));
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            throw new NotSerializableException();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            throw new NotSerializableException();
        }
    }
}

