/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.JAXBContextFactory;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizableJAXBContextFactory
extends JAXBContextFactory {
    protected Logger log = Logger.getLogger(CustomizableJAXBContextFactory.class);

    @Override
    public JAXBContext createContext(Class clazz) throws WSException {
        return this.createContext(new Class[]{clazz});
    }

    @Override
    public JAXBContext createContext(Class[] clazzes) throws WSException {
        try {
            BindingCustomization bcust = this.getCustomization();
            JAXBContext jaxbCtx = null == bcust ? JAXBContext.newInstance((Class[])clazzes) : this.createContext(clazzes, bcust);
            this.incrementContextCount();
            return jaxbCtx;
        }
        catch (JAXBException e) {
            throw new WSException("Failed to create JAXBContext", e);
        }
    }

    @Override
    public JAXBContext createContext(final Class[] clazzes, final BindingCustomization bcust) throws WSException {
        try {
            JAXBContext jaxbCtx = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws PrivilegedActionException {
                    try {
                        return JAXBContext.newInstance((Class[])clazzes, (Map)bcust);
                    }
                    catch (JAXBException e) {
                        throw new PrivilegedActionException((Exception)((Object)e));
                    }
                }
            });
            this.incrementContextCount();
            return jaxbCtx;
        }
        catch (Exception e) {
            throw new WSException("Failed to create JAXBContext", e);
        }
    }

    @Override
    public JAXBRIContext createContext(Class[] classes, Collection<TypeReference> refs, String defaultNS, boolean c14n, BindingCustomization bcust) {
        try {
            RuntimeAnnotationReader anReader = null;
            if (bcust != null) {
                anReader = (RuntimeAnnotationReader)bcust.get((Object)JAXBRIContext.ANNOTATION_READER);
            }
            JAXBRIContext jaxbCtx = JAXBRIContext.newInstance((Class[])classes, refs, null, (String)defaultNS, (boolean)c14n, (RuntimeAnnotationReader)anReader);
            this.incrementContextCount();
            return jaxbCtx;
        }
        catch (JAXBException e) {
            throw new WSException("Failed to create JAXBContext", e);
        }
    }

    private BindingCustomization getCustomization() {
        Endpoint ep = EndpointAssociation.getEndpoint();
        return ep != null ? (BindingCustomization)ep.getAttachment(BindingCustomization.class) : null;
    }
}

