/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxws.binding.BindingExt;
import org.jboss.ws.extensions.addressing.jaxws.WSAddressingClientHandler;
import org.jboss.ws.feature.ChunkedEncodingFeature;
import org.jboss.ws.feature.FastInfosetFeature;
import org.jboss.ws.feature.JsonEncodingFeature;
import org.jboss.ws.feature.SchemaValidationFeature;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FeatureSet;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFeatureProcessor {
    private static Logger log = Logger.getLogger(ClientFeatureProcessor.class);
    private static FeatureSet supportedFeatures = new FeatureSet();

    public static <T> void processFeature(WebServiceFeature feature, EndpointMetaData epMetaData, T stub) {
        if (!supportedFeatures.hasFeature(feature.getClass())) {
            throw new IllegalArgumentException("Unsupported feature: " + feature);
        }
        ClientFeatureProcessor.processAddressingFeature(feature, epMetaData, stub);
        ClientFeatureProcessor.processMTOMFeature(feature, epMetaData, stub);
        ClientFeatureProcessor.processRespectBindingFeature(feature, epMetaData, stub);
        ClientFeatureProcessor.processChunkedEncodingFeature(feature, epMetaData, stub);
        epMetaData.addFeature(feature);
    }

    private static <T> void processAddressingFeature(WebServiceFeature feature, EndpointMetaData epMetaData, T stub) {
        if (feature instanceof AddressingFeature && feature.isEnabled()) {
            BindingExt bindingExt = (BindingExt)((BindingProvider)stub).getBinding();
            List<Handler> handlers = bindingExt.getHandlerChain(UnifiedHandlerMetaData.HandlerType.POST);
            handlers.add((Handler)new WSAddressingClientHandler());
            bindingExt.setHandlerChain(handlers, UnifiedHandlerMetaData.HandlerType.POST);
        }
    }

    private static <T> void processChunkedEncodingFeature(WebServiceFeature feature, EndpointMetaData epMetaData, T stub) {
        if (feature instanceof ChunkedEncodingFeature) {
            Map ctx = ((BindingProvider)stub).getRequestContext();
            ctx.put("http://org.jboss.ws/http#chunksize", ((ChunkedEncodingFeature)feature).getChunkSize());
        }
    }

    private static <T> void processMTOMFeature(WebServiceFeature feature, EndpointMetaData epMetaData, T stub) {
        if (feature instanceof MTOMFeature) {
            SOAPBinding binding = (SOAPBinding)((BindingProvider)stub).getBinding();
            binding.setMTOMEnabled(feature.isEnabled());
        }
    }

    private static <T> void processRespectBindingFeature(WebServiceFeature feature, EndpointMetaData epMetaData, T stub) {
        ServiceMetaData serviceMetaData;
        WSDLDefinitions wsdlDefinitions;
        WSDLService wsdlService;
        if (feature instanceof RespectBindingFeature && feature.isEnabled() && (wsdlService = (wsdlDefinitions = (serviceMetaData = epMetaData.getServiceMetaData()).getWsdlDefinitions()).getService(serviceMetaData.getServiceName())) != null) {
            WSDLEndpoint wsdlEndpoint = wsdlService.getEndpoint(epMetaData.getPortName());
            if (wsdlEndpoint != null) {
                ClientFeatureProcessor.checkNotUnderstoodExtElements(wsdlEndpoint, epMetaData);
                WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(wsdlEndpoint.getBinding());
                ClientFeatureProcessor.checkNotUnderstoodExtElements(wsdlBinding, epMetaData);
            } else {
                log.warn((Object)("Cannot find port " + epMetaData.getPortName()));
            }
        }
    }

    private static void checkNotUnderstoodExtElements(Extendable extendable, EndpointMetaData epMetaData) {
        List<WSDLExtensibilityElement> notUnderstoodList = extendable.getNotUnderstoodExtElements();
        for (WSDLExtensibilityElement el : notUnderstoodList) {
            boolean disabledByFeature = false;
            if (!el.isRequired() || disabledByFeature) continue;
            String s = DOMWriter.printNode((Node)el.getElement(), (boolean)true);
            throw new WebServiceException("RespectBindingFeature enabled and a required not understood element was found: " + s);
        }
    }

    static {
        supportedFeatures.addFeature(new FastInfosetFeature());
        supportedFeatures.addFeature(new JsonEncodingFeature());
        supportedFeatures.addFeature(new SchemaValidationFeature());
        supportedFeatures.addFeature((WebServiceFeature)new AddressingFeature());
        supportedFeatures.addFeature((WebServiceFeature)new MTOMFeature());
        supportedFeatures.addFeature((WebServiceFeature)new RespectBindingFeature());
        supportedFeatures.addFeature(new ChunkedEncodingFeature());
    }
}

