/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.netty.NettyCallbackHandler;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandlerImpl;
import org.jboss.wsf.common.injection.InjectionHelper;
import org.jboss.wsf.common.injection.PreDestroyHolder;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;
import org.jboss.wsf.stack.jbws.WebAppResolver;

final class NettyCallbackHandlerImpl
implements NettyCallbackHandler {
    private static final Logger LOGGER = Logger.getLogger(RMCallbackHandlerImpl.class);
    private static final SPIProvider SPI_PROVIDER = SPIProviderResolver.getInstance().getProvider();
    private static final EndpointRegistry ENDPOINTS_REGISTRY = ((EndpointRegistryFactory)SPI_PROVIDER.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    private final List<PreDestroyHolder> preDestroyRegistry = new LinkedList<PreDestroyHolder>();
    private final String handledPath;
    private Endpoint endpoint;

    public NettyCallbackHandlerImpl(String path, String context, String endpointRegistryPath) {
        this.initEndpoint(context, endpointRegistryPath);
        this.handledPath = path;
    }

    private void initEndpoint(String context, String endpointRegistryPath) {
        WebAppResolver resolver = new WebAppResolver(context, endpointRegistryPath);
        this.endpoint = ENDPOINTS_REGISTRY.resolve((EndpointResolver)resolver);
        if (this.endpoint == null) {
            throw new WebServiceException("Cannot obtain endpoint for: " + endpointRegistryPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(String method, InputStream is, OutputStream os, InvocationContext invCtx) throws IOException {
        block18: {
            EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            if (method.equals("POST")) {
                requestHandler.handleRequest(this.endpoint, is, os, invCtx);
            } else if (method.equals("GET")) {
                requestHandler.handleWSDLRequest(this.endpoint, os, invCtx);
            } else {
                throw new WSException("Unsupported HTTP method: " + method);
            }
            Object var7_7 = null;
            try {
                is.close();
            }
            catch (IOException e2) {
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            try {
                os.close();
            }
            catch (IOException e2) {
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            this.registerForPreDestroy(this.endpoint);
            EndpointAssociation.removeEndpoint();
            {
                break block18;
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var7_8 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    try {
                        os.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    this.registerForPreDestroy(this.endpoint);
                    EndpointAssociation.removeEndpoint();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                try {
                    os.close();
                }
                catch (IOException e2) {
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                this.registerForPreDestroy(this.endpoint);
                EndpointAssociation.removeEndpoint();
                throw throwable;
            }
        }
    }

    public String getPath() {
        return this.handledPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForPreDestroy(Endpoint endpoint) {
        PreDestroyHolder holder = (PreDestroyHolder)endpoint.getAttachment(PreDestroyHolder.class);
        if (holder != null) {
            List<PreDestroyHolder> list = this.preDestroyRegistry;
            synchronized (list) {
                if (!this.preDestroyRegistry.contains(holder)) {
                    this.preDestroyRegistry.add(holder);
                }
            }
            endpoint.removeAttachment(PreDestroyHolder.class);
        }
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        List<PreDestroyHolder> list = this.preDestroyRegistry;
        synchronized (list) {
            for (PreDestroyHolder holder : this.preDestroyRegistry) {
                try {
                    Object targetBean = holder.getObject();
                    InjectionHelper.callPreDestroyMethod((Object)targetBean);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            this.preDestroyRegistry.clear();
        }
    }
}

