/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLRequestHandler {
    private static Logger log = Logger.getLogger(WSDLRequestHandler.class);
    private final EndpointMetaData epMetaData;
    private final ServerConfig config;

    public WSDLRequestHandler(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
    }

    public Document getDocumentForPath(URL reqURL, String wsdlHost, String resPath) throws IOException {
        Document wsdlDoc;
        URL wsdlLocation = this.epMetaData.getServiceMetaData().getWsdlLocation();
        if (wsdlLocation == null) {
            throw new IllegalStateException("Cannot obtain wsdl location");
        }
        if (resPath == null) {
            Element wsdlElement = DOMUtils.parse((InputStream)wsdlLocation.openStream());
            wsdlDoc = wsdlElement.getOwnerDocument();
        } else {
            File wsdlLocFile = new File(wsdlLocation.getPath());
            String impResourcePath = wsdlLocFile.getParent() + File.separatorChar + resPath;
            File impResourceFile = new File(impResourcePath);
            String wsdlPublishLoc = this.epMetaData.getServiceMetaData().getWsdlPublishLocation();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Importing resource file: " + impResourceFile.getCanonicalPath()));
            }
            String wsdlLocFilePath = wsdlLocFile.getParentFile().getCanonicalPath();
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            ServerConfig serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
            String wsdlDataLoc = serverConfig.getServerDataDir().getCanonicalPath() + File.separatorChar + "wsdl";
            String resourceAbsPath = impResourceFile.getCanonicalPath();
            if (resourceAbsPath.indexOf(wsdlLocFilePath) >= 0 || resourceAbsPath.indexOf(wsdlDataLoc) >= 0 || wsdlPublishLoc != null && resourceAbsPath.indexOf(new File(new URL(wsdlPublishLoc).getPath()).getCanonicalPath()) >= 0) {
                Element wsdlElement = DOMUtils.parse((InputStream)impResourceFile.toURL().openStream());
                wsdlDoc = wsdlElement.getOwnerDocument();
            } else {
                throw new IOException("Access to '" + resourceAbsPath + "' resource is not allowed");
            }
        }
        this.modifyAddressReferences(reqURL, wsdlHost, resPath, wsdlDoc.getDocumentElement());
        return wsdlDoc;
    }

    private void modifyAddressReferences(URL reqURL, String wsdlHost, String resPath, Element element) throws IOException {
        NodeList nlist = element.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            String orgLocation;
            Attr locationAttr;
            Node childNode = nlist.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getLocalName();
            if ("import".equals(nodeName) || "include".equals(nodeName)) {
                boolean isAbsolute;
                locationAttr = childElement.getAttributeNode("schemaLocation");
                if (locationAttr == null) {
                    locationAttr = childElement.getAttributeNode("location");
                }
                if (locationAttr == null) continue;
                orgLocation = locationAttr.getNodeValue();
                while (orgLocation.startsWith("./")) {
                    orgLocation = orgLocation.substring(2);
                }
                boolean bl = isAbsolute = orgLocation.startsWith("http://") || orgLocation.startsWith("https://");
                if (isAbsolute || orgLocation.startsWith(reqURL.getPath())) continue;
                String newResourcePath = orgLocation;
                if (resPath != null && resPath.indexOf("/") > 0) {
                    String resParent = resPath.substring(0, resPath.lastIndexOf("/"));
                    while (orgLocation.startsWith("../") && resParent != null) {
                        if (resParent.indexOf("/") > 0) {
                            resParent = resParent.substring(0, resParent.lastIndexOf("/"));
                            orgLocation = orgLocation.substring(3);
                            newResourcePath = resParent + "/" + orgLocation;
                            continue;
                        }
                        newResourcePath = orgLocation = orgLocation.substring(3);
                        resParent = null;
                    }
                    if (resParent != null) {
                        newResourcePath = resParent + "/" + orgLocation;
                    }
                }
                String reqPath = reqURL.getPath();
                String completeHost = wsdlHost;
                if (!wsdlHost.startsWith("http://") && !wsdlHost.startsWith("https://")) {
                    String reqProtocol = reqURL.getProtocol();
                    int reqPort = reqURL.getPort();
                    String hostAndPort = wsdlHost + (reqPort > 0 ? ":" + reqPort : "");
                    completeHost = reqProtocol + "://" + hostAndPort;
                }
                String newLocation = completeHost + reqPath + "?wsdl&resource=" + newResourcePath;
                locationAttr.setNodeValue(newLocation);
                log.trace((Object)("Mapping import from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            if ("address".equals(nodeName)) {
                String path;
                int port;
                boolean rewriteLocation;
                locationAttr = childElement.getAttributeNode("location");
                if (locationAttr == null || !WSDLRequestHandler.isHttp(orgLocation = locationAttr.getNodeValue())) continue;
                URL orgURL = new URL(orgLocation);
                String orgProtocol = orgURL.getProtocol();
                String host = orgURL.getHost();
                boolean bl = rewriteLocation = "jbossws.undefined.host".equals(host) || this.config.isModifySOAPAddress();
                if (!rewriteLocation) continue;
                boolean confidential = "https".equalsIgnoreCase(orgProtocol);
                String reqProtocol = reqURL.getProtocol();
                String newLocation = new URL(confidential ? "https" : reqProtocol, wsdlHost, port = confidential ? this.getPortForProtocol("https") : this.getPortForProtocol(reqProtocol), path = orgURL.getPath()).toString();
                if (newLocation.equals(orgLocation)) continue;
                locationAttr.setNodeValue(newLocation);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Mapping address from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            this.modifyAddressReferences(reqURL, wsdlHost, resPath, childElement);
        }
    }

    private static boolean isHttp(String orgLocation) {
        try {
            String scheme = new URI(orgLocation).getScheme();
            if (scheme != null && scheme.startsWith("http")) {
                return true;
            }
            log.info((Object)("Skipping rewrite of non-http address: " + orgLocation));
            return false;
        }
        catch (URISyntaxException e) {
            log.error((Object)("Skipping rewrite of invalid address: " + orgLocation), (Throwable)e);
            return false;
        }
    }

    private int getPortForProtocol(String protocol) {
        String lowerCasedProtocol = protocol.toLowerCase();
        if ("http".equals(lowerCasedProtocol)) {
            return this.config.getWebServicePort();
        }
        if ("https".equals(lowerCasedProtocol)) {
            return this.config.getWebServiceSecurePort();
        }
        return -1;
    }
}

