/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.soap.MessageFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageUnMarshaller
implements UnMarshaller {
    private static Logger log = Logger.getLogger(SOAPMessageUnMarshaller.class);

    @Override
    public Object read(InputStream inputStream, Map<String, Object> metadata) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        try {
            SOAPMessage soapMsg = this.getMessageFactory().createMessage(null, inputStream, true);
            return soapMsg;
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot unmarshall SOAPMessage", (Throwable)e);
            IOException e2 = new IOException(e.toString());
            e2.initCause(e);
            throw e2;
        }
    }

    protected MessageFactoryImpl getMessageFactory() {
        return new MessageFactoryImpl();
    }
}

