/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;

public class ReturnTypeUnwrapper {
    public JBossXSModel xsmodel;
    public QName xmlType;
    public XSElementDeclaration unwrappedElement;
    public boolean array = false;
    public boolean primitive = false;
    private boolean wrapped;

    public ReturnTypeUnwrapper(QName xmlType, JBossXSModel xsmodel, boolean wrapped) {
        this.xmlType = xmlType;
        this.xsmodel = xsmodel;
        this.wrapped = wrapped;
    }

    public boolean unwrap() {
        boolean hasAttributes;
        if (!this.wrapped) {
            return false;
        }
        XSTypeDefinition xt = this.xsmodel.getTypeDefinition(this.xmlType.getLocalPart(), this.xmlType.getNamespaceURI());
        if (!(xt instanceof XSComplexTypeDefinition)) {
            throw new WSException("[JAX-RPC 2.3.1.2] Tried to unwrap a non-complex type.");
        }
        XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
        boolean bl = hasAttributes = wrapper.getAttributeUses().getLength() > 0;
        if (hasAttributes) {
            throw new WSException("[JAX-RPC 2.3.1.2] Can not unwrap, complex type contains attributes.");
        }
        boolean unwrapped = false;
        XSParticle particle = wrapper.getParticle();
        if (particle != null) {
            XSTerm term = particle.getTerm();
            if (!(term instanceof XSModelGroup)) {
                throw new WSException("[JAX-RPC 2.3.1.2] Expected model group, could not unwrap");
            }
            XSModelGroup group = (XSModelGroup)term;
            unwrapped = this.unwrapModelGroup(group);
        }
        return unwrapped;
    }

    private boolean unwrapModelGroup(XSModelGroup group) {
        XSObjectList particles = group.getParticles();
        if (particles.getLength() == 1) {
            XSParticle particle = (XSParticle)particles.item(0);
            boolean array = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                return this.unwrapModelGroup((XSModelGroup)term);
            }
            if (term instanceof XSElementDeclaration) {
                this.unwrappedElement = (XSElementDeclaration)term;
                XSTypeDefinition type = this.unwrappedElement.getTypeDefinition();
                if (!type.getAnonymous()) {
                    this.xmlType = new QName(this.unwrappedElement.getTypeDefinition().getNamespace(), this.unwrappedElement.getTypeDefinition().getName());
                }
                this.array = array;
                this.primitive = !this.unwrappedElement.getNillable() && (particle.getMinOccurs() != 0 || particle.getMaxOccurs() != 1);
            }
        } else {
            throw new WSException("[JAX-RPC 2.3.1.2] Unable to unwrap model group with multiple particles.");
        }
        return this.unwrappedElement != null;
    }
}

