/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.measurement.MeasurementDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="AlertCondition.findByTriggerId", query="SELECT a FROM AlertCondition AS a WHERE a.triggerId = :tid"), @NamedQuery(name="AlertCondition.findAll", query="SELECT a FROM AlertCondition AS a"), @NamedQuery(name="AlertCondition.deleteByResources", query="DELETE FROM AlertCondition ac WHERE ac.alertDefinition IN ( SELECT ad FROM AlertDefinition ad WHERE ad.resource.id IN ( :resourceIds ) )"), @NamedQuery(name="AlertCondition.byCategoryBaseline", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionBaselineCategoryComposite        (          ac,          ms.id,          mb.id,          mb.baselineMin,          mb.baselineMean,          mb.baselineMax        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res     JOIN ac.measurementDefinition md, MeasurementSchedule ms JOIN ms.baseline mb    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ms.definition = md      AND ms.resource = res      AND mb IS NOT NULL      AND ac.category = 'BASELINE' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryCountBaseline", query="  SELECT count(ac.id)     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res     JOIN ac.measurementDefinition md, MeasurementSchedule ms JOIN ms.baseline mb    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ms.definition = md      AND ms.resource = res      AND mb IS NOT NULL      AND ac.category = 'BASELINE' "), @NamedQuery(name="AlertCondition.byCategoryChange", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionChangesCategoryComposite        (          ac,          ms.id        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res     JOIN ac.measurementDefinition md, MeasurementSchedule ms    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ms.definition = md      AND ms.resource = res      AND ac.category = 'CHANGE' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryTrait", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionTraitCategoryComposite        (          ac,          ms.id,          (           SELECT md.value              FROM MeasurementDataTrait md             WHERE md.schedule = ms               AND md.id.timestamp =                 (                   SELECT max(imd.id.timestamp)                     FROM MeasurementDataTrait imd                    WHERE ms.id = imd.schedule.id                 )          )        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res     JOIN ac.measurementDefinition md, MeasurementSchedule ms    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ms.definition = md      AND ms.resource = res      AND ac.category = 'TRAIT' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryAvailability", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionAvailabilityCategoryComposite        (          ac,          res.id,          (           SELECT a.availabilityType              FROM Availability a              JOIN a.resource ar             WHERE ar = res               AND a.endTime IS NULL          )        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ac.category = 'AVAILABILITY' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryControl", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionControlCategoryComposite        (          ac,          res.id,          (           SELECT op.id              FROM OperationDefinition op             WHERE op.resourceType = type               AND op.name = ac.name          )        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res     JOIN res.resourceType type    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ac.category = 'CONTROL' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryThreshold", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionScheduleCategoryComposite        (          ac,          ms.id        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res     JOIN ac.measurementDefinition md, MeasurementSchedule ms    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ms.definition = md      AND ms.resource = res      AND ac.category = 'THRESHOLD' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryEvent", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionEventCategoryComposite        (          ac,          res.id        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ac.category = 'EVENT' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryResourceConfig", query="  SELECT new org.rhq.core.domain.alert.composite.AlertConditionResourceConfigurationCategoryComposite        (          ac,          res.id,          resConfig        )     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res     LEFT JOIN res.resourceConfiguration resConfig    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ac.category = 'RESOURCE_CONFIG' ORDER BY ac.id"), @NamedQuery(name="AlertCondition.byCategoryCountParameterized", query="  SELECT count(ac.id)     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res    WHERE  ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   )      AND ( res.agent.id = :agentId OR :agentId IS NULL )      AND ad.enabled = TRUE      AND ad.deleted = FALSE      AND ac.category = :category "), @NamedQuery(name="AlertCondition.findResourceStatus", query="  SELECT res.inventoryStatus     FROM AlertCondition AS ac     JOIN ac.alertDefinition ad     JOIN ad.resource res    WHERE ac.id = :alertConditionId ")})
@SequenceGenerator(name="RHQ_ALERT_CONDITION_ID_SEQ", sequenceName="RHQ_ALERT_CONDITION_ID_SEQ")
@Table(name="RHQ_ALERT_CONDITION")
public class AlertCondition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertCondition.deleteByResources";
    public static final String QUERY_BY_CATEGORY_BASELINE = "AlertCondition.byCategoryBaseline";
    public static final String QUERY_BY_CATEGORY_CHANGE = "AlertCondition.byCategoryChange";
    public static final String QUERY_BY_CATEGORY_TRAIT = "AlertCondition.byCategoryTrait";
    public static final String QUERY_BY_CATEGORY_AVAILABILITY = "AlertCondition.byCategoryAvailability";
    public static final String QUERY_BY_CATEGORY_CONTROL = "AlertCondition.byCategoryControl";
    public static final String QUERY_BY_CATEGORY_THRESHOLD = "AlertCondition.byCategoryThreshold";
    public static final String QUERY_BY_CATEGORY_EVENT = "AlertCondition.byCategoryEvent";
    public static final String QUERY_BY_CATEGORY_RESOURCE_CONFIG = "AlertCondition.byCategoryResourceConfig";
    public static final String QUERY_BY_CATEGORY_COUNT_BASELINE = "AlertCondition.byCategoryCountBaseline";
    public static final String QUERY_BY_CATEGORY_COUNT_PARAMETERIZED = "AlertCondition.byCategoryCountParameterized";
    public static final String QUERY_FIND_RESOURCE_STATUS_BY_CONDITION_ID = "AlertCondition.findResourceStatus";
    public static final String RECOVERY_CONDITIONAL_EXPRESSION = " ( ad.recoveryId = 0  OR ( ad.recoveryId <> 0       AND EXISTS ( SELECT iad FROM AlertDefinition iad                     WHERE iad.id = ad.recoveryId                       AND iad.deleted = FALSE                       AND iad.enabled = FALSE                  )      )   ) ";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ALERT_CONDITION_ID_SEQ")
    @Id
    private int id;
    @Column(name="TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AlertConditionCategory category;
    @JoinColumn(name="MEASUREMENT_DEFINITION_ID", referencedColumnName="ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private MeasurementDefinition measurementDefinition;
    @Column(name="NAME")
    private String name;
    @Column(name="COMPARATOR")
    private String comparator;
    @Column(name="THRESHOLD")
    private Double threshold;
    @Column(name="OPTION_STATUS")
    private String option;
    @Column(name="TRIGGER_ID")
    private Integer triggerId;
    @JoinColumn(name="ALERT_DEFINITION_ID", referencedColumnName="ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private AlertDefinition alertDefinition;
    @OneToMany(mappedBy="condition", cascade={CascadeType.ALL})
    @OrderBy
    private Set<AlertConditionLog> conditionLogs = new LinkedHashSet<AlertConditionLog>();

    public AlertCondition() {
    }

    public AlertCondition(AlertDefinition alertDef, AlertConditionCategory type) {
        this.alertDefinition = alertDef;
        this.category = type;
    }

    public AlertCondition(AlertCondition cond, boolean copyIds) {
        if (copyIds) {
            this.id = cond.id;
        }
        this.category = cond.category;
        this.measurementDefinition = cond.measurementDefinition;
        this.name = cond.name;
        this.comparator = cond.comparator;
        this.threshold = cond.threshold;
        this.option = cond.option;
        this.triggerId = cond.triggerId;
    }

    public int getId() {
        return this.id;
    }

    public AlertConditionCategory getCategory() {
        return this.category;
    }

    public void setCategory(AlertConditionCategory category) {
        this.category = category;
    }

    public MeasurementDefinition getMeasurementDefinition() {
        return this.measurementDefinition;
    }

    public void setMeasurementDefinition(MeasurementDefinition measurementDefinition) {
        this.measurementDefinition = measurementDefinition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public Integer getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(Integer triggerId) {
        this.triggerId = triggerId;
    }

    public AlertDefinition getAlertDefinition() {
        return this.alertDefinition;
    }

    public void setAlertDefinition(AlertDefinition alertDef) {
        this.alertDefinition = alertDef;
    }

    public Set<AlertConditionLog> getConditionLogs() {
        return this.conditionLogs;
    }

    public void addConditionLog(AlertConditionLog condLog) {
        this.conditionLogs.add(condLog);
        condLog.setCondition(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertCondition)) {
            return false;
        }
        AlertCondition other = (AlertCondition)obj;
        if (this.category == null ? other.category != null : !this.category.equals((Object)other.category)) {
            return false;
        }
        if (this.comparator == null ? other.comparator != null : !this.comparator.equals(other.comparator)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.option == null ? other.option != null : !this.option.equals(other.option)) {
            return false;
        }
        return !(this.threshold == null ? other.threshold != null : !this.threshold.equals(other.threshold));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.comparator == null ? 0 : this.comparator.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.option == null ? 0 : this.option.hashCode());
        result = 31 * result + (this.threshold == null ? 0 : this.threshold.hashCode());
        return result;
    }

    public String toString() {
        return "org.rhq.core.domain.alert.AlertCondition[ id=" + this.id + ", " + "category=" + (Object)((Object)this.category) + ", " + "name=" + this.name + ", " + "comparator='" + this.comparator + "', " + "threshold=" + this.threshold + ", " + "option=" + this.option + " ]";
    }
}

