/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDampeningEvent;
import org.rhq.core.domain.alert.AlertDefinitionContext;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="AlertDefinition.findAll", query="SELECT a   FROM AlertDefinition a  WHERE a.deleted = false    AND a.resource IS NOT NULL"), @NamedQuery(name="AlertDefinition.findAllByRecoveryDefinitionId", query="SELECT a   FROM AlertDefinition a   LEFT JOIN FETCH a.conditions  WHERE a.deleted = false AND a.enabled = true    AND a.recoveryId = :recoveryDefinitionId"), @NamedQuery(name="AlertDefinition.findByAlertTemplateId", query="SELECT a.id   FROM AlertDefinition a  WHERE a.parentId = :alertTemplateId    AND a.deleted = false   AND a.readOnly = false"), @NamedQuery(name="AlertDefinition.findByGroupAlertDefinitionId", query="SELECT a.id   FROM AlertDefinition a  WHERE a.groupAlertDefinition.id = :groupAlertDefinitionId    AND a.deleted = false   AND a.readOnly = false"), @NamedQuery(name="AlertDefinition.findResourceIdsNeedingTemplateApplication", query="SELECT res.id   FROM Resource res  WHERE res.resourceType.id = :resourceTypeId    AND res.inventoryStatus = :inventoryStatus    AND NOT EXISTS ( SELECT ad.id                       FROM AlertDefinition ad                      WHERE ad.parentId = :alertTemplateId                        AND ad.resource.id = res.id                        AND ad.deleted = false ) "), @NamedQuery(name="AlertDefinition.findOptionItemsByResource", query="  SELECT new org.rhq.core.domain.common.composite.IntegerOptionItem(ad.id, ad.name)     FROM AlertDefinition ad    WHERE ad.resource.id = :resourceId      AND ad.deleted = false"), @NamedQuery(name="AlertDefinition.findByResource", query="SELECT a   FROM AlertDefinition a  WHERE a.resource.id = :id    AND a.deleted = false"), @NamedQuery(name="AlertDefinition.findByResourceType", query="SELECT a   FROM AlertDefinition a  WHERE a.resourceType.id = :typeId    AND a.deleted = false"), @NamedQuery(name="AlertDefinition.findByResourceGroup", query="SELECT a   FROM AlertDefinition a  WHERE a.resourceGroup.id = :groupId    AND a.deleted = false"), @NamedQuery(name="AlertDefinition.deleteByResources", query="DELETE FROM AlertDefinition ad  WHERE ad.resource.id IN ( :resourceIds ) "), @NamedQuery(name="AlertDefinition.findUnusedDefinitionIds", query="SELECT ad.id   FROM AlertDefinition ad  WHERE ad.deleted = TRUE    AND ad.id NOT IN ( SELECT alertDef.id                         FROM Alert a                         JOIN a.alertDefinition alertDef )"), @NamedQuery(name="AlertDefinition.findAllComposites_admin", query="   SELECT new org.rhq.core.domain.alert.composite.AlertDefinitionComposite        ( ad, parent.id, parent.name )      FROM AlertDefinition ad LEFT JOIN ad.resource res LEFT JOIN res.parentResource parent     WHERE ad.deleted = false       AND (UPPER(res.name) LIKE :resourceFilter OR :resourceFilter IS NULL)       AND (UPPER(parent.name) LIKE :parentFilter OR :parentFilter IS NULL)       AND (ad.ctime > :startTime OR :startTime IS NULL)       AND (ad.ctime < :endTime OR :endTime IS NULL)       AND (ad.id IN ( SELECT aad.id FROM AlertDefinition aad                        JOIN aad.conditions aadc                       WHERE aadc.category = :category )            OR :category IS NULL) "), @NamedQuery(name="AlertDefinition.findAllComposites", query="   SELECT new org.rhq.core.domain.alert.composite.AlertDefinitionComposite        ( ad, parent.id, parent.name )      FROM AlertDefinition ad LEFT JOIN ad.resource res LEFT JOIN res.parentResource parent     WHERE ad.deleted = false       AND res.id IN ( SELECT rr.id FROM Resource rr                         JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s                        WHERE s.id = :subjectId )       AND (UPPER(res.name) LIKE :resourceFilter OR :resourceFilter IS NULL)       AND (UPPER(parent.name) LIKE :parentFilter OR :parentFilter IS NULL)       AND (ad.ctime > :startTime OR :startTime IS NULL)       AND (ad.ctime < :endTime OR :endTime IS NULL)       AND (ad.id IN ( SELECT aad.id FROM AlertDefinition aad                        JOIN aad.conditions aadc                       WHERE aadc.category = :category )            OR :category IS NULL) "), @NamedQuery(name="AlertDefinition.findDefinitionIdByConditionId", query="SELECT ac.alertDefinition.id   FROM AlertCondition ac  WHERE ac.id = :alertConditionId "), @NamedQuery(name="AlertDefinition.isEnabled", query="SELECT ad.id   FROM AlertDefinition ad  WHERE ad.id = :alertDefinitionId    AND ad.enabled = true "), @NamedQuery(name="AlertDefinition.isTemplate", query="SELECT ad.id   FROM AlertDefinition ad  WHERE ad.id = :alertDefinitionId    AND ad.resourceType IS NOT NULL "), @NamedQuery(name="AlertDefinition.isGroupAlertDefinition", query="SELECT ad.id   FROM AlertDefinition ad  WHERE ad.id = :alertDefinitionId    AND ad.resourceGroup IS NOT NULL "), @NamedQuery(name="AlertDefinition.updateSetDeleted", query="UPDATE AlertDefinition ad    SET ad.deleted = TRUE  WHERE ad.id IN ( :groupAlertDefinitionIds )     OR ad.groupAlertDefinition.id IN ( :groupAlertDefinitionIds ) "), @NamedQuery(name="AlertDefinition.updateSetEnabled", query="UPDATE AlertDefinition ad    SET ad.enabled = TRUE  WHERE ad.id IN ( :groupAlertDefinitionIds )     OR ad.groupAlertDefinition.id IN ( :groupAlertDefinitionIds ) "), @NamedQuery(name="AlertDefinition.updateSetDisabled", query="UPDATE AlertDefinition ad    SET ad.enabled = FALSE  WHERE ad.id IN ( :groupAlertDefinitionIds )     OR ad.groupAlertDefinition.id IN ( :groupAlertDefinitionIds ) "), @NamedQuery(name="AlertDefinition.updateSetParentsNull", query="UPDATE AlertDefinition ad    SET ad.groupAlertDefinition = NULL  WHERE ad.id IN ( :childrenDefinitionIds ) "), @NamedQuery(name="AlertDefinition.findResourceIdsNeedingGroupApplication", query="SELECT res.id   FROM Resource res   JOIN res.explicitGroups rg  WHERE rg.id = :resourceGroupId    AND res.inventoryStatus = :inventoryStatus    AND NOT EXISTS ( SELECT ad.id                       FROM AlertDefinition ad                      WHERE ad.groupAlertDefinition.id = :groupAlertDefinitionId                        AND ad.resource.id = res.id                        AND ad.deleted = false ) ")})
@SequenceGenerator(name="RHQ_ALERT_DEFINITION_ID_SEQ", sequenceName="RHQ_ALERT_DEFINITION_ID_SEQ", allocationSize=10)
@Table(name="RHQ_ALERT_DEFINITION")
public class AlertDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "AlertDefinition.findAll";
    public static final String QUERY_FIND_ALL_BY_RECOVERY_DEFINITION_ID = "AlertDefinition.findAllByRecoveryDefinitionId";
    public static final String QUERY_FIND_BY_ALERT_TEMPLATE_ID = "AlertDefinition.findByAlertTemplateId";
    public static final String QUERY_FIND_BY_GROUP_ALERT_DEFINITION_ID = "AlertDefinition.findByGroupAlertDefinitionId";
    public static final String QUERY_FIND_RESOURCE_IDS_NEEDING_TEMPLATE_APPLICATION = "AlertDefinition.findResourceIdsNeedingTemplateApplication";
    public static final String QUERY_FIND_OPTION_ITEMS_BY_RESOURCE = "AlertDefinition.findOptionItemsByResource";
    public static final String QUERY_FIND_BY_RESOURCE = "AlertDefinition.findByResource";
    public static final String QUERY_FIND_BY_RESOURCE_TYPE = "AlertDefinition.findByResourceType";
    public static final String QUERY_FIND_BY_RESOURCE_GROUP = "AlertDefinition.findByResourceGroup";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertDefinition.deleteByResources";
    public static final String QUERY_FIND_UNUSED_DEFINITION_IDS = "AlertDefinition.findUnusedDefinitionIds";
    public static final String QUERY_FIND_DEFINITION_ID_BY_CONDITION_ID = "AlertDefinition.findDefinitionIdByConditionId";
    public static final String QUERY_IS_ENABLED = "AlertDefinition.isEnabled";
    public static final String QUERY_IS_TEMPLATE = "AlertDefinition.isTemplate";
    public static final String QUERY_IS_GROUP_ALERT_DEFINITION = "AlertDefinition.isGroupAlertDefinition";
    public static final String QUERY_UPDATE_SET_DELETED = "AlertDefinition.updateSetDeleted";
    public static final String QUERY_UPDATE_SET_ENABLED = "AlertDefinition.updateSetEnabled";
    public static final String QUERY_UPDATE_SET_DISABLED = "AlertDefinition.updateSetDisabled";
    public static final String QUERY_UPDATE_SET_PARENTS_NULL = "AlertDefinition.updateSetParentsNull";
    public static final String QUERY_FIND_RESOURCE_IDS_NEEDING_GROUP_APPLICATION = "AlertDefinition.findResourceIdsNeedingGroupApplication";
    public static final String QUERY_FIND_ALL_COMPOSITES = "AlertDefinition.findAllComposites";
    public static final String QUERY_FIND_ALL_COMPOSITES_ADMIN = "AlertDefinition.findAllComposites_admin";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ALERT_DEFINITION_ID_SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="CTIME", nullable=false)
    private long ctime;
    @Column(name="MTIME", nullable=false)
    private long mtime;
    @Column(name="PARENT_ID", nullable=false)
    private Integer parentId = new Integer(0);
    @JoinColumn(name="GROUP_ALERT_DEF_ID")
    @ManyToOne
    private AlertDefinition groupAlertDefinition;
    @OneToMany(mappedBy="groupAlertDefinition", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @OrderBy
    private Set<AlertDefinition> groupAlertDefinitionChildren = new LinkedHashSet<AlertDefinition>();
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="PRIORITY", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AlertPriority priority;
    @JoinColumn(name="RESOURCE_TYPE_ID", nullable=true)
    @ManyToOne
    private ResourceType resourceType;
    @JoinColumn(name="RESOURCE_ID", nullable=true)
    @ManyToOne
    private Resource resource;
    @JoinColumn(name="RESOURCE_GROUP_ID", nullable=true)
    @ManyToOne
    private ResourceGroup resourceGroup;
    @Column(name="ENABLED", nullable=false)
    private boolean enabled;
    @Embedded
    private AlertDampening alertDampening;
    @Column(name="RECOVERY_ID")
    private Integer recoveryId;
    @Column(name="WILL_RECOVER", nullable=false)
    private boolean willRecover;
    @Column(name="NOTIFY_FILTERED", nullable=false)
    private boolean notifyFiltered;
    @Column(name="CONTROL_FILTERED", nullable=false)
    private boolean controlFiltered;
    @Column(name="DELETED", nullable=false)
    private boolean deleted;
    @Column(name="READ_ONLY", nullable=false)
    private boolean readOnly;
    @Column(name="REQUIRED", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private BooleanExpression conditionExpression;
    @OneToMany(mappedBy="alertDefinition", cascade={CascadeType.ALL})
    @OrderBy
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<AlertCondition> conditions = new LinkedHashSet<AlertCondition>(1);
    @OneToMany(mappedBy="alertDefinition", cascade={CascadeType.ALL})
    @OrderBy
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<AlertNotification> alertNotifications = new HashSet<AlertNotification>();
    @JoinColumn(name="OPERATION_DEF_ID", nullable=true)
    @ManyToOne
    private OperationDefinition operationDefinition;
    @OneToMany(mappedBy="alertDefinition", cascade={CascadeType.REFRESH, CascadeType.REMOVE})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<AlertDampeningEvent> alertDampeningEvents = new HashSet<AlertDampeningEvent>();
    @OneToMany(mappedBy="alertDefinition", cascade={CascadeType.REMOVE})
    @OrderBy
    private Set<Alert> alerts = new LinkedHashSet<Alert>();
    private transient AlertDefinitionContext context;

    public AlertDefinition() {
    }

    public AlertDefinition(AlertDefinition alertDef) {
        this();
        this.update(alertDef, false);
    }

    public AlertDefinition(AlertDefinition alertDef, boolean copyIds) {
        this();
        this.update(alertDef, copyIds);
    }

    public void update(AlertDefinition alertDef, boolean copyIds) {
        this.name = alertDef.name;
        this.description = alertDef.description;
        this.priority = alertDef.priority;
        this.enabled = alertDef.enabled;
        this.readOnly = alertDef.readOnly;
        if (this.alertDampening == null) {
            this.alertDampening = new AlertDampening(alertDef.getAlertDampening());
        } else {
            this.alertDampening.update(alertDef.getAlertDampening());
        }
        this.willRecover = alertDef.willRecover;
        this.notifyFiltered = alertDef.notifyFiltered;
        this.controlFiltered = alertDef.controlFiltered;
        this.deleted = alertDef.deleted;
        this.conditionExpression = alertDef.conditionExpression;
        this.recoveryId = alertDef.recoveryId;
        HashSet<AlertCondition> copiedConditions = new HashSet<AlertCondition>();
        for (AlertCondition oldCondition : alertDef.getConditions()) {
            AlertCondition newCondition = new AlertCondition(oldCondition, copyIds);
            newCondition.setAlertDefinition(this);
            copiedConditions.add(newCondition);
        }
        this.removeAllConditions();
        this.getConditions().addAll(copiedConditions);
        HashSet<AlertNotification> copiedNotifications = new HashSet<AlertNotification>();
        for (AlertNotification oldNotification : new HashSet<AlertNotification>(alertDef.getAlertNotifications())) {
            AlertNotification newNotification = oldNotification.copy(copyIds);
            newNotification.setAlertDefinition(this);
            copiedNotifications.add(newNotification);
        }
        this.removeAllAlertNotifications();
        this.getAlertNotifications().addAll(copiedNotifications);
        this.operationDefinition = alertDef.operationDefinition;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCtime() {
        return this.ctime;
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = System.currentTimeMillis();
    }

    public long getMtime() {
        return this.mtime;
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public AlertDefinition getGroupAlertDefinition() {
        return this.groupAlertDefinition;
    }

    public void setGroupAlertDefinition(AlertDefinition groupAlertDefinition) {
        this.groupAlertDefinition = groupAlertDefinition;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.resource.getAlertDefinitions().add(this);
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public void setResourceGroup(ResourceGroup resourceGroup) {
        this.resourceGroup = resourceGroup;
        if (this.resourceGroup != null) {
            this.resourceGroup.getAlertDefinitions().add(this);
        }
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AlertPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AlertPriority priority) {
        this.priority = priority;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public AlertDampening getAlertDampening() {
        return this.alertDampening;
    }

    public void setAlertDampening(AlertDampening alertDampening) {
        this.alertDampening = alertDampening;
    }

    public boolean getWillRecover() {
        return this.willRecover;
    }

    public void setWillRecover(boolean willRecover) {
        if (willRecover && this.getRecoveryId() != 0) {
            throw new IllegalStateException("An alert definition can either be a recovery definition or a definition to-be-recovered, but not both.");
        }
        this.willRecover = willRecover;
    }

    public boolean getNotifyFiltered() {
        return this.notifyFiltered;
    }

    public void setNotifyFiltered(boolean notifyFiltered) {
        this.notifyFiltered = notifyFiltered;
    }

    public boolean getControlFiltered() {
        return this.controlFiltered;
    }

    public void setControlFiltered(boolean controlFiltered) {
        this.controlFiltered = controlFiltered;
    }

    public Integer getRecoveryId() {
        return this.recoveryId;
    }

    public void setRecoveryId(Integer actOnTriggerId) {
        if (this.getWillRecover() && actOnTriggerId != 0) {
            throw new IllegalStateException("An alert definition can either be a recovery definition or a definition to-be-recovered, but not both.");
        }
        this.recoveryId = actOnTriggerId;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public BooleanExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(BooleanExpression conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public Set<AlertCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Set<AlertCondition> conditions) {
        this.conditions.clear();
        for (AlertCondition condition : conditions) {
            this.addCondition(condition);
        }
    }

    public void addCondition(AlertCondition condition) {
        this.conditions.add(condition);
        condition.setAlertDefinition(this);
    }

    public void removeAllConditions() {
        for (AlertCondition condition : this.conditions) {
            condition.setAlertDefinition(null);
        }
        this.conditions.clear();
    }

    public Set<Alert> getAlerts() {
        return this.alerts;
    }

    public void addAlert(Alert alert) {
        this.alerts.add(alert);
    }

    public Set<AlertNotification> getAlertNotifications() {
        return this.alertNotifications;
    }

    public void setAlertNotifications(Set<AlertNotification> alertNotifications) {
        this.alertNotifications = alertNotifications;
    }

    public void addAlertNotification(AlertNotification alertNotification) {
        this.alertNotifications.add(alertNotification);
    }

    public void removeAllAlertNotifications() {
        ArrayList<AlertNotification> toBeRemoved = new ArrayList<AlertNotification>(this.alertNotifications);
        for (AlertNotification notification : toBeRemoved) {
            notification.prepareForOrphanDelete();
        }
        this.alertNotifications.clear();
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    public void setOperationDefinition(OperationDefinition operationDefinition) {
        this.operationDefinition = operationDefinition;
    }

    public Set<AlertDampeningEvent> getAlertDampeningEvents() {
        return this.alertDampeningEvents;
    }

    public boolean removeAlertDampeningEvent(AlertDampeningEvent event) {
        return this.alertDampeningEvents.remove(event);
    }

    public void calculateContext() {
        this.context = AlertDefinitionContext.get(this);
    }

    public void setContext(AlertDefinitionContext context) {
        this.context = context;
    }

    public AlertDefinitionContext getContext() {
        if (this.context == null) {
            this.calculateContext();
        }
        return this.context;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AlertDefinition)) {
            return false;
        }
        AlertDefinition that = (AlertDefinition)obj;
        if (this.id != that.id) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toSimpleString() {
        return "AlertDefinition[ id=" + this.id + ", " + "name=" + this.name + " ]";
    }

    public String toString() {
        return "org.rhq.core.domain.alert.AlertDefinition[ id=" + this.id + ", " + "name=" + this.name + ", " + "conditionExpression=" + (Object)((Object)this.conditionExpression) + ", " + "priority=" + (Object)((Object)this.priority) + ", " + (this.resource != null ? "resourceId=" + this.resource.getId() : "") + (this.resourceType != null ? "resourceTypeId=" + this.resourceType.getId() : "") + " ]";
    }
}

