/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.cloud;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.cloud.PartitionEvent;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.resource.Agent;

@Entity(name="PartitionEventDetails")
@NamedQueries(value={@NamedQuery(name="PartitionEventDetails.findByEventId", query="SELECT ped   FROM PartitionEventDetails ped  WHERE ped.partitionEvent.id = :eventId ")})
@SequenceGenerator(name="id", sequenceName="RHQ_PARTITION_DETAILS_ID_SEQ")
@Table(name="RHQ_PARTITION_DETAILS")
public class PartitionEventDetails
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_EVENT_ID = "PartitionEventDetails.findByEventId";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    @Id
    private int id;
    @JoinColumn(name="PARTITION_EVENT_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    protected PartitionEvent partitionEvent;
    @Column(name="AGENT_NAME", nullable=false)
    protected String agentName;
    @Column(name="SERVER_NAME", nullable=false)
    protected String serverName;

    protected PartitionEventDetails() {
    }

    public PartitionEventDetails(PartitionEvent partitionEvent, Agent agent, Server server) {
        this.partitionEvent = partitionEvent;
        this.agentName = agent.getName();
        this.serverName = server.getName();
    }

    public PartitionEvent getPartitionEvent() {
        return this.partitionEvent;
    }

    public void setPartitionEvent(PartitionEvent partitionEvent) {
        this.partitionEvent = partitionEvent;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.agentName == null ? 0 : this.agentName.hashCode());
        result = 31 * result + (this.partitionEvent == null ? 0 : this.partitionEvent.hashCode());
        result = 31 * result + (this.serverName == null ? 0 : this.serverName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PartitionEventDetails)) {
            return false;
        }
        PartitionEventDetails other = (PartitionEventDetails)obj;
        if (this.agentName == null ? other.agentName != null : !this.agentName.equals(other.agentName)) {
            return false;
        }
        if (this.serverName == null ? other.serverName != null : !this.serverName.equals(other.serverName)) {
            return false;
        }
        return !(this.partitionEvent == null ? other.partitionEvent != null : !this.partitionEvent.equals(other.partitionEvent));
    }
}

