/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.definition;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.IndexColumn;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionEnumeration;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.configuration.definition.constraint.Constraint;
import org.rhq.core.domain.measurement.MeasurementUnits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DiscriminatorValue(value="property")
@Entity(name="PropertyDefinitionSimple")
@XmlRootElement(name="PropertyDefinitionSimple")
public class PropertyDefinitionSimple
extends PropertyDefinition {
    private static final long serialVersionUID = 1L;
    @Column(name="SIMPLE_TYPE")
    @Enumerated(value=EnumType.STRING)
    private PropertySimpleType type;
    @Column(name="ALLOW_CUSTOM_ENUM_VALUE")
    private boolean allowCustomEnumeratedValue = false;
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OneToMany(mappedBy="propertyDefinitionSimple", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<Constraint> constraints;
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @IndexColumn(name="order_index")
    @OneToMany(mappedBy="propertyDefinitionSimple", fetch=FetchType.EAGER)
    private List<PropertyDefinitionEnumeration> enumeratedValues;
    @Deprecated
    @Column(name="DEFAULT_VALUE", length=2000)
    private String defaultValue;
    @Enumerated(value=EnumType.ORDINAL)
    private MeasurementUnits units;

    public PropertyDefinitionSimple(@NotNull String name, String description, boolean required, @NotNull PropertySimpleType type) {
        super(name, description, required);
        this.type = type;
    }

    protected PropertyDefinitionSimple() {
    }

    public PropertySimpleType getType() {
        return this.type;
    }

    public void setType(PropertySimpleType type) {
        this.type = type;
    }

    @NotNull
    public Set<Constraint> getConstraints() {
        if (this.constraints == null) {
            this.constraints = new LinkedHashSet<Constraint>();
        }
        return this.constraints;
    }

    public void setConstraints(Set<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            this.getConstraints().add(constraint);
            constraint.setPropertyDefinitionSimple(this);
        }
    }

    public void addConstraints(Constraint ... constraintsToAdd) {
        for (Constraint constraint : constraintsToAdd) {
            this.getConstraints().add(constraint);
            constraint.setPropertyDefinitionSimple(this);
        }
    }

    @NotNull
    public List<PropertyDefinitionEnumeration> getEnumeratedValues() {
        if (this.enumeratedValues == null) {
            this.enumeratedValues = new ArrayList<PropertyDefinitionEnumeration>();
        }
        return this.enumeratedValues;
    }

    public void setEnumeratedValues(List<PropertyDefinitionEnumeration> enumeratedValues, boolean allowCustomEnumValue) {
        this.enumeratedValues = enumeratedValues;
        this.allowCustomEnumeratedValue = allowCustomEnumValue;
    }

    public void addEnumeratedValues(PropertyDefinitionEnumeration ... enumerations) {
        for (PropertyDefinitionEnumeration enumeration : enumerations) {
            this.getEnumeratedValues().add(enumeration);
            enumeration.setPropertyDefinitionSimple(this);
        }
    }

    public boolean getAllowCustomEnumeratedValue() {
        return this.allowCustomEnumeratedValue;
    }

    public void setAllowCustomEnumeratedValue(boolean allowCustomEnumValue) {
        this.allowCustomEnumeratedValue = allowCustomEnumValue;
    }

    @Deprecated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Deprecated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public MeasurementUnits getUnits() {
        return this.units;
    }

    public void setUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public String toString() {
        return "SimpleProperty[" + this.getName() + "] (Type: " + (Object)((Object)this.getType()) + ")" + (this.getPropertyGroupDefinition() != null ? "(Group: " + this.getPropertyGroupDefinition().getName() + ")" : "");
    }
}

