/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.ChannelContentSource;
import org.rhq.core.domain.content.ChannelPackageVersion;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.ResourceChannel;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Channel.findAll", query="SELECT c FROM Channel c"), @NamedQuery(name="Channel.findByIds", query="SELECT c FROM Channel c WHERE c.id IN ( :ids )"), @NamedQuery(name="Channel.findByName", query="SELECT c FROM Channel c WHERE c.name = :name"), @NamedQuery(name="Channel.findByContentSourceIdFetchCCS", query="SELECT c FROM Channel c LEFT JOIN FETCH c.channelContentSources ccs WHERE ccs.contentSource.id = :id"), @NamedQuery(name="Channel.findByContentSourceId", query="SELECT c FROM Channel c LEFT JOIN c.channelContentSources ccs WHERE ccs.contentSource.id = :id"), @NamedQuery(name="Channel.findSubscriberResources", query="SELECT rc.resource FROM ResourceChannel rc WHERE rc.channel.id = :id"), @NamedQuery(name="Channel.findChannelsByResourceId", query="SELECT c FROM ResourceChannel rc JOIN rc.channel c WHERE rc.resource.id = :resourceId "), @NamedQuery(name="Channel.findChannelCompositesByResourceId", query="SELECT new org.rhq.core.domain.content.composite.ChannelComposite( c, (SELECT COUNT(cpv.packageVersion) FROM ChannelPackageVersion cpv WHERE cpv.channel.id = c.id) ) FROM ResourceChannel rc JOIN rc.channel c LEFT JOIN c.channelPackageVersions pv WHERE rc.resource.id = :resourceId GROUP BY c, c.name, c.description, c.creationDate, c.lastModifiedDate"), @NamedQuery(name="Channel.findChannelCompositesByResourceId_count", query="SELECT COUNT( rc.channel ) FROM ResourceChannel rc WHERE rc.resource.id = :resourceId "), @NamedQuery(name="Channel.findAvailableChannelCompositesByResourceId", query="SELECT new org.rhq.core.domain.content.composite.ChannelComposite( c, (SELECT COUNT(cpv.packageVersion) FROM ChannelPackageVersion cpv WHERE cpv.channel.id = c.id) ) FROM Channel AS c WHERE c.id NOT IN ( SELECT rc.channel.id FROM ResourceChannel rc WHERE rc.resource.id = :resourceId ) GROUP BY c, c.name, c.description, c.creationDate, c.lastModifiedDate"), @NamedQuery(name="Channel.findAvailableChannelCompositesByResourceId_count", query="SELECT COUNT( c ) FROM Channel AS c WHERE c.id NOT IN ( SELECT rc.channel.id FROM ResourceChannel rc WHERE rc.resource.id = :resourceId ) ")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CHANNEL_ID_SEQ")
@Table(name="RHQ_CHANNEL")
public class Channel
implements Serializable {
    public static final String QUERY_FIND_ALL = "Channel.findAll";
    public static final String QUERY_FIND_BY_IDS = "Channel.findByIds";
    public static final String QUERY_FIND_BY_NAME = "Channel.findByName";
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID_FETCH_CCS = "Channel.findByContentSourceIdFetchCCS";
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID = "Channel.findByContentSourceId";
    public static final String QUERY_FIND_SUBSCRIBER_RESOURCES = "Channel.findSubscriberResources";
    public static final String QUERY_FIND_CHANNELS_BY_RESOURCE_ID = "Channel.findChannelsByResourceId";
    public static final String QUERY_FIND_CHANNEL_COMPOSITES_BY_RESOURCE_ID = "Channel.findChannelCompositesByResourceId";
    public static final String QUERY_FIND_CHANNEL_COMPOSITES_BY_RESOURCE_ID_COUNT = "Channel.findChannelCompositesByResourceId_count";
    public static final String QUERY_FIND_AVAILABLE_CHANNEL_COMPOSITES_BY_RESOURCE_ID = "Channel.findAvailableChannelCompositesByResourceId";
    public static final String QUERY_FIND_AVAILABLE_CHANNEL_COMPOSITES_BY_RESOURCE_ID_COUNT = "Channel.findAvailableChannelCompositesByResourceId_count";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="CREATION_TIME", nullable=false)
    private long creationDate;
    @Column(name="LAST_MODIFIED_TIME", nullable=false)
    private long lastModifiedDate;
    @OneToMany(mappedBy="channel", fetch=FetchType.LAZY)
    private Set<ResourceChannel> resourceChannels;
    @OneToMany(mappedBy="channel", fetch=FetchType.LAZY)
    private Set<ChannelContentSource> channelContentSources;
    @OneToMany(mappedBy="channel", fetch=FetchType.LAZY)
    private Set<ChannelPackageVersion> channelPackageVersions;

    public Channel() {
    }

    public Channel(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Set<ResourceChannel> getResourceChannels() {
        return this.resourceChannels;
    }

    public Set<Resource> getResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        if (this.resourceChannels != null) {
            for (ResourceChannel rc : this.resourceChannels) {
                resources.add(rc.getResourceChannelPK().getResource());
            }
        }
        return resources;
    }

    public ResourceChannel addResource(Resource resource) {
        if (this.resourceChannels == null) {
            this.resourceChannels = new HashSet<ResourceChannel>();
        }
        ResourceChannel mapping = new ResourceChannel(resource, this);
        this.resourceChannels.add(mapping);
        return mapping;
    }

    public ResourceChannel removeResource(Resource resource) {
        if (this.resourceChannels == null || resource == null) {
            return null;
        }
        ResourceChannel doomed = null;
        for (ResourceChannel rc : this.resourceChannels) {
            if (!resource.equals(rc.getResourceChannelPK().getResource())) continue;
            doomed = rc;
            break;
        }
        if (doomed != null) {
            this.resourceChannels.remove(doomed);
        }
        return doomed;
    }

    public Set<ChannelContentSource> getChannelContentSources() {
        return this.channelContentSources;
    }

    public Set<ContentSource> getContentSources() {
        HashSet<ContentSource> contentSources = new HashSet<ContentSource>();
        if (this.channelContentSources != null) {
            for (ChannelContentSource ccs : this.channelContentSources) {
                contentSources.add(ccs.getChannelContentSourcePK().getContentSource());
            }
        }
        return contentSources;
    }

    public ChannelContentSource addContentSource(ContentSource contentSource) {
        if (this.channelContentSources == null) {
            this.channelContentSources = new HashSet<ChannelContentSource>();
        }
        ChannelContentSource mapping = new ChannelContentSource(this, contentSource);
        this.channelContentSources.add(mapping);
        return mapping;
    }

    public ChannelContentSource removeContentSource(ContentSource contentSource) {
        if (this.channelContentSources == null || contentSource == null) {
            return null;
        }
        ChannelContentSource doomed = null;
        for (ChannelContentSource ccs : this.channelContentSources) {
            if (!contentSource.equals(ccs.getChannelContentSourcePK().getContentSource())) continue;
            doomed = ccs;
            break;
        }
        if (doomed != null) {
            this.channelContentSources.remove(doomed);
        }
        return doomed;
    }

    public Set<ChannelPackageVersion> getChannelPackageVersions() {
        return this.channelPackageVersions;
    }

    public Set<PackageVersion> getPackageVersions() {
        HashSet<PackageVersion> packageVersions = new HashSet<PackageVersion>();
        if (this.channelPackageVersions != null) {
            for (ChannelPackageVersion cpv : this.channelPackageVersions) {
                packageVersions.add(cpv.getChannelPackageVersionPK().getPackageVersion());
            }
        }
        return packageVersions;
    }

    public ChannelPackageVersion addPackageVersion(PackageVersion packageVersion) {
        if (this.channelPackageVersions == null) {
            this.channelPackageVersions = new HashSet<ChannelPackageVersion>();
        }
        ChannelPackageVersion mapping = new ChannelPackageVersion(this, packageVersion);
        this.channelPackageVersions.add(mapping);
        return mapping;
    }

    public ChannelPackageVersion removePackageVersion(PackageVersion packageVersion) {
        if (this.channelPackageVersions == null || packageVersion == null) {
            return null;
        }
        ChannelPackageVersion doomed = null;
        for (ChannelPackageVersion cpv : this.channelPackageVersions) {
            if (!packageVersion.equals(cpv.getChannelPackageVersionPK().getPackageVersion())) continue;
            doomed = cpv;
            break;
        }
        if (doomed != null) {
            this.channelPackageVersions.remove(doomed);
        }
        return doomed;
    }

    public String toString() {
        return "Channel: id=[" + this.id + "], name=[" + this.name + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @PrePersist
    void onPersist() {
        this.lastModifiedDate = this.creationDate = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.lastModifiedDate = System.currentTimeMillis();
    }
}

