/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.measurement.MeasurementSchedule;

@Entity
@NamedQueries(value={@NamedQuery(name="MeasurementBaseline.findBaselinesForResource", query="SELECT mb FROM MeasurementBaseline mb WHERE mb.schedule.resource.id = :resourceId"), @NamedQuery(name="MeasurementBaseline.findBaselineForResourceIdsAndDefinitionIds", query="SELECT mb FROM MeasurementBaseline mb WHERE mb.schedule.resource.id IN (:resourceIds) AND  mb.schedule.definition.id IN (:definitionIds)"), @NamedQuery(name="MeasurementBaseline.findByComputeTime", query="SELECT new org.rhq.core.domain.measurement.composite.MeasurementBaselineComposite(        mb.id, mb.baselineMin, mb.baselineMax, mb.baselineMean, sched.id        ) FROM MeasurementBaseline mb      LEFT JOIN mb.schedule sched      LEFT JOIN sched.definition def WHERE mb.computeTime = :computeTime   AND def.numericType = :numericType "), @NamedQuery(name="MeasurementBaseline.deleteByComputeTime", query="DELETE MeasurementBaseline bl  WHERE bl.computeTime < :timestamp "), @NamedQuery(name="MeasurementBaseline.deleteByResources", query="DELETE MeasurementBaseline bl WHERE bl.schedule IN ( SELECT ms FROM MeasurementSchedule ms WHERE ms.resource.id IN ( :resourceIds ) )")})
@SequenceGenerator(name="MEAS_BL_GEN", sequenceName="RHQ_MEASUREMENT_BLINE_ID_SEQ")
@Table(name="RHQ_MEASUREMENT_BLINE")
public class MeasurementBaseline
implements Serializable {
    public static final String QUERY_FIND_BY_RESOURCE = "MeasurementBaseline.findBaselinesForResource";
    public static final String QUERY_FIND_BY_RESOURCE_IDS_AND_DEF_IDS = "MeasurementBaseline.findBaselineForResourceIdsAndDefinitionIds";
    public static final String QUERY_FIND_BY_COMPUTE_TIME = "MeasurementBaseline.findByComputeTime";
    public static final String QUERY_DELETE_BY_COMPUTE_TIME = "MeasurementBaseline.deleteByComputeTime";
    public static final String QUERY_DELETE_BY_RESOURCES = "MeasurementBaseline.deleteByResources";
    public static final String QUERY_CALC_FIRST_AUTOBASELINE = "MeasurementBaseline.calcFirstAutoBaseline";
    public static final String QUERY_DELETE_EXISTING_AUTOBASELINES = "MeasurementBaseline.deleteExistingAutoBaseline";
    public static final String NATIVE_QUERY_CALC_FIRST_AUTOBASELINE_POSTGRES = "    INSERT INTO RHQ_MEASUREMENT_BLINE ( id, BL_MIN, BL_MAX, BL_MEAN, BL_COMPUTE_TIME, SCHEDULE_ID )          SELECT nextval('RHQ_MEASUREMENT_BLINE_ID_SEQ'),                 MIN(data1h.minvalue) AS bline_min,                 MAX(data1h.maxvalue) AS bline_max,                 AVG(data1h.value) AS bline_mean,                 ? AS bline_ts,                 data1h.SCHEDULE_ID AS bline_sched_id            FROM RHQ_MEASUREMENT_DATA_NUM_1H data1h       INNER JOIN RHQ_MEASUREMENT_SCHED sched               ON data1h.SCHEDULE_ID = sched.id       INNER JOIN RHQ_MEASUREMENT_DEF def              ON sched.definition = def.id LEFT OUTER JOIN RHQ_MEASUREMENT_BLINE bline              ON sched.id = bline.SCHEDULE_ID            WHERE ( def.numeric_type = 0 )             AND ( bline.id IS NULL )             AND ( data1h.TIME_STAMP BETWEEN ? AND ? )        GROUP BY data1h.SCHEDULE_ID          HAVING data1h.SCHEDULE_ID in ( SELECT mdata.SCHEDULE_ID                                           FROM RHQ_MEASUREMENT_DATA_NUM_1H mdata                                           WHERE mdata.TIME_STAMP <= ? )           LIMIT 100000 ";
    public static final String NATIVE_QUERY_CALC_FIRST_AUTOBASELINE_ORACLE = "    INSERT INTO RHQ_MEASUREMENT_BLINE ( id, BL_MIN, BL_MAX, BL_MEAN, BL_COMPUTE_TIME, SCHEDULE_ID )          SELECT RHQ_MEASUREMENT_BLINE_ID_SEQ.nextval,                 blMin, blMax, blAvg, coTime, schId            FROM ( SELECT MIN(data1h.minvalue) AS blMin,                          MAX(data1h.maxvalue) AS blMax,                          AVG(data1h.value) AS blAvg,                          ? as coTime,                          data1h.SCHEDULE_ID as schId                      FROM RHQ_MEASUREMENT_DATA_NUM_1H data1h               INNER JOIN RHQ_MEASUREMENT_SCHED sched                       ON data1h.SCHEDULE_ID = sched.id               INNER JOIN RHQ_MEASUREMENT_DEF def                       ON sched.definition = def.id          LEFT OUTER JOIN RHQ_MEASUREMENT_BLINE bline                       ON sched.id = bline.SCHEDULE_ID                     WHERE ( def.numeric_type = 0 )                      AND ( bline.id IS NULL )                      AND ( data1h.TIME_STAMP BETWEEN ? AND ? )                      AND ROWNUM < 100001                 GROUP BY data1h.SCHEDULE_ID                    HAVING data1h.SCHEDULE_ID in ( SELECT mdata.SCHEDULE_ID                                                    FROM RHQ_MEASUREMENT_DATA_NUM_1H mdata                                                   WHERE mdata.TIME_STAMP <= ? ) ) ";
    public static final String NATIVE_QUERY_CALC_FIRST_AUTOBASELINE_SQLSERVER = "    INSERT INTO RHQ_MEASUREMENT_BLINE ( BL_MIN, BL_MAX, BL_MEAN, BL_COMPUTE_TIME, SCHEDULE_ID )          SELECT MIN(data1h.minvalue) AS blMin,                 MAX(data1h.maxvalue) AS blMax,                 AVG(data1h.value) AS blAvg,                 ? as coTime,                 data1h.SCHEDULE_ID as schId             FROM RHQ_MEASUREMENT_DATA_NUM_1H data1h      INNER JOIN RHQ_MEASUREMENT_SCHED sched              ON data1h.SCHEDULE_ID = sched.id      INNER JOIN RHQ_MEASUREMENT_DEF def              ON sched.definition = def.id LEFT OUTER JOIN RHQ_MEASUREMENT_BLINE bline              ON sched.id = bline.SCHEDULE_ID            WHERE ( def.numeric_type = 0 )             AND ( bline.id IS NULL )             AND ( data1h.TIME_STAMP BETWEEN ? AND ? )        GROUP BY data1h.SCHEDULE_ID           HAVING data1h.SCHEDULE_ID in ( SELECT mdata.SCHEDULE_ID                                           FROM RHQ_MEASUREMENT_DATA_NUM_1H mdata                                          WHERE mdata.TIME_STAMP <= ? ) ";
    private static final long serialVersionUID = 1L;
    @GeneratedValue(strategy=GenerationType.AUTO, generator="MEAS_BL_GEN")
    @Id
    private int id;
    @Column(name="BL_USER_ENTERED", nullable=false)
    private boolean userEntered = false;
    @Column(name="BL_MIN", nullable=false)
    private double baselineMin;
    @Column(name="BL_MAX", nullable=false)
    private double baselineMax;
    @Column(name="BL_MEAN", nullable=false)
    private double baselineMean;
    @Column(name="BL_COMPUTE_TIME", nullable=false)
    private long computeTime = System.currentTimeMillis();
    @JoinColumn(name="SCHEDULE_ID", nullable=false)
    @OneToOne(fetch=FetchType.LAZY)
    private MeasurementSchedule schedule;
    @Column(name="SCHEDULE_ID", nullable=false, insertable=false, updatable=false)
    private int scheduleId;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public MeasurementSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(MeasurementSchedule schedule) {
        this.schedule = schedule;
        this.schedule.setBaseline(this);
        this.scheduleId = schedule.getId();
    }

    public Date getComputeTime() {
        return new Date(this.computeTime);
    }

    @PrePersist
    @PreUpdate
    private void setComputeTime() {
        this.computeTime = System.currentTimeMillis();
    }

    public Double getMax() {
        return this.baselineMax;
    }

    public void setMax(Double max) {
        this.baselineMax = max;
    }

    public Double getMean() {
        return this.baselineMean;
    }

    public void setMean(Double mean) {
        this.baselineMean = mean;
    }

    public Double getMin() {
        return this.baselineMin;
    }

    public void setMin(Double min) {
        this.baselineMin = min;
    }

    public boolean isUserEntered() {
        return this.userEntered;
    }

    public void setUserEntered(boolean userEntered) {
        this.userEntered = userEntered;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MeasurementBaseline");
        sb.append("{id=").append(this.id);
        sb.append(", userEntered=").append(this.userEntered);
        sb.append(", baselineMin=").append(this.baselineMin);
        sb.append(", baselineMax=").append(this.baselineMax);
        sb.append(", baselineMean=").append(this.baselineMean);
        sb.append(", computeTime=").append(this.computeTime);
        sb.append(", scheduleId=").append(this.scheduleId);
        sb.append('}');
        return sb.toString();
    }
}

